/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainerHolder;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorMemberBin;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorPartition;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorServiceProxy;
import com.hazelcast.scheduledexecutor.impl.ScheduledFutureProxy;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class DistributedScheduledExecutorService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:scheduledExecutorService";
    public static final int MEMBER_BIN = -1;
    private NodeEngine nodeEngine;
    private ScheduledExecutorPartition[] partitions;
    private ScheduledExecutorMemberBin memberBin;
    private final ConcurrentMap<String, Boolean> shutdownExecutors = new ConcurrentHashMap<String, Boolean>();
    private final Set<ScheduledFutureProxy> lossListeners = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final AtomicBoolean migrationMode = new AtomicBoolean();
    private String partitionLostRegistration;
    private String membershipListenerRegistration;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.nodeEngine = nodeEngine;
        this.partitions = new ScheduledExecutorPartition[partitionCount];
        this.reset();
    }

    public ScheduledExecutorPartition getPartition(int partitionId) {
        return this.partitions[partitionId];
    }

    public ScheduledExecutorContainerHolder getPartitionOrMemberBin(int id) {
        if (id == -1) {
            return this.memberBin;
        }
        return this.getPartition(id);
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    public void reset() {
        this.shutdown(true);
        this.memberBin = new ScheduledExecutorMemberBin(this.nodeEngine);
        if (this.partitionLostRegistration == null) {
            this.registerPartitionListener();
        }
        if (this.membershipListenerRegistration == null) {
            this.registerMembershipListener();
        }
        for (int partitionId = 0; partitionId < this.partitions.length; ++partitionId) {
            if (this.partitions[partitionId] != null) {
                this.partitions[partitionId].destroy();
            }
            this.partitions[partitionId] = new ScheduledExecutorPartition(this.nodeEngine, partitionId);
        }
    }

    @Override
    public void shutdown(boolean terminate) {
        this.shutdownExecutors.clear();
        if (this.memberBin != null) {
            this.memberBin.destroy();
        }
        this.lossListeners.clear();
        this.unRegisterPartitionListenerIfExists();
        this.unRegisterMembershipListenerIfExists();
        for (int partitionId = 0; partitionId < this.partitions.length; ++partitionId) {
            if (this.partitions[partitionId] == null) continue;
            this.partitions[partitionId].destroy();
        }
    }

    void addLossListener(ScheduledFutureProxy future) {
        this.lossListeners.add(future);
    }

    @Override
    public DistributedObject createDistributedObject(String name) {
        return new ScheduledExecutorServiceProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        if (this.shutdownExecutors.remove(name) == null) {
            ((InternalExecutionService)this.nodeEngine.getExecutionService()).shutdownScheduledDurableExecutor(name);
        }
        this.resetPartitionOrMemberBinContainer(name);
    }

    public void shutdownExecutor(String name) {
        if (this.shutdownExecutors.putIfAbsent(name, Boolean.TRUE) == null) {
            ((InternalExecutionService)this.nodeEngine.getExecutionService()).shutdownScheduledDurableExecutor(name);
        }
    }

    public boolean isShutdown(String name) {
        return this.shutdownExecutors.containsKey(name);
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        ScheduledExecutorPartition partition = this.partitions[partitionId];
        return partition.prepareReplicationOperation(event.getReplicaIndex(), this.migrationMode.get());
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
        this.migrationMode.compareAndSet(false, true);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        int partitionId = event.getPartitionId();
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.discardStash(partitionId, event.getNewReplicaIndex());
        } else if (event.getNewReplicaIndex() == 0) {
            ScheduledExecutorPartition partition = this.partitions[partitionId];
            partition.promoteStash();
        }
        this.migrationMode.set(false);
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        int partitionId = event.getPartitionId();
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.discardStash(event.getPartitionId(), event.getCurrentReplicaIndex());
        } else if (event.getCurrentReplicaIndex() == 0) {
            ScheduledExecutorPartition partition = this.partitions[partitionId];
            partition.promoteStash();
        }
        this.migrationMode.set(false);
    }

    private void discardStash(int partitionId, int thresholdReplicaIndex) {
        ScheduledExecutorPartition partition = this.partitions[partitionId];
        partition.disposeObsoleteReplicas(thresholdReplicaIndex);
    }

    private void resetPartitionOrMemberBinContainer(String name) {
        if (this.memberBin != null) {
            this.memberBin.destroyContainer(name);
        }
        for (ScheduledExecutorPartition partition : this.partitions) {
            partition.destroyContainer(name);
        }
    }

    private void registerPartitionListener() {
        this.partitionLostRegistration = this.getNodeEngine().getPartitionService().addPartitionLostListener(new PartitionLostListener(){

            @Override
            public void partitionLost(PartitionLostEvent event) {
                ScheduledFutureProxy[] futures;
                for (ScheduledFutureProxy future : futures = DistributedScheduledExecutorService.this.lossListeners.toArray(new ScheduledFutureProxy[DistributedScheduledExecutorService.this.lossListeners.size()])) {
                    future.notifyPartitionLost(event);
                }
            }
        });
    }

    private void unRegisterPartitionListenerIfExists() {
        block3: {
            if (this.partitionLostRegistration == null) {
                return;
            }
            try {
                this.getNodeEngine().getPartitionService().removePartitionLostListener(this.partitionLostRegistration);
            }
            catch (Exception ex) {
                if (!(ExceptionUtil.peel(ex, HazelcastInstanceNotActiveException.class, null) instanceof HazelcastInstanceNotActiveException)) break block3;
                throw ExceptionUtil.rethrow(ex);
            }
        }
        this.partitionLostRegistration = null;
    }

    private void registerMembershipListener() {
        this.membershipListenerRegistration = this.getNodeEngine().getClusterService().addMembershipListener(new MembershipAdapter(){

            @Override
            public void memberRemoved(MembershipEvent event) {
                ScheduledFutureProxy[] futures;
                for (ScheduledFutureProxy future : futures = DistributedScheduledExecutorService.this.lossListeners.toArray(new ScheduledFutureProxy[DistributedScheduledExecutorService.this.lossListeners.size()])) {
                    future.notifyMemberLost(event);
                }
            }
        });
    }

    private void unRegisterMembershipListenerIfExists() {
        block3: {
            if (this.membershipListenerRegistration == null) {
                return;
            }
            try {
                this.getNodeEngine().getClusterService().removeMembershipListener(this.membershipListenerRegistration);
            }
            catch (Exception ex) {
                if (!(ExceptionUtil.peel(ex, HazelcastInstanceNotActiveException.class, null) instanceof HazelcastInstanceNotActiveException)) break block3;
                throw ExceptionUtil.rethrow(ex);
            }
        }
        this.membershipListenerRegistration = null;
    }
}

