/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.fd;

import com.hazelcast.core.Member;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PingFailureDetector {
    private final int maxPingAttempts;
    private final ConcurrentMap<Member, AtomicInteger> pingAttempts = new ConcurrentHashMap<Member, AtomicInteger>();

    public PingFailureDetector(int maxPingAttempts) {
        this.maxPingAttempts = maxPingAttempts;
    }

    public void heartbeat(Member member) {
        this.getAttempts(member).set(0);
    }

    public void logAttempt(Member member) {
        this.getAttempts(member).incrementAndGet();
    }

    public boolean isAlive(Member member) {
        AtomicInteger attempts = (AtomicInteger)this.pingAttempts.get(member);
        return attempts != null && attempts.get() < this.maxPingAttempts;
    }

    public void remove(Member member) {
        this.pingAttempts.remove(member);
    }

    public void reset() {
        this.pingAttempts.clear();
    }

    private AtomicInteger getAttempts(Member member) {
        AtomicInteger existing = (AtomicInteger)this.pingAttempts.get(member);
        AtomicInteger newAttempts = null;
        if (existing == null) {
            newAttempts = new AtomicInteger();
            existing = this.pingAttempts.putIfAbsent(member, newAttempts);
        }
        return existing != null ? existing : newAttempts;
    }
}

