/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CacheSimpleEntryListenerConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.LockConfig;
import com.hazelcast.config.MCMutualAuthConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SemaphoreConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.ServiceConfig;
import com.hazelcast.config.ServicesConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.StringUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class ConfigXmlGenerator {
    protected static final String MASK_FOR_SESITIVE_DATA = "****";
    private static final ILogger LOGGER = Logger.getLogger(ConfigXmlGenerator.class);
    private static final int INDENT = 5;
    private final boolean formatted;

    public ConfigXmlGenerator() {
        this(true);
    }

    public ConfigXmlGenerator(boolean formatted) {
        this.formatted = formatted;
    }

    public String generate(Config config) {
        Preconditions.isNotNull(config, "Config");
        StringBuilder xml = new StringBuilder();
        XmlGenerator gen = new XmlGenerator(xml);
        xml.append("<hazelcast ").append("xmlns=\"http://www.hazelcast.com/schema/config\"\n").append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n").append("xsi:schemaLocation=\"http://www.hazelcast.com/schema/config ").append("http://www.hazelcast.com/schema/config/hazelcast-config-3.9.xsd\">");
        gen.open("group", new Object[0]).node("name", config.getGroupConfig().getName(), new Object[0]).node("password", MASK_FOR_SESITIVE_DATA, new Object[0]).close().node("license-key", MASK_FOR_SESITIVE_DATA, new Object[0]).node("instance-name", config.getInstanceName(), new Object[0]);
        ConfigXmlGenerator.manCenterXmlGenerator(gen, config);
        gen.appendProperties(config.getProperties());
        ConfigXmlGenerator.wanReplicationXmlGenerator(gen, config);
        ConfigXmlGenerator.networkConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.mapConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.replicatedMapConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.cacheConfigXmlGenerator(gen, config);
        ConfigXmlGenerator.queueXmlGenerator(gen, config);
        ConfigXmlGenerator.multiMapXmlGenerator(gen, config);
        ConfigXmlGenerator.collectionXmlGenerator(gen, "list", config.getListConfigs().values());
        ConfigXmlGenerator.collectionXmlGenerator(gen, "set", config.getSetConfigs().values());
        ConfigXmlGenerator.topicXmlGenerator(gen, config);
        ConfigXmlGenerator.semaphoreXmlGenerator(gen, config);
        ConfigXmlGenerator.lockXmlGenerator(gen, config);
        ConfigXmlGenerator.ringbufferXmlGenerator(gen, config);
        ConfigXmlGenerator.executorXmlGenerator(gen, config);
        ConfigXmlGenerator.durableExecutorXmlGenerator(gen, config);
        ConfigXmlGenerator.scheduledExecutorXmlGenerator(gen, config);
        ConfigXmlGenerator.eventJournalXmlGenerator(gen, config);
        ConfigXmlGenerator.partitionGroupXmlGenerator(gen, config);
        ConfigXmlGenerator.cardinalityEstimatorXmlGenerator(gen, config);
        ConfigXmlGenerator.listenerXmlGenerator(gen, config);
        ConfigXmlGenerator.serializationXmlGenerator(gen, config);
        ConfigXmlGenerator.reliableTopicXmlGenerator(gen, config);
        ConfigXmlGenerator.liteMemberXmlGenerator(gen, config);
        ConfigXmlGenerator.nativeMemoryXmlGenerator(gen, config);
        ConfigXmlGenerator.servicesXmlGenerator(gen, config);
        ConfigXmlGenerator.hotRestartXmlGenerator(gen, config);
        xml.append("</hazelcast>");
        return this.format(xml.toString(), 5);
    }

    private static void manCenterXmlGenerator(XmlGenerator gen, Config config) {
        if (config.getManagementCenterConfig() != null) {
            ManagementCenterConfig mcConfig = config.getManagementCenterConfig();
            gen.open("management-center", "enabled", mcConfig.isEnabled(), "update-interval", mcConfig.getUpdateInterval());
            gen.node("url", mcConfig.getUrl(), new Object[0]);
            if (mcConfig.getUrl() != null) {
                ConfigXmlGenerator.mcMutualAuthConfigXmlGenerator(gen, config.getManagementCenterConfig());
            }
            gen.close();
        }
    }

    private static void collectionXmlGenerator(XmlGenerator gen, String type, Collection<? extends CollectionConfig> configs) {
        if (CollectionUtil.isNotEmpty(configs)) {
            for (CollectionConfig collectionConfig : configs) {
                gen.open(type, "name", collectionConfig.getName()).node("statistics-enabled", collectionConfig.isStatisticsEnabled(), new Object[0]).node("max-size", collectionConfig.getMaxSize(), new Object[0]).node("backup-count", collectionConfig.getBackupCount(), new Object[0]).node("async-backup-count", collectionConfig.getAsyncBackupCount(), new Object[0]);
                ConfigXmlGenerator.appendItemListenerConfigs(gen, collectionConfig.getItemListenerConfigs());
                gen.close();
            }
        }
    }

    private static void replicatedMapConfigXmlGenerator(XmlGenerator gen, Config config) {
        for (ReplicatedMapConfig r : config.getReplicatedMapConfigs().values()) {
            gen.open("replicatedmap", "name", r.getName()).node("in-memory-format", (Object)r.getInMemoryFormat(), new Object[0]).node("concurrency-level", r.getConcurrencyLevel(), new Object[0]).node("replication-delay-millis", r.getReplicationDelayMillis(), new Object[0]).node("async-fillup", r.isAsyncFillup(), new Object[0]).node("statistics-enabled", r.isStatisticsEnabled(), new Object[0]);
            if (!r.getListenerConfigs().isEmpty()) {
                gen.open("entry-listeners", new Object[0]);
                for (ListenerConfig lc : r.getListenerConfigs()) {
                    gen.node("entry-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue(), "local", lc.isLocal());
                }
                gen.close();
            }
            gen.close();
        }
    }

    private static void listenerXmlGenerator(XmlGenerator gen, Config config) {
        if (config.getListenerConfigs().isEmpty()) {
            return;
        }
        gen.open("listeners", new Object[0]);
        for (ListenerConfig lc : config.getListenerConfigs()) {
            gen.node("listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
        }
        gen.close();
    }

    private static void eventJournalXmlGenerator(XmlGenerator gen, Config config) {
        Collection<EventJournalConfig> mapJournalConfigs = config.getMapEventJournalConfigs().values();
        Collection<EventJournalConfig> cacheJournalConfigs = config.getCacheEventJournalConfigs().values();
        for (EventJournalConfig c : mapJournalConfigs) {
            gen.open("event-journal", "enabled", c.isEnabled()).node("mapName", c.getMapName(), new Object[0]).node("capacity", c.getCapacity(), new Object[0]).node("time-to-live-seconds", c.getTimeToLiveSeconds(), new Object[0]).close();
        }
        for (EventJournalConfig c : cacheJournalConfigs) {
            gen.open("event-journal", "enabled", c.isEnabled()).node("cacheName", c.getCacheName(), new Object[0]).node("capacity", c.getCapacity(), new Object[0]).node("time-to-live-seconds", c.getTimeToLiveSeconds(), new Object[0]).close();
        }
    }

    private static void serializationXmlGenerator(XmlGenerator gen, Config config) {
        SerializationConfig c = config.getSerializationConfig();
        if (c == null) {
            return;
        }
        gen.open("serialization", new Object[0]).node("portable-version", c.getPortableVersion(), new Object[0]).node("use-native-byte-order", c.isUseNativeByteOrder(), new Object[0]).node("byte-order", c.getByteOrder(), new Object[0]).node("enable-compression", c.isEnableCompression(), new Object[0]).node("enable-shared-object", c.isEnableSharedObject(), new Object[0]).node("allow-unsafe", c.isAllowUnsafe(), new Object[0]);
        Map<Integer, String> dsfClasses = c.getDataSerializableFactoryClasses();
        Map<Integer, DataSerializableFactory> dsfImpls = c.getDataSerializableFactories();
        if (!MapUtil.isNullOrEmpty(dsfClasses) || !MapUtil.isNullOrEmpty(dsfImpls)) {
            gen.open("data-serializable-factories", new Object[0]);
            ConfigXmlGenerator.appendSerializationFactory(gen, "data-serializable-factory", dsfClasses);
            ConfigXmlGenerator.appendSerializationFactory(gen, "data-serializable-factory", dsfImpls);
            gen.close();
        }
        Map<Integer, String> portableClasses = c.getPortableFactoryClasses();
        Map<Integer, PortableFactory> portableImpls = c.getPortableFactories();
        if (!MapUtil.isNullOrEmpty(portableClasses) || !MapUtil.isNullOrEmpty(portableImpls)) {
            gen.open("portable-factories", new Object[0]);
            ConfigXmlGenerator.appendSerializationFactory(gen, "portable-factory", portableClasses);
            ConfigXmlGenerator.appendSerializationFactory(gen, "portable-factory", portableImpls);
            gen.close();
        }
        Collection<SerializerConfig> serializers = c.getSerializerConfigs();
        GlobalSerializerConfig globalSerializerConfig = c.getGlobalSerializerConfig();
        if (CollectionUtil.isNotEmpty(serializers) || globalSerializerConfig != null) {
            gen.open("serializers", new Object[0]);
            if (globalSerializerConfig != null) {
                gen.node("global-serializer", ConfigXmlGenerator.classNameOrImplClass(globalSerializerConfig.getClassName(), globalSerializerConfig.getImplementation()), "override-java-serialization", globalSerializerConfig.isOverrideJavaSerialization());
            }
            if (CollectionUtil.isNotEmpty(serializers)) {
                for (SerializerConfig serializer : serializers) {
                    gen.node("serializer", null, "type-class", ConfigXmlGenerator.classNameOrClass(serializer.getTypeClassName(), serializer.getTypeClass()), "class-name", ConfigXmlGenerator.classNameOrImplClass(serializer.getClassName(), serializer.getImplementation()));
                }
            }
            gen.close();
        }
        gen.node("check-class-def-errors", c.isCheckClassDefErrors(), new Object[0]).close();
    }

    private static String classNameOrClass(String className, Class clazz) {
        return !StringUtil.isNullOrEmpty(className) ? className : (clazz != null ? clazz.getName() : null);
    }

    private static String classNameOrImplClass(String className, Object impl) {
        return !StringUtil.isNullOrEmpty(className) ? className : (impl != null ? impl.getClass().getName() : null);
    }

    private static void partitionGroupXmlGenerator(XmlGenerator gen, Config config) {
        PartitionGroupConfig pg = config.getPartitionGroupConfig();
        if (pg == null) {
            return;
        }
        gen.open("partition-group", new Object[]{"enabled", pg.isEnabled(), "group-type", pg.getGroupType()});
        Collection<MemberGroupConfig> configs = pg.getMemberGroupConfigs();
        if (CollectionUtil.isNotEmpty(configs)) {
            for (MemberGroupConfig mgConfig : configs) {
                gen.open("member-group", new Object[0]);
                for (String iface : mgConfig.getInterfaces()) {
                    gen.node("interface", iface, new Object[0]);
                }
                gen.close();
            }
        }
        gen.close();
    }

    private static void executorXmlGenerator(XmlGenerator gen, Config config) {
        for (ExecutorConfig ex : config.getExecutorConfigs().values()) {
            gen.open("executor-service", "name", ex.getName()).node("statistics-enabled", ex.isStatisticsEnabled(), new Object[0]).node("pool-size", ex.getPoolSize(), new Object[0]).node("queue-capacity", ex.getQueueCapacity(), new Object[0]).close();
        }
    }

    private static void durableExecutorXmlGenerator(XmlGenerator gen, Config config) {
        for (DurableExecutorConfig ex : config.getDurableExecutorConfigs().values()) {
            gen.open("durable-executor-service", "name", ex.getName()).node("pool-size", ex.getPoolSize(), new Object[0]).node("durability", ex.getDurability(), new Object[0]).node("capacity", ex.getCapacity(), new Object[0]).close();
        }
    }

    private static void scheduledExecutorXmlGenerator(XmlGenerator gen, Config config) {
        for (ScheduledExecutorConfig ex : config.getScheduledExecutorConfigs().values()) {
            gen.open("scheduled-executor-service", "name", ex.getName()).node("pool-size", ex.getPoolSize(), new Object[0]).node("durability", ex.getDurability(), new Object[0]).node("capacity", ex.getCapacity(), new Object[0]).close();
        }
    }

    private static void cardinalityEstimatorXmlGenerator(XmlGenerator gen, Config config) {
        for (CardinalityEstimatorConfig ex : config.getCardinalityEstimatorConfigs().values()) {
            gen.open("cardinality-estimator", "name", ex.getName()).node("backup-count", ex.getBackupCount(), new Object[0]).node("async-backup-count", ex.getAsyncBackupCount(), new Object[0]).close();
        }
    }

    private static void semaphoreXmlGenerator(XmlGenerator gen, Config config) {
        for (SemaphoreConfig sc : config.getSemaphoreConfigs()) {
            gen.open("semaphore", "name", sc.getName()).node("initial-permits", sc.getInitialPermits(), new Object[0]).node("backup-count", sc.getBackupCount(), new Object[0]).node("async-backup-count", sc.getAsyncBackupCount(), new Object[0]).close();
        }
    }

    private static void topicXmlGenerator(XmlGenerator gen, Config config) {
        for (TopicConfig t : config.getTopicConfigs().values()) {
            gen.open("topic", "name", t.getName()).node("statistics-enabled", t.isStatisticsEnabled(), new Object[0]).node("global-ordering-enabled", t.isGlobalOrderingEnabled(), new Object[0]);
            if (!t.getMessageListenerConfigs().isEmpty()) {
                gen.open("message-listeners", new Object[0]);
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    gen.node("message-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            gen.node("multi-threading-enabled", t.isMultiThreadingEnabled(), new Object[0]);
            gen.close();
        }
    }

    private static void reliableTopicXmlGenerator(XmlGenerator gen, Config config) {
        for (ReliableTopicConfig t : config.getReliableTopicConfigs().values()) {
            gen.open("reliable-topic", "name", t.getName()).node("statistics-enabled", t.isStatisticsEnabled(), new Object[0]).node("read-batch-size", t.getReadBatchSize(), new Object[0]).node("topic-overload-policy", (Object)t.getTopicOverloadPolicy(), new Object[0]);
            if (!t.getMessageListenerConfigs().isEmpty()) {
                gen.open("message-listeners", new Object[0]);
                for (ListenerConfig lc : t.getMessageListenerConfigs()) {
                    gen.node("message-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), new Object[0]);
                }
                gen.close();
            }
            gen.close();
        }
    }

    private static void multiMapXmlGenerator(XmlGenerator gen, Config config) {
        for (MultiMapConfig mm : config.getMultiMapConfigs().values()) {
            gen.open("multimap", "name", mm.getName()).node("backup-count", mm.getBackupCount(), new Object[0]).node("async-backup-count", mm.getAsyncBackupCount(), new Object[0]).node("statistics-enabled", mm.isStatisticsEnabled(), new Object[0]).node("binary", mm.isBinary(), new Object[0]).node("value-collection-type", (Object)mm.getValueCollectionType(), new Object[0]);
            if (!mm.getEntryListenerConfigs().isEmpty()) {
                gen.open("entry-listeners", new Object[0]);
                for (EntryListenerConfig lc : mm.getEntryListenerConfigs()) {
                    gen.node("entry-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue(), "local", lc.isLocal());
                }
                gen.close();
            }
            gen.close();
        }
    }

    private static void queueXmlGenerator(XmlGenerator gen, Config config) {
        Collection<QueueConfig> qCfgs = config.getQueueConfigs().values();
        for (QueueConfig q : qCfgs) {
            gen.open("queue", "name", q.getName()).node("statistics-enabled", q.isStatisticsEnabled(), new Object[0]).node("max-size", q.getMaxSize(), new Object[0]).node("backup-count", q.getBackupCount(), new Object[0]).node("async-backup-count", q.getAsyncBackupCount(), new Object[0]).node("empty-queue-ttl", q.getEmptyQueueTtl(), new Object[0]);
            ConfigXmlGenerator.appendItemListenerConfigs(gen, q.getItemListenerConfigs());
            QueueStoreConfig storeConfig = q.getQueueStoreConfig();
            if (storeConfig != null) {
                gen.open("queue-store", "enabled", storeConfig.isEnabled()).node("class-name", storeConfig.getClassName(), new Object[0]).node("factory-class-name", storeConfig.getFactoryClassName(), new Object[0]).appendProperties(storeConfig.getProperties()).close();
            }
            gen.node("quorum-ref", q.getQuorumName(), new Object[0]).close();
        }
    }

    private static void lockXmlGenerator(XmlGenerator gen, Config config) {
        for (LockConfig c : config.getLockConfigs().values()) {
            gen.open("lock", "name", c.getName()).node("quorum-ref", c.getQuorumName(), new Object[0]).close();
        }
    }

    private static void ringbufferXmlGenerator(XmlGenerator gen, Config config) {
        Collection<RingbufferConfig> configs = config.getRingbufferConfigs().values();
        for (RingbufferConfig rbConfig : configs) {
            gen.open("ringbuffer", "name", rbConfig.getName()).node("capacity", rbConfig.getCapacity(), new Object[0]).node("time-to-live-seconds", rbConfig.getTimeToLiveSeconds(), new Object[0]).node("backup-count", rbConfig.getBackupCount(), new Object[0]).node("async-backup-count", rbConfig.getAsyncBackupCount(), new Object[0]).node("in-memory-format", (Object)rbConfig.getInMemoryFormat(), new Object[0]);
            RingbufferStoreConfig storeConfig = rbConfig.getRingbufferStoreConfig();
            if (storeConfig != null) {
                gen.open("ringbuffer-store", "enabled", storeConfig.isEnabled()).node("class-name", storeConfig.getClassName(), new Object[0]).node("factory-class-name", storeConfig.getFactoryClassName(), new Object[0]).appendProperties(storeConfig.getProperties());
                gen.close();
            }
            gen.close();
        }
    }

    private static void wanReplicationXmlGenerator(XmlGenerator gen, Config config) {
        for (WanReplicationConfig wan : config.getWanReplicationConfigs().values()) {
            gen.open("wan-replication", "name", wan.getName());
            for (WanPublisherConfig p : wan.getWanPublisherConfigs()) {
                gen.open("wan-publisher", "group-name", p.getGroupName()).node("class-name", p.getClassName(), new Object[0]).node("queue-full-behavior", (Object)p.getQueueFullBehavior(), new Object[0]).node("queue-capacity", p.getQueueCapacity(), new Object[0]).appendProperties(p.getProperties());
                ConfigXmlGenerator.awsConfigXmlGenerator(gen, p.getAwsConfig());
                ConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, p.getDiscoveryConfig());
                gen.close();
            }
            WanConsumerConfig consumerConfig = wan.getWanConsumerConfig();
            if (consumerConfig != null) {
                gen.open("wan-consumer", new Object[0]).node("class-name", ConfigXmlGenerator.classNameOrImplClass(consumerConfig.getClassName(), consumerConfig.getImplementation()), new Object[0]).appendProperties(consumerConfig.getProperties()).close();
            }
            gen.close();
        }
    }

    private static void networkConfigXmlGenerator(XmlGenerator gen, Config config) {
        NetworkConfig netCfg = config.getNetworkConfig();
        gen.open("network", new Object[0]).node("public-address", netCfg.getPublicAddress(), new Object[0]).node("port", netCfg.getPort(), "port-count", netCfg.getPortCount(), "auto-increment", netCfg.isPortAutoIncrement()).node("reuse-address", netCfg.isReuseAddress(), new Object[0]);
        Collection<String> outboundPortDefinitions = netCfg.getOutboundPortDefinitions();
        if (CollectionUtil.isNotEmpty(outboundPortDefinitions)) {
            gen.open("outbound-ports", new Object[0]);
            for (String def : outboundPortDefinitions) {
                gen.node("ports", def, new Object[0]);
            }
            gen.close();
        }
        JoinConfig join = netCfg.getJoin();
        gen.open("join", new Object[0]);
        ConfigXmlGenerator.multicastConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.tcpConfigXmlGenerator(gen, join);
        ConfigXmlGenerator.awsConfigXmlGenerator(gen, join.getAwsConfig());
        ConfigXmlGenerator.discoveryStrategyConfigXmlGenerator(gen, join.getDiscoveryConfig());
        gen.close();
        ConfigXmlGenerator.interfacesConfigXmlGenerator(gen, netCfg);
        ConfigXmlGenerator.sslConfigXmlGenerator(gen, netCfg);
        ConfigXmlGenerator.socketInterceptorConfigXmlGenerator(gen, netCfg);
        ConfigXmlGenerator.symmetricEncInterceptorConfigXmlGenerator(gen, netCfg);
        ConfigXmlGenerator.memberAddressProviderConfigXmlGenerator(gen, netCfg);
        gen.close();
    }

    private static void mapConfigXmlGenerator(XmlGenerator gen, Config config) {
        Collection<MapConfig> mCfgs = config.getMapConfigs().values();
        for (MapConfig m : mCfgs) {
            String cacheDeserializedVal = m.getCacheDeserializedValues() != null ? m.getCacheDeserializedValues().name().replaceAll("_", "-") : null;
            gen.open("map", "name", m.getName()).node("in-memory-format", (Object)m.getInMemoryFormat(), new Object[0]).node("statistics-enabled", m.isStatisticsEnabled(), new Object[0]).node("optimize-queries", m.isOptimizeQueries(), new Object[0]).node("cache-deserialized-values", cacheDeserializedVal, new Object[0]).node("backup-count", m.getBackupCount(), new Object[0]).node("async-backup-count", m.getAsyncBackupCount(), new Object[0]).node("time-to-live-seconds", m.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", m.getMaxIdleSeconds(), new Object[0]).node("eviction-policy", (Object)m.getEvictionPolicy(), new Object[0]).node("max-size", m.getMaxSizeConfig().getSize(), new Object[]{"policy", m.getMaxSizeConfig().getMaxSizePolicy()}).node("eviction-percentage", m.getEvictionPercentage(), new Object[0]).node("min-eviction-check-millis", m.getMinEvictionCheckMillis(), new Object[0]).node("merge-policy", m.getMergePolicy(), new Object[0]).node("read-backup-data", m.isReadBackupData(), new Object[0]);
            ConfigXmlGenerator.appendHotRestartConfig(gen, m.getHotRestartConfig());
            ConfigXmlGenerator.mapStoreConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapNearCacheConfigXmlGenerator(gen, m.getNearCacheConfig());
            ConfigXmlGenerator.wanReplicationConfigXmlGenerator(gen, m.getWanReplicationRef());
            ConfigXmlGenerator.mapIndexConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapAttributeConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapEntryListenerConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapPartitionLostListenerConfigXmlGenerator(gen, m);
            ConfigXmlGenerator.mapPartitionStrategyConfigXmlGenerator(gen, m);
            gen.close();
        }
    }

    private static void appendHotRestartConfig(XmlGenerator gen, HotRestartConfig m) {
        gen.open("hot-restart", "enabled", m != null && m.isEnabled()).node("fsync", m != null && m.isFsync(), new Object[0]).close();
    }

    private static void cacheConfigXmlGenerator(XmlGenerator gen, Config config) {
        for (CacheSimpleConfig c : config.getCacheConfigs().values()) {
            gen.open("cache", "name", c.getName());
            if (c.getKeyType() != null) {
                gen.node("key-type", null, "class-name", c.getKeyType());
            }
            if (c.getValueType() != null) {
                gen.node("value-type", null, "class-name", c.getValueType());
            }
            gen.node("statistics-enabled", c.isStatisticsEnabled(), new Object[0]).node("management-enabled", c.isManagementEnabled(), new Object[0]).node("read-through", c.isReadThrough(), new Object[0]).node("write-through", c.isWriteThrough(), new Object[0]);
            ConfigXmlGenerator.checkAndFillCacheLoaderFactoryConfigXml(gen, c.getCacheLoaderFactory());
            ConfigXmlGenerator.checkAndFillCacheLoaderConfigXml(gen, c.getCacheLoader());
            ConfigXmlGenerator.checkAndFillCacheWriterFactoryConfigXml(gen, c.getCacheWriterFactory());
            ConfigXmlGenerator.checkAndFillCacheWriterConfigXml(gen, c.getCacheWriter());
            ConfigXmlGenerator.cacheExpiryPolicyFactoryConfigXmlGenerator(gen, c.getExpiryPolicyFactoryConfig());
            gen.open("cache-entry-listeners", new Object[0]);
            for (CacheSimpleEntryListenerConfig el : c.getCacheEntryListeners()) {
                gen.open("cache-entry-listener", "old-value-required", el.isOldValueRequired(), "synchronous", el.isSynchronous()).node("cache-entry-listener-factory", null, "class-name", el.getCacheEntryListenerFactory()).node("cache-entry-event-filter-factory", null, "class-name", el.getCacheEntryEventFilterFactory()).close();
            }
            gen.close().node("in-memory-format", (Object)c.getInMemoryFormat(), new Object[0]).node("backup-count", c.getBackupCount(), new Object[0]).node("async-backup-count", c.getAsyncBackupCount(), new Object[0]);
            ConfigXmlGenerator.evictionConfigXmlGenerator(gen, c.getEvictionConfig());
            ConfigXmlGenerator.wanReplicationConfigXmlGenerator(gen, c.getWanReplicationRef());
            gen.node("quorum-ref", c.getQuorumName(), new Object[0]);
            ConfigXmlGenerator.cachePartitionLostListenerConfigXmlGenerator(gen, c.getPartitionLostListenerConfigs());
            gen.node("merge-policy", c.getMergePolicy(), new Object[0]);
            ConfigXmlGenerator.appendHotRestartConfig(gen, c.getHotRestartConfig());
            gen.node("disable-per-entry-invalidation-events", c.isDisablePerEntryInvalidationEvents(), new Object[0]).close();
        }
    }

    private static void checkAndFillCacheWriterFactoryConfigXml(XmlGenerator gen, String cacheWriter) {
        if (StringUtil.isNullOrEmpty(cacheWriter)) {
            return;
        }
        gen.node("cache-writer-factory", null, "class-name", cacheWriter);
    }

    private static void checkAndFillCacheWriterConfigXml(XmlGenerator gen, String cacheWriter) {
        if (StringUtil.isNullOrEmpty(cacheWriter)) {
            return;
        }
        gen.node("cache-writer", null, "class-name", cacheWriter);
    }

    private static void checkAndFillCacheLoaderFactoryConfigXml(XmlGenerator gen, String cacheLoader) {
        if (StringUtil.isNullOrEmpty(cacheLoader)) {
            return;
        }
        gen.node("cache-loader-factory", null, "class-name", cacheLoader);
    }

    private static void checkAndFillCacheLoaderConfigXml(XmlGenerator gen, String cacheLoader) {
        if (StringUtil.isNullOrEmpty(cacheLoader)) {
            return;
        }
        gen.node("cache-loader", null, "class-name", cacheLoader);
    }

    private static void cacheExpiryPolicyFactoryConfigXmlGenerator(XmlGenerator gen, CacheSimpleConfig.ExpiryPolicyFactoryConfig config) {
        if (config == null) {
            return;
        }
        if (!StringUtil.isNullOrEmpty(config.getClassName())) {
            gen.node("expiry-policy-factory", null, "class-name", config.getClassName());
        } else {
            CacheSimpleConfig.ExpiryPolicyFactoryConfig.TimedExpiryPolicyFactoryConfig timedConfig = config.getTimedExpiryPolicyFactoryConfig();
            if (timedConfig != null && timedConfig.getExpiryPolicyType() != null && timedConfig.getDurationConfig() != null) {
                CacheSimpleConfig.ExpiryPolicyFactoryConfig.DurationConfig duration = timedConfig.getDurationConfig();
                gen.open("expiry-policy-factory", new Object[0]).node("timed-expiry-policy-factory", null, new Object[]{"expiry-policy-type", timedConfig.getExpiryPolicyType(), "duration-amount", duration.getDurationAmount(), "time-unit", duration.getTimeUnit().name()}).close();
            }
        }
    }

    private static void cachePartitionLostListenerConfigXmlGenerator(XmlGenerator gen, List<CachePartitionLostListenerConfig> configs) {
        if (configs.isEmpty()) {
            return;
        }
        gen.open("partition-lost-listeners", new Object[0]);
        for (CachePartitionLostListenerConfig c : configs) {
            gen.node("partition-lost-listener", ConfigXmlGenerator.classNameOrImplClass(c.getClassName(), c.getImplementation()), new Object[0]);
        }
        gen.close();
    }

    private static void mapPartitionStrategyConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (m.getPartitioningStrategyConfig() != null) {
            PartitioningStrategyConfig psc = m.getPartitioningStrategyConfig();
            gen.node("partition-strategy", ConfigXmlGenerator.classNameOrImplClass(psc.getPartitioningStrategyClass(), psc.getPartitioningStrategy()), new Object[0]);
        }
    }

    private static void mapEntryListenerConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (!m.getEntryListenerConfigs().isEmpty()) {
            gen.open("entry-listeners", new Object[0]);
            for (EntryListenerConfig lc : m.getEntryListenerConfigs()) {
                gen.node("entry-listener", ConfigXmlGenerator.classNameOrImplClass(lc.getClassName(), lc.getImplementation()), "include-value", lc.isIncludeValue(), "local", lc.isLocal());
            }
            gen.close();
        }
    }

    private static void mapPartitionLostListenerConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (!m.getPartitionLostListenerConfigs().isEmpty()) {
            gen.open("partition-lost-listeners", new Object[0]);
            for (MapPartitionLostListenerConfig c : m.getPartitionLostListenerConfigs()) {
                gen.node("partition-lost-listener", ConfigXmlGenerator.classNameOrImplClass(c.getClassName(), c.getImplementation()), new Object[0]);
            }
            gen.close();
        }
    }

    private static void mapIndexConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (!m.getMapIndexConfigs().isEmpty()) {
            gen.open("indexes", new Object[0]);
            for (MapIndexConfig indexCfg : m.getMapIndexConfigs()) {
                gen.node("index", indexCfg.getAttribute(), "ordered", indexCfg.isOrdered());
            }
            gen.close();
        }
    }

    private static void mapAttributeConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (!m.getMapAttributeConfigs().isEmpty()) {
            gen.open("attributes", new Object[0]);
            for (MapAttributeConfig attributeCfg : m.getMapAttributeConfigs()) {
                gen.node("attribute", attributeCfg.getName(), "extractor", attributeCfg.getExtractor());
            }
            gen.close();
        }
    }

    private static void wanReplicationConfigXmlGenerator(XmlGenerator gen, WanReplicationRef wan) {
        if (wan != null) {
            gen.open("wan-replication-ref", "name", wan.getName()).node("merge-policy", wan.getMergePolicy(), new Object[0]);
            List<String> filters = wan.getFilters();
            if (CollectionUtil.isNotEmpty(filters)) {
                gen.open("filters", new Object[0]);
                for (String f : filters) {
                    gen.node("filter-impl", f, new Object[0]);
                }
                gen.close();
            }
            gen.node("republishing-enabled", wan.isRepublishingEnabled(), new Object[0]).close();
        }
    }

    private static void mapStoreConfigXmlGenerator(XmlGenerator gen, MapConfig m) {
        if (m.getMapStoreConfig() != null) {
            MapStoreConfig s = m.getMapStoreConfig();
            String clazz = s.getImplementation() != null ? s.getImplementation().getClass().getName() : s.getClassName();
            String factoryClass = s.getFactoryImplementation() != null ? s.getFactoryImplementation().getClass().getName() : s.getFactoryClassName();
            gen.open("map-store", "enabled", s.isEnabled()).node("class-name", clazz, new Object[0]).node("factory-class-name", factoryClass, new Object[0]).node("write-delay-seconds", s.getWriteDelaySeconds(), new Object[0]).node("write-batch-size", s.getWriteBatchSize(), new Object[0]).appendProperties(s.getProperties()).close();
        }
    }

    private static void mapNearCacheConfigXmlGenerator(XmlGenerator gen, NearCacheConfig n) {
        if (n != null) {
            gen.open("near-cache", new Object[0]).node("in-memory-format", (Object)n.getInMemoryFormat(), new Object[0]).node("invalidate-on-change", n.isInvalidateOnChange(), new Object[0]).node("time-to-live-seconds", n.getTimeToLiveSeconds(), new Object[0]).node("max-idle-seconds", n.getMaxIdleSeconds(), new Object[0]);
            ConfigXmlGenerator.evictionConfigXmlGenerator(gen, n.getEvictionConfig());
            gen.node("eviction-policy", n.getEvictionPolicy(), new Object[0]).node("max-size", n.getMaxSize(), new Object[0]).node("cache-local-entries", n.isCacheLocalEntries(), new Object[0]);
            gen.close();
        }
    }

    private static void evictionConfigXmlGenerator(XmlGenerator gen, EvictionConfig e) {
        if (e == null) {
            return;
        }
        String comparatorClassName = !StringUtil.isNullOrEmpty(e.getComparatorClassName()) ? e.getComparatorClassName() : null;
        gen.node("eviction", null, new Object[]{"size", e.getSize(), "max-size-policy", e.getMaximumSizePolicy(), "eviction-policy", e.getEvictionPolicy(), "comparator-class-name", comparatorClassName});
    }

    private static void multicastConfigXmlGenerator(XmlGenerator gen, JoinConfig join) {
        MulticastConfig mcast = join.getMulticastConfig();
        gen.open("multicast", "enabled", mcast.isEnabled(), "loopbackModeEnabled", mcast.isLoopbackModeEnabled()).node("multicast-group", mcast.getMulticastGroup(), new Object[0]).node("multicast-port", mcast.getMulticastPort(), new Object[0]).node("multicast-timeout-seconds", mcast.getMulticastTimeoutSeconds(), new Object[0]).node("multicast-time-to-live", mcast.getMulticastTimeToLive(), new Object[0]);
        if (!mcast.getTrustedInterfaces().isEmpty()) {
            gen.open("trusted-interfaces", new Object[0]);
            for (String trustedInterface : mcast.getTrustedInterfaces()) {
                gen.node("interface", trustedInterface, new Object[0]);
            }
            gen.close();
        }
        gen.close();
    }

    private static void tcpConfigXmlGenerator(XmlGenerator gen, JoinConfig join) {
        TcpIpConfig c = join.getTcpIpConfig();
        gen.open("tcp-ip", "enabled", c.isEnabled(), "connection-timeout-seconds", c.getConnectionTimeoutSeconds()).open("member-list", new Object[0]);
        for (String m : c.getMembers()) {
            gen.node("member", m, new Object[0]);
        }
        gen.close().node("required-member", c.getRequiredMember(), new Object[0]).close();
    }

    private static void awsConfigXmlGenerator(XmlGenerator gen, AwsConfig c) {
        if (c == null) {
            return;
        }
        gen.open("aws", "enabled", c.isEnabled()).node("access-key", c.getAccessKey(), new Object[0]).node("secret-key", c.getSecretKey(), new Object[0]).node("iam-role", c.getIamRole(), new Object[0]).node("region", c.getRegion(), new Object[0]).node("host-header", c.getHostHeader(), new Object[0]).node("security-group-name", c.getSecurityGroupName(), new Object[0]).node("tag-key", c.getTagKey(), new Object[0]).node("tag-value", c.getTagValue(), new Object[0]).close();
    }

    private static void discoveryStrategyConfigXmlGenerator(XmlGenerator gen, DiscoveryConfig c) {
        Collection<DiscoveryStrategyConfig> configs;
        if (c == null) {
            return;
        }
        gen.open("discovery-strategies", new Object[0]);
        String nodeFilterClass = ConfigXmlGenerator.classNameOrImplClass(c.getNodeFilterClass(), c.getNodeFilter());
        if (nodeFilterClass != null) {
            gen.node("node-filter", null, "class", nodeFilterClass);
        }
        if (CollectionUtil.isNotEmpty(configs = c.getDiscoveryStrategyConfigs())) {
            for (DiscoveryStrategyConfig config : configs) {
                gen.open("discovery-strategy", "class", ConfigXmlGenerator.classNameOrImplClass(config.getClassName(), config.getDiscoveryStrategyFactory()), "enabled", "true").appendProperties(config.getProperties()).close();
            }
        }
        gen.close();
    }

    private static void interfacesConfigXmlGenerator(XmlGenerator gen, NetworkConfig netCfg) {
        InterfacesConfig interfaces = netCfg.getInterfaces();
        gen.open("interfaces", "enabled", interfaces.isEnabled());
        for (String i : interfaces.getInterfaces()) {
            gen.node("interface", i, new Object[0]);
        }
        gen.close();
    }

    private static void sslConfigXmlGenerator(XmlGenerator gen, NetworkConfig netCfg) {
        SSLConfig ssl = netCfg.getSSLConfig();
        gen.open("ssl", "enabled", ssl != null && ssl.isEnabled());
        if (ssl != null) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)ssl.getProperties());
            if (props.containsKey("trustStorePassword")) {
                props.setProperty("trustStorePassword", MASK_FOR_SESITIVE_DATA);
            }
            if (props.containsKey("keyStorePassword")) {
                props.setProperty("keyStorePassword", MASK_FOR_SESITIVE_DATA);
            }
            gen.node("factory-class-name", ConfigXmlGenerator.classNameOrImplClass(ssl.getFactoryClassName(), ssl.getFactoryImplementation()), new Object[0]).appendProperties(props);
        }
        gen.close();
    }

    private static void mcMutualAuthConfigXmlGenerator(XmlGenerator gen, ManagementCenterConfig mcConfig) {
        MCMutualAuthConfig mutualAuthConfig = mcConfig.getMutualAuthConfig();
        gen.open("mutual-auth", "enabled", mutualAuthConfig != null && mutualAuthConfig.isEnabled());
        if (mutualAuthConfig != null) {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)mutualAuthConfig.getProperties());
            if (props.containsKey("trustStorePassword")) {
                props.setProperty("trustStorePassword", MASK_FOR_SESITIVE_DATA);
            }
            if (props.containsKey("keyStorePassword")) {
                props.setProperty("keyStorePassword", MASK_FOR_SESITIVE_DATA);
            }
            gen.node("factory-class-name", ConfigXmlGenerator.classNameOrImplClass(mutualAuthConfig.getFactoryClassName(), mutualAuthConfig.getFactoryImplementation()), new Object[0]).appendProperties(props);
        }
        gen.close();
    }

    private static void socketInterceptorConfigXmlGenerator(XmlGenerator gen, NetworkConfig netCfg) {
        SocketInterceptorConfig socket = netCfg.getSocketInterceptorConfig();
        gen.open("socket-interceptor", "enabled", socket != null && socket.isEnabled());
        if (socket != null) {
            gen.node("class-name", ConfigXmlGenerator.classNameOrImplClass(socket.getClassName(), socket.getImplementation()), new Object[0]).appendProperties(socket.getProperties());
        }
        gen.close();
    }

    private static void symmetricEncInterceptorConfigXmlGenerator(XmlGenerator gen, NetworkConfig netCfg) {
        SymmetricEncryptionConfig sec = netCfg.getSymmetricEncryptionConfig();
        if (sec == null) {
            return;
        }
        gen.open("symmetric-encryption", "enabled", sec.isEnabled()).node("algorithm", sec.getAlgorithm(), new Object[0]).node("salt", MASK_FOR_SESITIVE_DATA, new Object[0]).node("password", MASK_FOR_SESITIVE_DATA, new Object[0]).node("iteration-count", sec.getIterationCount(), new Object[0]).close();
    }

    private static void memberAddressProviderConfigXmlGenerator(XmlGenerator gen, NetworkConfig netCfg) {
        MemberAddressProviderConfig memberAddressProviderConfig = netCfg.getMemberAddressProviderConfig();
        if (memberAddressProviderConfig == null) {
            return;
        }
        String className = ConfigXmlGenerator.classNameOrImplClass(memberAddressProviderConfig.getClassName(), memberAddressProviderConfig.getImplementation());
        if (StringUtil.isNullOrEmpty(className)) {
            return;
        }
        gen.open("member-address-provider", "enabled", memberAddressProviderConfig.isEnabled()).node("class-name", className, new Object[0]).appendProperties(memberAddressProviderConfig.getProperties()).close();
    }

    private static void hotRestartXmlGenerator(XmlGenerator gen, Config config) {
        HotRestartPersistenceConfig hrCfg = config.getHotRestartPersistenceConfig();
        if (hrCfg == null) {
            gen.node("hot-restart-persistence", "enabled", "false");
            return;
        }
        gen.open("hot-restart-persistence", "enabled", hrCfg.isEnabled()).node("base-dir", hrCfg.getBaseDir().getAbsolutePath(), new Object[0]);
        if (hrCfg.getBackupDir() != null) {
            gen.node("backup-dir", hrCfg.getBackupDir().getAbsolutePath(), new Object[0]);
        }
        gen.node("parallelism", hrCfg.getParallelism(), new Object[0]).node("validation-timeout-seconds", hrCfg.getValidationTimeoutSeconds(), new Object[0]).node("data-load-timeout-seconds", hrCfg.getDataLoadTimeoutSeconds(), new Object[0]).node("cluster-data-recovery-policy", (Object)hrCfg.getClusterDataRecoveryPolicy(), new Object[0]).close();
    }

    private static void nativeMemoryXmlGenerator(XmlGenerator gen, Config config) {
        NativeMemoryConfig nativeMemoryConfig = config.getNativeMemoryConfig();
        if (nativeMemoryConfig == null) {
            gen.node("native-memory", null, "enabled", "false");
            return;
        }
        gen.open("native-memory", new Object[]{"enabled", nativeMemoryConfig.isEnabled(), "allocator-type", nativeMemoryConfig.getAllocatorType()}).node("size", null, new Object[]{"unit", nativeMemoryConfig.getSize().getUnit(), "value", nativeMemoryConfig.getSize().getValue()}).node("min-block-size", nativeMemoryConfig.getMinBlockSize(), new Object[0]).node("page-size", nativeMemoryConfig.getPageSize(), new Object[0]).node("metadata-space-percentage", Float.valueOf(nativeMemoryConfig.getMetadataSpacePercentage()), new Object[0]).close();
    }

    private static void servicesXmlGenerator(XmlGenerator gen, Config config) {
        ServicesConfig c = config.getServicesConfig();
        if (c == null) {
            return;
        }
        gen.open("services", "enable-defaults", c.isEnableDefaults());
        if (CollectionUtil.isNotEmpty(c.getServiceConfigs())) {
            for (ServiceConfig serviceConfig : c.getServiceConfigs()) {
                gen.open("service", "enabled", serviceConfig.isEnabled()).node("name", serviceConfig.getName(), new Object[0]).node("class-name", ConfigXmlGenerator.classNameOrImplClass(serviceConfig.getClassName(), serviceConfig.getImplementation()), new Object[0]).appendProperties(serviceConfig.getProperties()).close();
            }
        }
        gen.close();
    }

    private static void liteMemberXmlGenerator(XmlGenerator gen, Config config) {
        gen.node("lite-member", null, "enabled", config.isLiteMember());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(String input, int indent) {
        if (!this.formatted) {
            return input;
        }
        StreamResult xmlOutput = null;
        try {
            Transformer transformer;
            StreamSource xmlInput;
            block12: {
                TransformerFactory transformerFactory;
                block11: {
                    xmlInput = new StreamSource(new StringReader(input));
                    xmlOutput = new StreamResult(new StringWriter());
                    transformerFactory = TransformerFactory.newInstance();
                    try {
                        transformerFactory.setAttribute("indent-number", indent);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOGGER.isFinestEnabled()) break block11;
                        LOGGER.finest("Failed to set indent-number attribute; cause: " + e.getMessage());
                    }
                }
                transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
                }
                catch (IllegalArgumentException e) {
                    if (!LOGGER.isFinestEnabled()) break block12;
                    LOGGER.finest("Failed to set indent-amount property; cause: " + e.getMessage());
                }
            }
            transformer.transform(xmlInput, xmlOutput);
            String string = xmlOutput.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warning(e);
            String string = input;
            return string;
        }
        finally {
            if (xmlOutput != null) {
                IOUtil.closeResource(xmlOutput.getWriter());
            }
        }
    }

    private static void appendItemListenerConfigs(XmlGenerator gen, Collection<ItemListenerConfig> configs) {
        if (CollectionUtil.isNotEmpty(configs)) {
            gen.open("item-listeners", new Object[0]);
            for (ItemListenerConfig lc : configs) {
                gen.node("item-listener", lc.getClassName(), "include-value", lc.isIncludeValue());
            }
            gen.close();
        }
    }

    private static void appendSerializationFactory(XmlGenerator gen, String elementName, Map<Integer, ?> factoryMap) {
        if (MapUtil.isNullOrEmpty(factoryMap)) {
            return;
        }
        for (Map.Entry<Integer, ?> factory : factoryMap.entrySet()) {
            Object value = factory.getValue();
            String className = value instanceof String ? (String)value : value.getClass().getName();
            gen.node(elementName, className, "factory-id", factory.getKey().toString());
        }
    }

    private static final class XmlGenerator {
        private final StringBuilder xml;
        private final ArrayDeque<String> openNodes = new ArrayDeque();

        private XmlGenerator(StringBuilder xml) {
            this.xml = xml;
        }

        XmlGenerator open(String name, Object ... attributes) {
            XmlGenerator.appendOpenNode(this.xml, name, attributes);
            this.openNodes.addLast(name);
            return this;
        }

        XmlGenerator node(String name, Object contents, Object ... attributes) {
            XmlGenerator.appendNode(this.xml, name, contents, attributes);
            return this;
        }

        XmlGenerator close() {
            XmlGenerator.appendCloseNode(this.xml, this.openNodes.pollLast());
            return this;
        }

        XmlGenerator appendProperties(Properties props) {
            if (!props.isEmpty()) {
                this.open("properties", new Object[0]);
                Set<Object> keys = props.keySet();
                for (Object key : keys) {
                    this.node("property", props.getProperty(key.toString()), "name", key.toString());
                }
                this.close();
            }
            return this;
        }

        XmlGenerator appendProperties(Map<String, Comparable> props) {
            if (!MapUtil.isNullOrEmpty(props)) {
                this.open("properties", new Object[0]);
                for (Map.Entry<String, Comparable> entry : props.entrySet()) {
                    this.node("property", entry.getValue(), "name", entry.getKey());
                }
                this.close();
            }
            return this;
        }

        private static void appendOpenNode(StringBuilder xml, String name, Object ... attributes) {
            xml.append('<').append(name);
            XmlGenerator.appendAttributes(xml, attributes);
            xml.append('>');
        }

        private static void appendCloseNode(StringBuilder xml, String name) {
            xml.append("</").append(name).append('>');
        }

        private static void appendAttributes(StringBuilder xml, Object ... attributes) {
            int i = 0;
            while (i < attributes.length) {
                xml.append(" ").append(attributes[i++]).append("=\"").append(attributes[i++]).append("\"");
            }
        }

        private static void appendNode(StringBuilder xml, String name, Object contents, Object ... attributes) {
            if (contents != null || attributes.length > 0) {
                xml.append('<').append(name);
                int i = 0;
                while (i < attributes.length) {
                    Object val;
                    Object key = attributes[i++];
                    if ((val = attributes[i++]) == null) continue;
                    xml.append(" ").append(key).append("=\"").append(val).append("\"");
                }
                if (contents != null) {
                    xml.append('>').append(contents).append("</").append(name).append('>');
                } else {
                    xml.append("/>");
                }
            }
        }
    }
}

