/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Server;
import org.hsqldb.Trace;
import org.hsqldb.WebServerConnection;
import org.hsqldb.jdbcSystem;

public class WebServer
extends Server {
    static final String mServerName = "HSQLDB/1.7.1";
    String mRoot;
    String mDefaultFile;
    char mPathSeparatorChar;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && (object = stringArray[0]) != null && ((String)object).startsWith("-?")) {
            WebServer.printHelp();
            return;
        }
        object = new WebServer();
        HsqlProperties hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        ((WebServer)object).setProperties(hsqlProperties);
        super.run();
    }

    void setProperties(HsqlProperties hsqlProperties) {
        this.serverProperties = new HsqlProperties("webserver");
        try {
            this.serverProperties.load();
        }
        catch (Exception exception) {
            Trace.printSystemOut("webserver.properties not found, using command line or default properties");
        }
        this.serverProperties.addProperties(hsqlProperties);
        this.serverProperties.setPropertyIfNotExists("server.database", "test");
        this.serverProperties.setPropertyIfNotExists("server.port", "80");
        this.mRoot = this.serverProperties.setPropertyIfNotExists("server.root", "./");
        this.mDefaultFile = this.serverProperties.setPropertyIfNotExists("server.default_page", "index.html");
        if (this.serverProperties.isPropertyTrue("server.trace")) {
            jdbcSystem.setLogToSystem(true);
        }
        this.traceMessages = !this.serverProperties.isPropertyTrue("server.silent", true);
    }

    private void run() {
        Object object;
        this.socket = null;
        try {
            int n = this.serverProperties.getIntegerProperty("server.port", 80);
            object = this.serverProperties.getProperty("server.database");
            Trace.printSystemOut("Opening database: " + (String)object);
            this.printTraceMessages();
            this.mPathSeparatorChar = File.separatorChar;
            this.mDatabase = new Database((String)object);
            this.socket = new ServerSocket(n);
        }
        catch (Exception exception) {
            this.traceError("WebServer.run/init: " + exception);
            return;
        }
        try {
            while (true) {
                Socket socket = this.socket.accept();
                object = new WebServerConnection(socket, this);
                this.thread = new Thread((Runnable)object);
                this.thread.start();
            }
        }
        catch (IOException iOException) {
            this.traceError("WebServer.run/loop: " + iOException.getMessage());
            return;
        }
    }

    static void printHelp() {
        Trace.printSystemOut("Usage: java WebServer [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -root <path>          root path for sending files\n    -default_page <file>  default page when page name is missing\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display JDBC trace messages\nThe command line arguments override the values in the webserver.properties file.");
    }

    void printTraceMessages() {
        this.trace("server.port        =" + this.serverProperties.getProperty("server.port"));
        this.trace("server.database    =" + this.serverProperties.getProperty("server.database"));
        this.trace("server.root        =" + this.serverProperties.getProperty("server.root"));
        this.trace("server.default_page=" + this.serverProperties.getProperty("server.default_page"));
        this.trace("server.silent      =" + this.serverProperties.getProperty("server.silent"));
        Trace.printSystemOut("HSQLDB web server 1.7.1 is running");
        Trace.printSystemOut("Use SHUTDOWN to close normally. Use [Ctrl]+[C] to abort abruptly");
    }
}

