/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.xmpp.forms.DataForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormField {
    private Element element;

    FormField(Element element) {
        this.element = element;
    }

    public void addValue(Object value) {
        if (value == null) {
            return;
        }
        this.element.addElement("value").setText(DataForm.encode(value));
    }

    public void clearValues() {
        Iterator it = this.element.elementIterator("value");
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public void addOption(String label, String value) {
        if (value == null || value.trim().length() == 0) {
            return;
        }
        Element option = this.element.addElement("option");
        option.addAttribute("label", label);
        option.addElement("value").setText(value);
    }

    public List<Option> getOptions() {
        ArrayList<Option> answer = new ArrayList<Option>();
        Iterator it = this.element.elementIterator("option");
        while (it.hasNext()) {
            answer.add(new Option((Element)it.next()));
        }
        return answer;
    }

    public void setType(Type type) {
        this.element.addAttribute("type", type == null ? null : type.toXMPP());
    }

    public void setVariable(String var) {
        if (var == null || var.trim().length() == 0) {
            return;
        }
        this.element.addAttribute("var", var);
    }

    public void setLabel(String label) {
        if (label == null || label.trim().length() == 0) {
            return;
        }
        this.element.addAttribute("label", label);
    }

    public void setRequired(boolean required) {
        if (this.element.element("required") != null) {
            this.element.remove(this.element.element("required"));
        }
        if (required) {
            this.element.addElement("required");
        }
    }

    public void setDescription(String description) {
        if (this.element.element("desc") != null) {
            this.element.remove(this.element.element("desc"));
        }
        if (description == null || description.trim().length() == 0) {
            return;
        }
        this.element.addElement("desc").setText(description);
    }

    public boolean isRequired() {
        return this.element.element("required") != null;
    }

    public String getVariable() {
        return this.element.attributeValue("var");
    }

    public List<String> getValues() {
        ArrayList<String> answer = new ArrayList<String>();
        Iterator it = this.element.elementIterator("value");
        while (it.hasNext()) {
            answer.add(((Element)it.next()).getTextTrim());
        }
        return answer;
    }

    public String getFirstValue() {
        Iterator it = this.element.elementIterator("value");
        if (it.hasNext()) {
            return ((Element)it.next()).getTextTrim();
        }
        return null;
    }

    public Type getType() {
        String type = this.element.attributeValue("type");
        if (type != null) {
            Type.fromXMPP(type);
        }
        return null;
    }

    public String getLabel() {
        return this.element.attributeValue("label");
    }

    public String getDescription() {
        return this.element.elementTextTrim("desc");
    }

    public FormField createCopy() {
        return new FormField(this.element.createCopy());
    }

    public static class Option {
        private Element element;

        private Option(Element element) {
            this.element = element;
        }

        public String getLabel() {
            return this.element.attributeValue("label");
        }

        public String getValue() {
            return this.element.elementTextTrim("value");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        boolean_type("boolean"),
        fixed("fixed"),
        hidden("hidden"),
        jid_multi("jid-multi"),
        jid_single("jid-single"),
        list_multi("list-multi"),
        list_single("list-single"),
        text_multi("text-multi"),
        text_private("text-private"),
        text_single("text-single");

        private String value;

        public static Type fromXMPP(String type) {
            if (type == null) {
                throw new NullPointerException();
            }
            type = type.toLowerCase();
            if (boolean_type.toXMPP().equals(type)) {
                return boolean_type;
            }
            if (fixed.toXMPP().equals(type)) {
                return fixed;
            }
            if (hidden.toXMPP().equals(type)) {
                return hidden;
            }
            if (jid_multi.toXMPP().equals(type)) {
                return jid_multi;
            }
            if (jid_single.toXMPP().equals(type)) {
                return jid_single;
            }
            if (list_multi.toXMPP().equals(type)) {
                return list_multi;
            }
            if (list_single.toXMPP().equals(type)) {
                return list_single;
            }
            if (text_multi.toXMPP().equals(type)) {
                return text_multi;
            }
            if (text_private.toXMPP().equals(type)) {
                return text_private;
            }
            if (text_single.toXMPP().equals(type)) {
                return text_single;
            }
            throw new IllegalArgumentException("Type invalid:" + type);
        }

        private Type(String value) {
            this.value = value;
        }

        public String toXMPP() {
            return this.value;
        }
    }
}

