/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.control.FormatControl;
import javax.media.control.QualityControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sf.fmj.media.AbstractPacketizer;
import net.sf.fmj.media.codec.video.jpeg.JpegRTPHeader;
import net.sf.fmj.media.codec.video.jpeg.JpegStripper;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.media.util.BufferToImage;
import net.sf.fmj.utility.ArrayUtility;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Packetizer
extends AbstractPacketizer {
    int j = 0;
    private byte typeSpecific = 0;
    private byte type = 1;
    private int quality = 75;
    private int currentQuality;
    private ImageWriter encoder;
    private JPEGHuffmanTable[] huffmanDCTables;
    private JPEGHuffmanTable[] huffmanACTables;
    private JPEGImageWriteParam param;
    private int dri = 0;
    private Buffer temporary = new Buffer();
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private MemoryCacheImageOutputStream out = new MemoryCacheImageOutputStream(this.os);
    private int[] lumaQtable = RFC2035.jpeg_luma_quantizer_normal;
    private int[] chromaQtable = RFC2035.jpeg_chroma_quantizer_normal;
    private static final Logger logger = Logger.getLogger(Packetizer.class.getName());
    private BufferToImage bufferToImage;
    private final Format[] supportedInputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, -1, -1, -1, -1), new RGBFormat(null, -1, Format.intArray, -1.0f, -1, -1, -1, -1)};
    private final Format[] supportedOutputFormats = new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)};
    private static final int PACKET_SIZE = 1000;
    private JPEGQTable[] qtable;
    private static final int RTP_JPEG_RESTART = 64;
    private Format outputVideoFormat;
    private VideoFormat currentFormat;
    private BufferedImage offscreenImage;
    private Graphics imageGraphics;
    private Buffer imageBuffer = new Buffer();

    private static Node createDri(Node node, int n) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("dri");
        iIOMetadataNode.setAttribute("interval", Integer.toString(n));
        NodeList nodeList = node.getChildNodes();
        nodeList.item(1).insertBefore(iIOMetadataNode, nodeList.item(1).getFirstChild());
        return node;
    }

    private static Node find(Node node, String string) {
        int n;
        String[] stringArray = string.split("/");
        String[] stringArray2 = stringArray[0].split(":");
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1) {
            return node;
        }
        String string2 = "";
        for (n = 1; n < stringArray.length; ++n) {
            string2 = string2 + stringArray[n] + (n == stringArray.length - 1 ? "" : "/");
        }
        if (node.getNodeName().equalsIgnoreCase(stringArray2[0]) && (stringArray2.length <= 1 || stringArray2[1].equalsIgnoreCase(node.getNodeValue()))) {
            return Packetizer.find(node, string2);
        }
        for (n = 0; n < node.getChildNodes().getLength(); ++n) {
            Node node2 = node.getChildNodes().item(n);
            if (!node2.getNodeName().equalsIgnoreCase(stringArray[0]) || stringArray2.length > 1 && !stringArray2[1].equalsIgnoreCase(node.getNodeValue())) continue;
            return Packetizer.find(node2, string2);
        }
        return null;
    }

    private static void outputMetadata(Node node, String string) {
        System.out.println(string + node.getNodeName());
        string = "  " + string;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.hasChildNodes()) {
                Packetizer.outputMetadata(node2, string);
            }
            System.out.println(string + node2.getNodeName());
            if (!nodeList.item(i).hasAttributes()) continue;
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            String string2 = "  " + string + "-A:";
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                System.out.println(string2 + namedNodeMap.item(j).getNodeName() + ":" + namedNodeMap.item(j).getNodeValue());
            }
        }
    }

    private static Node setSamplingFactor(Node node, int n, int n2) {
        Node node2 = node.getChildNodes().item(1);
        Node node3 = Packetizer.find(node2, "markerSequence/sof/componentSpec/HsamplingFactor:1");
        node3.getAttributes().getNamedItem("HsamplingFactor").setNodeValue(Integer.toString(n));
        node3.getAttributes().getNamedItem("VsamplingFactor").setNodeValue(Integer.toString(n2));
        return node;
    }

    public Packetizer() {
        this.inputFormats = this.supportedInputFormats;
        this.addControl(new JPEGQualityControl());
        this.addControl(new FC());
    }

    public void close() {
        try {
            this.out.close();
            this.os.close();
            this.encoder.dispose();
        }
        catch (IOException iOException) {
            logger.throwing(this.getClass().getName(), "close", iOException.getCause());
        }
    }

    private JPEGHuffmanTable[] createACHuffmanTables() {
        JPEGHuffmanTable jPEGHuffmanTable = new JPEGHuffmanTable(RFC2035.chm_ac_codelens, RFC2035.chm_ac_symbols);
        JPEGHuffmanTable jPEGHuffmanTable2 = new JPEGHuffmanTable(RFC2035.lum_ac_codelens, RFC2035.lum_ac_symbols);
        JPEGHuffmanTable[] jPEGHuffmanTableArray = new JPEGHuffmanTable[]{jPEGHuffmanTable2, jPEGHuffmanTable};
        return jPEGHuffmanTableArray;
    }

    private JPEGHuffmanTable[] createDCHuffmanTables() {
        JPEGHuffmanTable jPEGHuffmanTable = new JPEGHuffmanTable(RFC2035.chm_dc_codelens, RFC2035.chm_dc_symbols);
        JPEGHuffmanTable jPEGHuffmanTable2 = new JPEGHuffmanTable(RFC2035.lum_dc_codelens, RFC2035.lum_dc_symbols);
        JPEGHuffmanTable[] jPEGHuffmanTableArray = new JPEGHuffmanTable[]{jPEGHuffmanTable2, jPEGHuffmanTable};
        return jPEGHuffmanTableArray;
    }

    private JPEGQTable[] createQTable(int n) {
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        RFC2035.MakeTables(n, byArray, byArray2, RFC2035.jpeg_luma_quantizer_normal, RFC2035.jpeg_chroma_quantizer_normal);
        JPEGQTable jPEGQTable = new JPEGQTable(ArrayUtility.byteArrayToIntArray(byArray));
        JPEGQTable jPEGQTable2 = new JPEGQTable(ArrayUtility.byteArrayToIntArray(byArray2));
        JPEGQTable[] jPEGQTableArray = new JPEGQTable[]{jPEGQTable, jPEGQTable2};
        return jPEGQTableArray;
    }

    protected int doBuildPacketHeader(Buffer buffer, byte[] byArray) {
        VideoFormat videoFormat = (VideoFormat)this.inputFormat;
        int n = videoFormat.getSize().width;
        int n2 = videoFormat.getSize().height;
        int n3 = 0;
        if (null != this.currentFormat) {
            n = this.currentFormat.getSize().width;
            n2 = this.currentFormat.getSize().height;
        }
        byte by = (byte)(n / 8);
        byte by2 = (byte)(n2 / 8);
        JpegRTPHeader jpegRTPHeader = new JpegRTPHeader(this.typeSpecific, buffer.getOffset(), this.type, (byte)this.currentQuality, by, by2);
        byte[] byArray2 = jpegRTPHeader.toBytes();
        System.arraycopy(byArray2, 0, byArray, n3, byArray2.length);
        return n3 += byArray2.length;
    }

    private void dump(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            String string = "";
            for (int i = 0; i < 16; ++i) {
                String string2 = Integer.toHexString(byArray[n2++] & 0xFF);
                string = string + (string2.length() < 2 ? "0" + string2 : string2);
                string = string + " ";
                if (n2 >= n) break;
            }
            System.out.println(string);
        }
        System.out.println(" ");
    }

    public String getName() {
        return "JPEG/RTP Packetizer";
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.supportedOutputFormats;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Format[] formatArray = new Format[]{new VideoFormat("jpeg/rtp", videoFormat.getSize(), -1, Format.byteArray, -1.0f)};
        return formatArray;
    }

    public void open() {
        this.setPacketSize(1000);
        this.setDoNotSpanInputBuffers(true);
        this.temporary.setOffset(0);
        this.encoder = ImageIO.getImageWritersByFormatName("JPEG").next();
        this.param = new JPEGImageWriteParam(null);
        this.huffmanACTables = this.createACHuffmanTables();
        this.huffmanDCTables = this.createDCHuffmanTables();
        this.qtable = this.createQTable(this.quality);
        this.param.setEncodeTables(this.qtable, this.huffmanDCTables, this.huffmanACTables);
        try {
            this.encoder.setOutput(this.out);
            this.encoder.prepareWriteSequence(null);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        BufferedImage bufferedImage = (BufferedImage)this.bufferToImage.createImage(buffer);
        try {
            int n;
            if (this.temporary.getLength() == 0) {
                this.currentQuality = this.quality;
                this.currentFormat = (VideoFormat)this.outputVideoFormat;
                if (null != this.currentFormat && buffer.getFormat() instanceof RGBFormat) {
                    int n2 = this.currentFormat.getSize().width;
                    int n3 = this.currentFormat.getSize().height;
                    Buffer buffer3 = this.imageBuffer;
                    synchronized (buffer3) {
                        if (null == this.offscreenImage) {
                            byte[] byArray = new byte[n2 * n3 * 3];
                            RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
                            RGBFormat rGBFormat2 = new RGBFormat(new Dimension(n2, n3), -1, null, -1.0f, -1, -1, -1, -1, -1, n2 * rGBFormat.getPixelStride(), -1, -1);
                            RGBFormat rGBFormat3 = (RGBFormat)rGBFormat2.intersects(rGBFormat);
                            this.imageBuffer.setData(byArray);
                            this.imageBuffer.setLength(byArray.length);
                            this.imageBuffer.setFormat(rGBFormat3);
                            this.offscreenImage = (BufferedImage)this.bufferToImage.createImage(this.imageBuffer);
                            this.imageGraphics = this.offscreenImage.getGraphics();
                        }
                    }
                    this.imageGraphics.drawImage(bufferedImage, 0, 0, n2, n3, null);
                    bufferedImage = this.offscreenImage;
                }
                this.os.reset();
                this.param.setCompressionMode(2);
                this.param.setCompressionQuality((float)this.currentQuality / 100.0f);
                this.encoder.write(null, new IIOImage(bufferedImage, null, null), this.param);
                byte[] byArray = this.os.toByteArray();
                byArray = JpegStripper.removeHeaders(byArray);
                this.temporary.setData(byArray);
                this.temporary.setLength(byArray.length);
            }
            if ((n = super.process(this.temporary, buffer2)) == 0) {
                this.temporary.setOffset(0);
                buffer2.setFlags(buffer2.getFlags() | 0x800);
            }
            return n;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            buffer2.setDiscard(true);
            buffer2.setLength(0);
            return 1;
        }
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        if (videoFormat.getSize() == null) {
            return null;
        }
        this.bufferToImage = new BufferToImage((VideoFormat)format);
        return super.setInputFormat(format);
    }

    private void setType(int n) {
        this.type = (byte)(n | (this.dri != 0 ? 64 : 0));
    }

    static /* synthetic */ JPEGQTable[] access$502(Packetizer packetizer, JPEGQTable[] jPEGQTableArray) {
        packetizer.qtable = jPEGQTableArray;
        return jPEGQTableArray;
    }

    class JPEGQualityControl
    implements QualityControl,
    Owned {
        JPEGQualityControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return Packetizer.this;
        }

        public float getPreferredQuality() {
            return 0.75f;
        }

        public float getQuality() {
            return (float)Packetizer.this.quality / 100.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return true;
        }

        public float setQuality(float f) {
            Packetizer.this.quality = Math.round(f * 100.0f);
            if (Packetizer.this.quality > 99) {
                Packetizer.this.quality = 99;
            } else if (Packetizer.this.quality < 1) {
                Packetizer.this.quality = 1;
            }
            Packetizer.access$502(Packetizer.this, Packetizer.this.createQTable(Packetizer.this.quality));
            Packetizer.this.param.setEncodeTables(Packetizer.this.qtable, Packetizer.this.huffmanDCTables, Packetizer.this.huffmanACTables);
            return Packetizer.this.quality;
        }
    }

    private class FC
    implements FormatControl,
    Owned {
        private FC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Format getFormat() {
            return Packetizer.this.outputVideoFormat;
        }

        public Object getOwner() {
            return Packetizer.this;
        }

        public Format[] getSupportedFormats() {
            return null;
        }

        public boolean isEnabled() {
            return true;
        }

        public void setEnabled(boolean bl) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Format setFormat(Format format) {
            Packetizer.this.outputVideoFormat = format;
            Buffer buffer = Packetizer.this.imageBuffer;
            synchronized (buffer) {
                Packetizer.this.offscreenImage = null;
                Packetizer.this.imageGraphics = null;
            }
            return Packetizer.this.outputVideoFormat;
        }
    }
}

