/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import org.jitsi.service.neomedia.MediaDirection;
import org.jivesoftware.smack.packet.PacketExtension;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JSONDeserializer {
    public static void deserializeAbstractPacketExtensionAttributes(JSONObject jsonObject, AbstractPacketExtension abstractPacketExtension) {
        for (Map.Entry e : jsonObject.entrySet()) {
            Object value;
            String name;
            Object key = e.getKey();
            if (key == null || (name = key.toString()) == null || (value = e.getValue()) instanceof JSONObject || value instanceof JSONArray) continue;
            abstractPacketExtension.setAttribute(name, value);
        }
    }

    public static <T extends CandidatePacketExtension> T deserializeCandidate(JSONObject candidate, Class<T> candidateIQClass, IceUdpTransportPacketExtension transportIQ) {
        CandidatePacketExtension candidateIQ;
        if (candidate == null) {
            candidateIQ = null;
        } else {
            try {
                candidateIQ = (CandidatePacketExtension)candidateIQClass.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new UndeclaredThrowableException(iae);
            }
            catch (InstantiationException ie) {
                throw new UndeclaredThrowableException(ie);
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(candidate, (AbstractPacketExtension)candidateIQ);
            transportIQ.addChildExtension((PacketExtension)candidateIQ);
        }
        return (T)candidateIQ;
    }

    public static void deserializeCandidates(JSONArray candidates, IceUdpTransportPacketExtension transportIQ) {
        if (candidates != null && !candidates.isEmpty()) {
            for (Object candidate : candidates) {
                JSONDeserializer.deserializeCandidate((JSONObject)candidate, CandidatePacketExtension.class, transportIQ);
            }
        }
    }

    public static ColibriConferenceIQ.Channel deserializeChannel(JSONObject channel, ColibriConferenceIQ.Content contentIQ) {
        ColibriConferenceIQ.Channel channelIQ;
        if (channel == null) {
            channelIQ = null;
        } else {
            int i;
            Object direction = channel.get((Object)"direction");
            Object endpoint = channel.get((Object)"endpoint");
            Object expire = channel.get((Object)"expire");
            Object id = channel.get((Object)"id");
            Object initiator = channel.get((Object)"initiator");
            Object lastN = channel.get((Object)"last-n");
            Object payloadTypes = channel.get((Object)"payload-types");
            Object rtpLevelRelayType = channel.get((Object)"rtp-level-relay-type");
            Object sources = channel.get((Object)"sources");
            Object ssrcs = channel.get((Object)"ssrcs");
            Object transport = channel.get((Object)"transport");
            channelIQ = new ColibriConferenceIQ.Channel();
            if (direction != null) {
                channelIQ.setDirection(MediaDirection.parseString((String)direction.toString()));
            }
            if (endpoint != null) {
                channelIQ.setEndpoint(endpoint.toString());
            }
            if (expire != null && (i = expire instanceof Number ? ((Number)expire).intValue() : Integer.parseInt(expire.toString())) != -1) {
                channelIQ.setExpire(i);
            }
            if (id != null) {
                channelIQ.setID(id.toString());
            }
            if (initiator != null) {
                Boolean b = initiator instanceof Boolean ? (Boolean)initiator : Boolean.valueOf(initiator.toString());
                channelIQ.setInitiator(b);
            }
            if (lastN != null) {
                Integer i2 = lastN instanceof Integer ? (Integer)lastN : (lastN instanceof Number ? Integer.valueOf(((Number)lastN).intValue()) : Integer.valueOf(lastN.toString()));
                channelIQ.setLastN(i2);
            }
            if (payloadTypes != null) {
                JSONDeserializer.deserializePayloadTypes((JSONArray)payloadTypes, channelIQ);
            }
            if (rtpLevelRelayType != null) {
                channelIQ.setRTPLevelRelayType(rtpLevelRelayType.toString());
            }
            if (sources != null) {
                JSONDeserializer.deserializeSources((JSONArray)sources, channelIQ);
            }
            if (ssrcs != null) {
                JSONDeserializer.deserializeSSRCs((JSONArray)ssrcs, channelIQ);
            }
            if (transport != null) {
                JSONDeserializer.deserializeTransport((JSONObject)transport, channelIQ);
            }
            contentIQ.addChannel(channelIQ);
        }
        return channelIQ;
    }

    public static void deserializeChannels(JSONArray channels, ColibriConferenceIQ.Content contentIQ) {
        if (channels != null && !channels.isEmpty()) {
            for (Object channel : channels) {
                JSONDeserializer.deserializeChannel((JSONObject)channel, contentIQ);
            }
        }
    }

    public static ColibriConferenceIQ deserializeConference(JSONObject conference) {
        ColibriConferenceIQ conferenceIQ;
        if (conference == null) {
            conferenceIQ = null;
        } else {
            Object id = conference.get((Object)"id");
            Object contents = conference.get((Object)"contents");
            conferenceIQ = new ColibriConferenceIQ();
            if (id != null) {
                conferenceIQ.setID(id.toString());
            }
            if (contents != null) {
                JSONDeserializer.deserializeContents((JSONArray)contents, conferenceIQ);
            }
        }
        return conferenceIQ;
    }

    public static ColibriConferenceIQ.Content deserializeContent(JSONObject content, ColibriConferenceIQ conferenceIQ) {
        ColibriConferenceIQ.Content contentIQ;
        if (content == null) {
            contentIQ = null;
        } else {
            Object name = content.get((Object)"name");
            Object channels = content.get((Object)"channels");
            contentIQ = conferenceIQ.getOrCreateContent(name == null ? null : name.toString());
            if (channels != null) {
                JSONDeserializer.deserializeChannels((JSONArray)channels, contentIQ);
            }
            conferenceIQ.addContent(contentIQ);
        }
        return contentIQ;
    }

    public static void deserializeContents(JSONArray contents, ColibriConferenceIQ conferenceIQ) {
        if (contents != null && !contents.isEmpty()) {
            for (Object content : contents) {
                JSONDeserializer.deserializeContent((JSONObject)content, conferenceIQ);
            }
        }
    }

    public static DtlsFingerprintPacketExtension deserializeFingerprint(JSONObject fingerprint, IceUdpTransportPacketExtension transportIQ) {
        DtlsFingerprintPacketExtension fingerprintIQ;
        if (fingerprint == null) {
            fingerprintIQ = null;
        } else {
            Object theFingerprint = fingerprint.get((Object)"fingerprint");
            fingerprintIQ = new DtlsFingerprintPacketExtension();
            if (theFingerprint != null) {
                fingerprintIQ.setFingerprint(theFingerprint.toString());
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(fingerprint, (AbstractPacketExtension)fingerprintIQ);
            fingerprintIQ.removeAttribute("fingerprint");
            transportIQ.addChildExtension((PacketExtension)fingerprintIQ);
        }
        return fingerprintIQ;
    }

    public static void deserializeFingerprints(JSONArray fingerprints, IceUdpTransportPacketExtension transportIQ) {
        if (fingerprints != null && !fingerprints.isEmpty()) {
            for (Object fingerprint : fingerprints) {
                JSONDeserializer.deserializeFingerprint((JSONObject)fingerprint, transportIQ);
            }
        }
    }

    public static void deserializeParameters(JSONObject parameters, PayloadTypePacketExtension payloadTypeIQ) {
        if (parameters != null) {
            for (Map.Entry e : parameters.entrySet()) {
                Object name = e.getKey();
                Object value = e.getValue();
                if (name == null && value == null) continue;
                payloadTypeIQ.addParameter(new ParameterPacketExtension(name == null ? null : name.toString(), value == null ? null : value.toString()));
            }
        }
    }

    public static PayloadTypePacketExtension deserializePayloadType(JSONObject payloadType, ColibriConferenceIQ.Channel channelIQ) {
        PayloadTypePacketExtension payloadTypeIQ;
        if (payloadType == null) {
            payloadTypeIQ = null;
        } else {
            Object parameters = payloadType.get((Object)"parameters");
            payloadTypeIQ = new PayloadTypePacketExtension();
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(payloadType, (AbstractPacketExtension)payloadTypeIQ);
            if (parameters != null) {
                JSONDeserializer.deserializeParameters((JSONObject)parameters, payloadTypeIQ);
            }
            channelIQ.addPayloadType(payloadTypeIQ);
        }
        return payloadTypeIQ;
    }

    public static void deserializePayloadTypes(JSONArray payloadTypes, ColibriConferenceIQ.Channel channelIQ) {
        if (payloadTypes != null && !payloadTypes.isEmpty()) {
            for (Object payloadType : payloadTypes) {
                JSONDeserializer.deserializePayloadType((JSONObject)payloadType, channelIQ);
            }
        }
    }

    public static SourcePacketExtension deserializeSource(Object source, ColibriConferenceIQ.Channel channelIQ) {
        SourcePacketExtension sourceIQ;
        if (source == null) {
            sourceIQ = null;
        } else {
            long ssrc;
            try {
                ssrc = JSONDeserializer.deserializeSSRC(source);
            }
            catch (NumberFormatException nfe) {
                ssrc = -1L;
            }
            if (ssrc == -1L) {
                sourceIQ = null;
            } else {
                sourceIQ = new SourcePacketExtension();
                sourceIQ.setSSRC(ssrc);
                channelIQ.addSource(sourceIQ);
            }
        }
        return sourceIQ;
    }

    public static void deserializeSources(JSONArray sources, ColibriConferenceIQ.Channel channelIQ) {
        if (sources != null && !sources.isEmpty()) {
            for (Object source : sources) {
                JSONDeserializer.deserializeSource(source, channelIQ);
            }
        }
    }

    public static int deserializeSSRC(Object o) throws NumberFormatException {
        int i = 0;
        if (o != null) {
            String s;
            i = o instanceof Number ? ((Number)o).intValue() : ((s = o.toString()).startsWith("-") ? Integer.parseInt(s) : (int)Long.parseLong(s));
        }
        return i;
    }

    public static void deserializeSSRCs(JSONArray ssrcs, ColibriConferenceIQ.Channel channelIQ) {
        if (ssrcs != null && !ssrcs.isEmpty()) {
            for (Object ssrc : ssrcs) {
                int ssrcIQ;
                try {
                    ssrcIQ = JSONDeserializer.deserializeSSRC(ssrc);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                channelIQ.addSSRC(ssrcIQ);
            }
        }
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport, ColibriConferenceIQ.Channel channelIQ) {
        Object transportIQ;
        if (transport == null) {
            transportIQ = null;
        } else {
            Object xmlns = transport.get((Object)"xmlns");
            Object fingerprints = transport.get((Object)"fingerprints");
            Object candidateList = transport.get((Object)"candidates");
            Object remoteCandidate = transport.get((Object)"remote-candidate");
            transportIQ = "urn:xmpp:jingle:transports:ice-udp:1".equals(xmlns) ? new IceUdpTransportPacketExtension() : ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlns) ? new RawUdpTransportPacketExtension() : null);
            if (transportIQ != null) {
                JSONDeserializer.deserializeAbstractPacketExtensionAttributes(transport, (AbstractPacketExtension)transportIQ);
                if (fingerprints != null) {
                    JSONDeserializer.deserializeFingerprints((JSONArray)fingerprints, transportIQ);
                }
                if (candidateList != null) {
                    JSONDeserializer.deserializeCandidates((JSONArray)candidateList, transportIQ);
                }
                if (remoteCandidate != null) {
                    JSONDeserializer.deserializeCandidate((JSONObject)remoteCandidate, RemoteCandidatePacketExtension.class, transportIQ);
                }
                channelIQ.setTransport(transportIQ);
            }
        }
        return transportIQ;
    }

    private JSONDeserializer() {
    }
}

