/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.ReplicaErrorLogger;
import com.hazelcast.partition.impl.InternalPartitionImpl;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import java.io.IOException;

public class ReplicaSyncRetryResponse
extends Operation
implements PartitionAwareOperation,
BackupOperation,
UrgentSystemOperation,
MigrationCycleOperation {
    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        partitionService.clearReplicaSync(partitionId, replicaIndex);
        InternalPartitionImpl partition = partitionService.getPartition(partitionId, false);
        boolean isBackup = partition.isOwnerOrBackup(this.getNodeEngine().getThisAddress());
        if (isBackup) {
            partitionService.triggerPartitionReplicaSync(partitionId, replicaIndex, 500L);
        }
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReplicaSyncRetryResponse");
        sb.append("{partition=").append(this.getPartitionId());
        sb.append(", replica=").append(this.getReplicaIndex());
        sb.append('}');
        return sb.toString();
    }
}

