/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.Bits;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.UTFEncoderDecoder;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableDataInput;
import com.hazelcast.nio.serialization.SerializationService;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class ByteArrayObjectDataInput
extends InputStream
implements BufferObjectDataInput,
PortableDataInput {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    ByteBuffer header;
    byte[] data;
    final int size;
    int pos;
    int mark;
    final SerializationService service;
    private byte[] utfBuffer;
    private final boolean bigEndian;

    ByteArrayObjectDataInput(Data data, SerializationService service, ByteOrder byteOrder) {
        this(data.getData(), data.getHeader(), service, byteOrder);
    }

    ByteArrayObjectDataInput(byte[] data, SerializationService service, ByteOrder byteOrder) {
        this(data, null, service, byteOrder);
    }

    private ByteArrayObjectDataInput(byte[] data, byte[] header, SerializationService service, ByteOrder byteOrder) {
        this.data = data;
        this.size = data != null ? data.length : 0;
        this.service = service;
        this.bigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
        this.header = header != null ? ByteBuffer.wrap(header).asReadOnlyBuffer().order(byteOrder) : null;
    }

    @Override
    public int read() throws IOException {
        return this.pos < this.size ? this.data[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(int position) throws IOException {
        return position < this.size ? this.data[position] & 0xFF : -1;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len <= 0) {
            return 0;
        }
        if (this.pos >= this.size) {
            return -1;
        }
        if (this.pos + len > this.size) {
            len = this.size - this.pos;
        }
        System.arraycopy(this.data, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final boolean readBoolean(int position) throws IOException {
        int ch = this.read(position);
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    @Override
    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final byte readByte(int position) throws IOException {
        int ch = this.read(position);
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    @Override
    public final char readChar() throws IOException {
        char c = this.readChar(this.pos);
        this.pos += 2;
        return c;
    }

    @Override
    public char readChar(int position) throws IOException {
        this.checkAvailable(position, 2);
        return Bits.readChar(this.data, position, this.bigEndian);
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public double readDouble(int position) throws IOException {
        return Double.longBitsToDouble(this.readLong(position));
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public float readFloat(int position) throws IOException {
        return Float.intBitsToFloat(this.readInt(position));
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        if (this.read(b) == -1) {
            throw new EOFException("End of stream reached");
        }
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (this.read(b, off, len) == -1) {
            throw new EOFException("End of stream reached");
        }
    }

    @Override
    public final int readInt() throws IOException {
        int i = this.readInt(this.pos);
        this.pos += 4;
        return i;
    }

    @Override
    public int readInt(int position) throws IOException {
        this.checkAvailable(position, 4);
        return Bits.readInt(this.data, position, this.bigEndian);
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long readLong() throws IOException {
        long l = this.readLong(this.pos);
        this.pos += 8;
        return l;
    }

    @Override
    public long readLong(int position) throws IOException {
        this.checkAvailable(position, 8);
        return Bits.readLong(this.data, position, this.bigEndian);
    }

    @Override
    public final short readShort() throws IOException {
        short s = this.readShort(this.pos);
        this.pos += 2;
        return s;
    }

    @Override
    public short readShort(int position) throws IOException {
        this.checkAvailable(position, 2);
        return Bits.readShort(this.data, position, this.bigEndian);
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            byte[] b = new byte[len];
            this.readFully(b);
            return b;
        }
        return new byte[0];
    }

    @Override
    public char[] readCharArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            char[] values = new char[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readChar();
            }
            return values;
        }
        return new char[0];
    }

    @Override
    public int[] readIntArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            int[] values = new int[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readInt();
            }
            return values;
        }
        return new int[0];
    }

    @Override
    public long[] readLongArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            long[] values = new long[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readLong();
            }
            return values;
        }
        return new long[0];
    }

    @Override
    public double[] readDoubleArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            double[] values = new double[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readDouble();
            }
            return values;
        }
        return new double[0];
    }

    @Override
    public float[] readFloatArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            float[] values = new float[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readFloat();
            }
            return values;
        }
        return new float[0];
    }

    @Override
    public short[] readShortArray() throws IOException {
        int len = this.readInt();
        if (len > 0) {
            short[] values = new short[len];
            for (int i = 0; i < len; ++i) {
                values[i] = this.readShort();
            }
            return values;
        }
        return new short[0];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort();
    }

    @Override
    public final String readUTF() throws IOException {
        if (this.utfBuffer == null) {
            this.utfBuffer = new byte[1024];
        }
        return UTFEncoderDecoder.readUTF(this, this.utfBuffer);
    }

    public final Object readObject() throws IOException {
        return this.service.readObject(this);
    }

    @Override
    public final Data readData() throws IOException {
        return this.service.readData(this);
    }

    @Override
    public final long skip(long n) {
        if (n <= 0L || n >= Integer.MAX_VALUE) {
            return 0L;
        }
        return this.skipBytes((int)n);
    }

    @Override
    public final int skipBytes(int n) {
        if (n <= 0) {
            return 0;
        }
        int skip = n;
        int pos = this.position();
        if (pos + skip > this.size) {
            skip = this.size - pos;
        }
        this.position(pos + skip);
        return skip;
    }

    @Override
    public final int position() {
        return this.pos;
    }

    @Override
    public final void position(int newPos) {
        if (newPos > this.size || newPos < 0) {
            throw new IllegalArgumentException();
        }
        this.pos = newPos;
        if (this.mark > this.pos) {
            this.mark = -1;
        }
    }

    final void checkAvailable(int pos, int k) throws IOException {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative pos! -> " + pos);
        }
        if (this.size - pos < k) {
            throw new EOFException("Cannot read " + k + " bytes!");
        }
    }

    @Override
    public final int available() {
        return this.size - this.pos;
    }

    @Override
    public final boolean markSupported() {
        return true;
    }

    @Override
    public final void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public final void reset() {
        this.pos = this.mark;
    }

    @Override
    public final void close() {
        this.header = null;
        this.data = null;
        this.utfBuffer = null;
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.service.getClassLoader();
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ByteBuffer getHeaderBuffer() {
        return this.header != null ? this.header : EMPTY_BUFFER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ByteArrayObjectDataInput");
        sb.append("{size=").append(this.size);
        sb.append(", pos=").append(this.pos);
        sb.append(", mark=").append(this.mark);
        sb.append('}');
        return sb.toString();
    }
}

