/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.tx;

import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.tx.VersionedValue;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnLockAndGetOperation
extends LockAwareOperation {
    private VersionedValue response;
    private String ownerUuid;

    public TxnLockAndGetOperation() {
    }

    public TxnLockAndGetOperation(String name, Data dataKey, long timeout, long ttl, String ownerUuid) {
        super(name, dataKey, ttl);
        this.ownerUuid = ownerUuid;
        this.setWaitTimeout(timeout);
    }

    @Override
    public void run() throws Exception {
        if (!this.recordStore.txnLock(this.getKey(), this.ownerUuid, this.getThreadId(), this.ttl)) {
            throw new TransactionException("Transaction couldn't obtain lock.");
        }
        Record record = this.recordStore.getRecordOrNull(this.dataKey);
        Data value = record == null ? null : this.mapService.getMapServiceContext().toData(record.getValue());
        this.response = new VersionedValue(value, record == null ? 0L : record.getVersion());
    }

    @Override
    public boolean shouldWait() {
        return !this.recordStore.canAcquireLock(this.dataKey, this.ownerUuid, this.getThreadId());
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.ownerUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.ownerUuid = in.readUTF();
    }

    @Override
    public String toString() {
        return "TxnLockAndGetOperation{timeout=" + this.getWaitTimeout() + ", thread=" + this.getThreadId() + '}';
    }
}

