/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MapPermission;
import java.io.IOException;
import java.security.Permission;

public class MapLoadAllKeysRequest
extends InvocationClientRequest {
    protected String name;
    private boolean replaceExistingValues;

    public MapLoadAllKeysRequest() {
    }

    public MapLoadAllKeysRequest(String name, boolean replaceExistingValues) {
        this.name = name;
        this.replaceExistingValues = replaceExistingValues;
    }

    @Override
    public void invoke() {
        this.setSingleConnection();
        MapService mapService = (MapService)this.getService();
        DistributedObject distributedObject = mapService.getMapServiceContext().getNodeEngine().getProxyService().getDistributedObject("hz:impl:mapService", this.name);
        MapProxyImpl mapProxy = (MapProxyImpl)distributedObject;
        mapProxy.loadAll(this.replaceExistingValues);
        ClientEndpoint endpoint = this.getEndpoint();
        endpoint.sendResponse(Boolean.TRUE, this.getCallId());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 48;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "remove");
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeBoolean("r", this.replaceExistingValues);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.replaceExistingValues = reader.readBoolean("r");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "loadAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.replaceExistingValues};
    }
}

