/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryEntry;
import java.io.IOException;
import java.util.Map;

public class QueryEventFilter
extends EntryEventFilter {
    Predicate predicate;

    public QueryEventFilter(boolean includeValue, Data key, Predicate predicate) {
        super(includeValue, key);
        this.predicate = predicate;
    }

    public QueryEventFilter() {
    }

    public Object getPredicate() {
        return this.predicate;
    }

    @Override
    public boolean eval(Object arg) {
        QueryEntry entry = (QueryEntry)arg;
        Data keyData = entry.getKeyData();
        return (this.key == null || this.key.equals(keyData)) && this.predicate.apply((Map.Entry)arg);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        out.writeObject(this.predicate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.predicate = (Predicate)in.readObject();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryEventFilter that = (QueryEventFilter)o;
        return this.predicate.equals(that.predicate);
    }

    @Override
    public int hashCode() {
        return this.predicate.hashCode();
    }
}

