/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.concurrent.atomiclong.AtomicLongService;
import com.hazelcast.concurrent.atomiclong.operations.AddAndGetOperation;
import com.hazelcast.concurrent.atomiclong.operations.AlterAndGetOperation;
import com.hazelcast.concurrent.atomiclong.operations.AlterOperation;
import com.hazelcast.concurrent.atomiclong.operations.ApplyOperation;
import com.hazelcast.concurrent.atomiclong.operations.CompareAndSetOperation;
import com.hazelcast.concurrent.atomiclong.operations.GetAndAddOperation;
import com.hazelcast.concurrent.atomiclong.operations.GetAndAlterOperation;
import com.hazelcast.concurrent.atomiclong.operations.GetAndSetOperation;
import com.hazelcast.concurrent.atomiclong.operations.GetOperation;
import com.hazelcast.concurrent.atomiclong.operations.SetOperation;
import com.hazelcast.core.AsyncAtomicLong;
import com.hazelcast.core.IFunction;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ValidationUtil;

public class AtomicLongProxy
extends AbstractDistributedObject<AtomicLongService>
implements AsyncAtomicLong {
    private final String name;
    private final int partitionId;

    public AtomicLongProxy(String name, NodeEngine nodeEngine, AtomicLongService service) {
        super(nodeEngine, service);
        this.name = name;
        this.partitionId = nodeEngine.getPartitionService().getPartitionId(this.getNameAsPartitionAwareData());
    }

    private <E> InternalCompletableFuture<E> asyncInvoke(Operation operation) {
        try {
            OperationService operationService = this.getNodeEngine().getOperationService();
            return operationService.invokeOnPartition("hz:impl:atomicLongService", operation, this.partitionId);
        }
        catch (Throwable throwable) {
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    @Override
    public long addAndGet(long delta) {
        return (Long)this.asyncAddAndGet(delta).getSafely();
    }

    public InternalCompletableFuture<Long> asyncAddAndGet(long delta) {
        AddAndGetOperation operation = new AddAndGetOperation(this.name, delta);
        return this.asyncInvoke(operation);
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        return (Boolean)this.asyncCompareAndSet(expect, update).getSafely();
    }

    public InternalCompletableFuture<Boolean> asyncCompareAndSet(long expect, long update) {
        CompareAndSetOperation operation = new CompareAndSetOperation(this.name, expect, update);
        return this.asyncInvoke(operation);
    }

    @Override
    public void set(long newValue) {
        this.asyncSet(newValue).getSafely();
    }

    public InternalCompletableFuture<Void> asyncSet(long newValue) {
        SetOperation operation = new SetOperation(this.name, newValue);
        return this.asyncInvoke(operation);
    }

    @Override
    public long getAndSet(long newValue) {
        return (Long)this.asyncGetAndSet(newValue).getSafely();
    }

    public InternalCompletableFuture<Long> asyncGetAndSet(long newValue) {
        GetAndSetOperation operation = new GetAndSetOperation(this.name, newValue);
        return this.asyncInvoke(operation);
    }

    @Override
    public long getAndAdd(long delta) {
        return (Long)this.asyncGetAndAdd(delta).getSafely();
    }

    public InternalCompletableFuture<Long> asyncGetAndAdd(long delta) {
        GetAndAddOperation operation = new GetAndAddOperation(this.name, delta);
        return this.asyncInvoke(operation);
    }

    @Override
    public long decrementAndGet() {
        return (Long)this.asyncDecrementAndGet().getSafely();
    }

    public InternalCompletableFuture<Long> asyncDecrementAndGet() {
        return this.asyncAddAndGet(-1L);
    }

    @Override
    public long get() {
        return (Long)this.asyncGet().getSafely();
    }

    public InternalCompletableFuture<Long> asyncGet() {
        GetOperation operation = new GetOperation(this.name);
        return this.asyncInvoke(operation);
    }

    @Override
    public long incrementAndGet() {
        return (Long)this.asyncIncrementAndGet().getSafely();
    }

    public InternalCompletableFuture<Long> asyncIncrementAndGet() {
        return this.asyncAddAndGet(1L);
    }

    @Override
    public long getAndIncrement() {
        return (Long)this.asyncGetAndIncrement().getSafely();
    }

    public InternalCompletableFuture<Long> asyncGetAndIncrement() {
        return this.asyncGetAndAdd(1L);
    }

    @Override
    public void alter(IFunction<Long, Long> function) {
        this.asyncAlter((IFunction)function).getSafely();
    }

    public InternalCompletableFuture<Void> asyncAlter(IFunction<Long, Long> function) {
        ValidationUtil.isNotNull(function, "function");
        AlterOperation operation = new AlterOperation(this.name, function);
        return this.asyncInvoke(operation);
    }

    @Override
    public long alterAndGet(IFunction<Long, Long> function) {
        return (Long)this.asyncAlterAndGet((IFunction)function).getSafely();
    }

    public InternalCompletableFuture<Long> asyncAlterAndGet(IFunction<Long, Long> function) {
        ValidationUtil.isNotNull(function, "function");
        AlterAndGetOperation operation = new AlterAndGetOperation(this.name, function);
        return this.asyncInvoke(operation);
    }

    @Override
    public long getAndAlter(IFunction<Long, Long> function) {
        return (Long)this.asyncGetAndAlter((IFunction)function).getSafely();
    }

    public InternalCompletableFuture<Long> asyncGetAndAlter(IFunction<Long, Long> function) {
        ValidationUtil.isNotNull(function, "function");
        GetAndAlterOperation operation = new GetAndAlterOperation(this.name, function);
        return this.asyncInvoke(operation);
    }

    @Override
    public <R> R apply(IFunction<Long, R> function) {
        return (R)this.asyncApply((IFunction)function).getSafely();
    }

    public <R> InternalCompletableFuture<R> asyncApply(IFunction<Long, R> function) {
        ValidationUtil.isNotNull(function, "function");
        ApplyOperation<R> operation = new ApplyOperation<R>(this.name, function);
        return this.asyncInvoke(operation);
    }

    @Override
    public String toString() {
        return "IAtomicLong{name='" + this.name + '\'' + '}';
    }
}

