/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionEvent;
import com.hazelcast.collection.CollectionEventFilter;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.list.ListContainer;
import com.hazelcast.collection.list.ListService;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.io.IOException;
import java.util.Collection;

public abstract class CollectionOperation
extends Operation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected String name;
    protected transient Object response;
    private transient CollectionContainer container;

    protected CollectionOperation() {
    }

    protected CollectionOperation(String name) {
        this.name = name;
    }

    protected final ListContainer getOrCreateListContainer() {
        if (this.container == null) {
            ListService service = (ListService)this.getService();
            try {
                this.container = service.getOrCreateContainer(this.name, this instanceof BackupOperation);
            }
            catch (Exception e) {
                throw new RetryableHazelcastException(e);
            }
        }
        return (ListContainer)this.container;
    }

    protected final CollectionContainer getOrCreateContainer() {
        if (this.container == null) {
            CollectionService service = (CollectionService)this.getService();
            try {
                this.container = service.getOrCreateContainer(this.name, this instanceof BackupOperation);
            }
            catch (Exception e) {
                throw new RetryableHazelcastException(e);
            }
        }
        return this.container;
    }

    protected void publishEvent(ItemEventType eventType, Data data) {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(this.getServiceName(), this.name);
        for (EventRegistration registration : registrations) {
            CollectionEventFilter filter = (CollectionEventFilter)registration.getFilter();
            Address address = this.getNodeEngine().getThisAddress();
            boolean includeValue = filter.isIncludeValue();
            CollectionEvent event = new CollectionEvent(this.name, includeValue ? data : null, eventType, address);
            eventService.publishEvent(this.getServiceName(), registration, (Object)event, this.name.hashCode());
        }
    }

    public boolean hasEnoughCapacity(int delta) {
        return this.getOrCreateContainer().hasEnoughCapacity(delta);
    }

    @Override
    public int getFactoryId() {
        return CollectionDataSerializerHook.F_ID;
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
    }
}

