/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;

class FSIndexInput
extends BufferedIndexInput {
    private Descriptor file = null;
    boolean isClone;
    private long length;

    public FSIndexInput(File path) throws IOException {
        this.file = new Descriptor(path, "r");
        this.length = this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readInternal(byte[] b, int offset, int len) throws IOException {
        Descriptor descriptor = this.file;
        synchronized (descriptor) {
            int i;
            long position = this.getFilePointer();
            if (position != this.file.position) {
                this.file.seek(position);
                this.file.position = position;
            }
            int total = 0;
            do {
                if ((i = this.file.read(b, offset + total, len - total)) == -1) {
                    throw new IOException("read past EOF");
                }
                this.file.position += (long)i;
            } while ((total += i) < len);
        }
    }

    public void close() throws IOException {
        if (!this.isClone) {
            this.file.close();
        }
    }

    protected void seekInternal(long position) {
    }

    public long length() {
        return this.length;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public Object clone() {
        FSIndexInput clone = (FSIndexInput)super.clone();
        clone.isClone = true;
        return clone;
    }

    boolean isFDValid() throws IOException {
        return this.file.getFD().valid();
    }

    private class Descriptor
    extends RandomAccessFile {
        public long position;

        public Descriptor(File file, String mode) throws IOException {
            super(file, mode);
        }
    }
}

