/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.clientauthutils;

import gov.nist.core.InternalErrorHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;
import javax.sip.address.URI;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class DigestServerAuthenticationHelper {
    private MessageDigest messageDigest = MessageDigest.getInstance("MD5");
    public static final String DEFAULT_ALGORITHM = "MD5";
    public static final String DEFAULT_SCHEME = "Digest";
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    private String generateNonce() {
        Date date = new Date();
        long time = date.getTime();
        Random rand = new Random();
        long pad = rand.nextLong();
        String nonceString = new Long(time).toString() + new Long(pad).toString();
        byte[] mdbytes = this.messageDigest.digest(nonceString.getBytes());
        return DigestServerAuthenticationHelper.toHexString(mdbytes);
    }

    public void generateChallenge(HeaderFactory headerFactory, Response response, String realm) {
        try {
            ProxyAuthenticateHeader proxyAuthenticate = headerFactory.createProxyAuthenticateHeader(DEFAULT_SCHEME);
            proxyAuthenticate.setParameter("realm", realm);
            proxyAuthenticate.setParameter("nonce", this.generateNonce());
            proxyAuthenticate.setParameter("opaque", "");
            proxyAuthenticate.setParameter("stale", "FALSE");
            proxyAuthenticate.setParameter("algorithm", DEFAULT_ALGORITHM);
            response.setHeader((Header)proxyAuthenticate);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    public boolean doAuthenticateHashedPassword(Request request, String hashedPassword) {
        ProxyAuthorizationHeader authHeader = (ProxyAuthorizationHeader)request.getHeader("Proxy-Authorization");
        if (authHeader == null) {
            return false;
        }
        String realm = authHeader.getRealm();
        String username = authHeader.getUsername();
        if (username == null || realm == null) {
            return false;
        }
        String nonce = authHeader.getNonce();
        URI uri = authHeader.getURI();
        if (uri == null) {
            return false;
        }
        String A2 = request.getMethod().toUpperCase() + ":" + uri.toString();
        String HA1 = hashedPassword;
        byte[] mdbytes = this.messageDigest.digest(A2.getBytes());
        String HA2 = DigestServerAuthenticationHelper.toHexString(mdbytes);
        String cnonce = authHeader.getCNonce();
        String KD = HA1 + ":" + nonce;
        if (cnonce != null) {
            KD = KD + ":" + cnonce;
        }
        KD = KD + ":" + HA2;
        mdbytes = this.messageDigest.digest(KD.getBytes());
        String mdString = DigestServerAuthenticationHelper.toHexString(mdbytes);
        String response = authHeader.getResponse();
        return mdString.equals(response);
    }

    public boolean doAuthenticatePlainTextPassword(Request request, String pass) {
        ProxyAuthorizationHeader authHeader = (ProxyAuthorizationHeader)request.getHeader("Proxy-Authorization");
        if (authHeader == null) {
            return false;
        }
        String realm = authHeader.getRealm();
        String username = authHeader.getUsername();
        if (username == null || realm == null) {
            return false;
        }
        String nonce = authHeader.getNonce();
        URI uri = authHeader.getURI();
        if (uri == null) {
            return false;
        }
        String A1 = username + ":" + realm + ":" + pass;
        String A2 = request.getMethod().toUpperCase() + ":" + uri.toString();
        byte[] mdbytes = this.messageDigest.digest(A1.getBytes());
        String HA1 = DigestServerAuthenticationHelper.toHexString(mdbytes);
        mdbytes = this.messageDigest.digest(A2.getBytes());
        String HA2 = DigestServerAuthenticationHelper.toHexString(mdbytes);
        String cnonce = authHeader.getCNonce();
        String KD = HA1 + ":" + nonce;
        if (cnonce != null) {
            KD = KD + ":" + cnonce;
        }
        KD = KD + ":" + HA2;
        mdbytes = this.messageDigest.digest(KD.getBytes());
        String mdString = DigestServerAuthenticationHelper.toHexString(mdbytes);
        String response = authHeader.getResponse();
        return mdString.equals(response);
    }
}

