/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core;

import com.voxeo.guido.Guido;
import com.voxeo.guido.GuidoException;
import com.voxeo.logging.Loggerf;
import com.voxeo.utils.IdGenerator;
import com.voxeo.utils.Networks;
import java.net.InetAddress;

public class GuidoIdGenerator
implements IdGenerator<String> {
    private static Loggerf log = Loggerf.getLogger(GuidoIdGenerator.class);
    private InetAddress resolvedAddress;

    public GuidoIdGenerator() {
        this(null);
    }

    public GuidoIdGenerator(String networkAddress) {
        this.resolvedAddress = networkAddress == null ? Networks.extractDefaultLocalInetAddress() : Networks.findInetAddressByIp((String)networkAddress);
        log.info("Created GuidoIdGenerator [nic=%s]", new Object[]{this.resolvedAddress});
    }

    public String makeId() {
        try {
            Guido guido = new Guido(this.resolvedAddress, null);
            return guido.toString();
        }
        catch (GuidoException e) {
            throw new IllegalStateException(e);
        }
    }
}

