/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osgi.framework.startlevel;

import java.util.concurrent.TimeUnit;
import net.java.sip.communicator.impl.osgi.framework.AsyncExecutor;
import net.java.sip.communicator.impl.osgi.framework.BundleImpl;
import net.java.sip.communicator.impl.osgi.framework.launch.FrameworkImpl;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.startlevel.FrameworkStartLevel;

public class FrameworkStartLevelImpl
implements FrameworkStartLevel {
    private final BundleImpl bundle;
    private final AsyncExecutor<Command> executor = new AsyncExecutor(5L, TimeUnit.MINUTES);
    private int initialBundleStartLevel = 0;
    private int startLevel;

    public FrameworkStartLevelImpl(BundleImpl bundleImpl) {
        this.bundle = bundleImpl;
    }

    public BundleImpl getBundle() {
        return this.bundle;
    }

    private FrameworkImpl getFramework() {
        return this.getBundle().getFramework();
    }

    public int getInitialBundleStartLevel() {
        int n = this.initialBundleStartLevel;
        if (n == 0) {
            n = 1;
        }
        return n;
    }

    public synchronized int getStartLevel() {
        return this.startLevel;
    }

    public void internalSetStartLevel(int n, FrameworkListener ... frameworkListenerArray) {
        if (n < 0) {
            throw new IllegalArgumentException("startLevel");
        }
        this.executor.execute(new Command(n, frameworkListenerArray));
    }

    public void setInitialBundleStartLevel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("initialBundleStartLevel");
        }
        this.initialBundleStartLevel = n;
    }

    public void setStartLevel(int n, FrameworkListener ... frameworkListenerArray) {
        if (n == 0) {
            throw new IllegalArgumentException("startLevel");
        }
        this.internalSetStartLevel(n, frameworkListenerArray);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private class Command
    implements Runnable {
        private final FrameworkListener[] listeners;
        private final int startLevel;

        public Command(int n, FrameworkListener ... frameworkListenerArray) {
            this.startLevel = n;
            this.listeners = frameworkListenerArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int n = FrameworkStartLevelImpl.this.getStartLevel();
            FrameworkImpl frameworkImpl = FrameworkStartLevelImpl.this.getFramework();
            if (n < this.startLevel) {
                int n2 = n + 1;
                while (n2 <= this.startLevel) {
                    int n3 = FrameworkStartLevelImpl.this.getStartLevel();
                    int n4 = n2++;
                    frameworkImpl.startLevelChanging(n3, n4, this.listeners);
                    FrameworkStartLevelImpl frameworkStartLevelImpl = FrameworkStartLevelImpl.this;
                    synchronized (frameworkStartLevelImpl) {
                        FrameworkStartLevelImpl.this.startLevel = n4;
                    }
                    frameworkImpl.startLevelChanged(n3, n4, this.listeners);
                }
            } else if (this.startLevel < n) {
                for (int i = n; i > this.startLevel; --i) {
                    int n5 = FrameworkStartLevelImpl.this.getStartLevel();
                    int n6 = i - 1;
                    frameworkImpl.startLevelChanging(n5, n6, this.listeners);
                    FrameworkStartLevelImpl frameworkStartLevelImpl = FrameworkStartLevelImpl.this;
                    synchronized (frameworkStartLevelImpl) {
                        FrameworkStartLevelImpl.this.startLevel = n6;
                    }
                    frameworkImpl.startLevelChanged(n5, n6, this.listeners);
                }
            } else {
                frameworkImpl.startLevelChanging(n, n, this.listeners);
                frameworkImpl.startLevelChanged(n, n, this.listeners);
            }
        }
    }
}

