/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osgi.framework.launch;

import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.osgi.framework.BundleImpl;
import net.java.sip.communicator.impl.osgi.framework.ServiceRegistrationImpl;
import net.java.sip.communicator.impl.osgi.framework.launch.EventDispatcher;
import net.java.sip.communicator.impl.osgi.framework.startlevel.FrameworkStartLevelImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkImpl
extends BundleImpl
implements Framework {
    private final List<BundleImpl> bundles = new LinkedList<BundleImpl>();
    private final Map<String, String> configuration;
    private EventDispatcher eventDispatcher;
    private FrameworkStartLevelImpl frameworkStartLevel;
    private long nextBundleId = 1L;
    private long nextServiceId = 1L;
    private final List<ServiceRegistrationImpl> serviceRegistrations = new LinkedList<ServiceRegistrationImpl>();

    public FrameworkImpl(Map<String, String> map) {
        super(null, 0L, null);
        this.configuration = map;
        this.bundles.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> A adapt(Class<A> clazz) {
        FrameworkStartLevelImpl frameworkStartLevelImpl;
        FrameworkImpl frameworkImpl;
        if (FrameworkStartLevel.class.equals(clazz)) {
            frameworkImpl = this;
            synchronized (frameworkImpl) {
                if (this.frameworkStartLevel == null) {
                    this.frameworkStartLevel = new FrameworkStartLevelImpl(this);
                }
                frameworkStartLevelImpl = this.frameworkStartLevel;
            }
        } else {
            frameworkStartLevelImpl = null;
        }
        return (A)((frameworkImpl = frameworkStartLevelImpl) != null ? frameworkImpl : super.adapt(clazz));
    }

    public void addBundleListener(BundleImpl bundleImpl, BundleListener bundleListener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addListener(bundleImpl, BundleListener.class, bundleListener);
        }
    }

    public void addServiceListener(BundleImpl bundleImpl, ServiceListener serviceListener, Filter filter) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.addListener(bundleImpl, ServiceListener.class, serviceListener);
        }
    }

    public void fireBundleEvent(int n, Bundle bundle) {
        this.fireBundleEvent(n, bundle, bundle);
    }

    private void fireBundleEvent(int n, Bundle bundle, Bundle bundle2) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.fireBundleEvent(new BundleEvent(n, bundle, bundle2));
        }
    }

    private void fireFrameworkEvent(int n, FrameworkListener ... frameworkListenerArray) {
        if (frameworkListenerArray != null && frameworkListenerArray.length != 0) {
            FrameworkEvent frameworkEvent = new FrameworkEvent(n, (Bundle)this, null);
            for (FrameworkListener frameworkListener : frameworkListenerArray) {
                try {
                    frameworkListener.frameworkEvent(frameworkEvent);
                }
                catch (Throwable throwable) {
                    if (n == 2) continue;
                }
            }
        }
    }

    private void fireServiceEvent(int n, ServiceReference<?> serviceReference) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.fireServiceEvent(new ServiceEvent(n, serviceReference));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleImpl getBundle(long l) {
        if (l == 0L) {
            return this;
        }
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl bundleImpl : this.bundles) {
                if (bundleImpl.getBundleId() != l) continue;
                return bundleImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BundleImpl> getBundlesByStartLevel(int n) {
        LinkedList<BundleImpl> linkedList = new LinkedList<BundleImpl>();
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl bundleImpl : this.bundles) {
                BundleStartLevel bundleStartLevel = bundleImpl.adapt(BundleStartLevel.class);
                if (bundleStartLevel == null || bundleStartLevel.getStartLevel() != n) continue;
                linkedList.add(bundleImpl);
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServiceReference> getServiceReferences(BundleImpl bundleImpl, Class<?> clazz, String string, Filter filter, boolean bl) throws InvalidSyntaxException {
        Filter filter2 = FrameworkUtil.createFilter((String)("(objectClass=" + (string == null ? Character.valueOf('*') : string) + ')'));
        LinkedList<ServiceReference> linkedList = new LinkedList<ServiceReference>();
        List<ServiceRegistrationImpl> list = this.serviceRegistrations;
        synchronized (list) {
            for (ServiceRegistrationImpl serviceRegistrationImpl : this.serviceRegistrations) {
                ServiceReference serviceReference;
                ServiceRegistrationImpl.ServiceReferenceImpl serviceReferenceImpl = serviceRegistrationImpl.getReference();
                if (!filter2.match((ServiceReference)serviceReferenceImpl) || filter != null && !filter.match((ServiceReference)serviceReferenceImpl) || (serviceReference = serviceRegistrationImpl.getReference(clazz)) == null) continue;
                linkedList.add(serviceReference);
            }
        }
        return linkedList;
    }

    @Override
    public FrameworkImpl getFramework() {
        return this;
    }

    private long getNextBundleId() {
        return this.nextBundleId++;
    }

    public void init() throws BundleException {
        this.setState(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle installBundle(BundleImpl bundleImpl, String string, InputStream inputStream) throws BundleException {
        if (string == null) {
            throw new BundleException("location");
        }
        BundleImpl bundleImpl2 = null;
        boolean bl = false;
        List<BundleImpl> list = this.bundles;
        synchronized (list) {
            for (BundleImpl bundleImpl3 : this.bundles) {
                if (!bundleImpl3.getLocation().equals(string)) continue;
                bundleImpl2 = bundleImpl3;
                break;
            }
            if (bundleImpl2 == null) {
                bundleImpl2 = new BundleImpl(this.getFramework(), this.getNextBundleId(), string);
                this.bundles.add(bundleImpl2);
                bl = true;
            }
        }
        if (bl) {
            this.fireBundleEvent(1, bundleImpl2, bundleImpl);
        }
        return bundleImpl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(BundleImpl bundleImpl, Class clazz, String[] stringArray, Object object, Dictionary<String, ?> dictionary) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("classNames");
        }
        if (object == null) {
            throw new IllegalArgumentException("service");
        }
        Class<?> clazz2 = object.getClass();
        if (!ServiceFactory.class.isAssignableFrom(clazz2)) {
            ClassLoader classLoader = clazz2.getClassLoader();
            for (String string : stringArray) {
                boolean bl = true;
                Throwable throwable = null;
                try {
                    if (Class.forName(string, false, classLoader).isAssignableFrom(clazz2)) {
                        bl = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throwable = classNotFoundException;
                }
                catch (ExceptionInInitializerError exceptionInInitializerError) {
                    throwable = exceptionInInitializerError;
                }
                catch (LinkageError linkageError) {
                    throwable = linkageError;
                }
                if (!bl) continue;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                if (throwable != null) {
                    illegalArgumentException.initCause(throwable);
                }
                throw illegalArgumentException;
            }
        }
        Object object2 = this.serviceRegistrations;
        synchronized (this.serviceRegistrations) {
            long l = this.nextServiceId++;
            // ** MonitorExit[var8_9] (shouldn't be in output)
            object2 = new ServiceRegistrationImpl(bundleImpl, l, stringArray, object, dictionary);
            List<ServiceRegistrationImpl> list = this.serviceRegistrations;
            synchronized (list) {
                this.serviceRegistrations.add((ServiceRegistrationImpl)object2);
            }
            this.fireServiceEvent(1, ((ServiceRegistrationImpl)object2).getReference());
            return object2;
        }
    }

    public void removeBundleListener(BundleImpl bundleImpl, BundleListener bundleListener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeListener(bundleImpl, BundleListener.class, bundleListener);
        }
    }

    public void removeServiceListener(BundleImpl bundleImpl, ServiceListener serviceListener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.removeListener(bundleImpl, ServiceListener.class, serviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int n) throws BundleException {
        int n2 = this.getState();
        if (n2 == 2 || n2 == 4) {
            this.init();
            n2 = this.getState();
        }
        if (n2 == 8) {
            Object object;
            int n3 = 1;
            if (this.configuration != null && (object = this.configuration.get("org.osgi.framework.startlevel.beginning")) != null) {
                try {
                    n3 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            object = this.adapt(FrameworkStartLevel.class);
            FrameworkListener frameworkListener = new FrameworkListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void frameworkEvent(FrameworkEvent frameworkEvent) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        this.notifyAll();
                    }
                }
            };
            object.setStartLevel(n3, new FrameworkListener[]{frameworkListener});
            FrameworkListener frameworkListener2 = frameworkListener;
            synchronized (frameworkListener2) {
                boolean bl = false;
                while (object.getStartLevel() < n3) {
                    try {
                        frameworkListener.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
            this.setState(32);
        }
    }

    public void startLevelChanged(int n, int n2, FrameworkListener ... frameworkListenerArray) {
        if (n < n2) {
            for (BundleImpl bundleImpl : this.getBundlesByStartLevel(n2)) {
                try {
                    BundleStartLevel bundleStartLevel = bundleImpl.adapt(BundleStartLevel.class);
                    int n3 = 1;
                    if (bundleStartLevel.isActivationPolicyUsed()) {
                        n3 |= 2;
                    }
                    bundleImpl.start(n3);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)throwable;
                }
            }
        }
        this.fireFrameworkEvent(8, frameworkListenerArray);
    }

    public void startLevelChanging(int n, int n2, FrameworkListener ... frameworkListenerArray) {
        if (n > n2) {
            for (BundleImpl bundleImpl : this.getBundlesByStartLevel(n)) {
                try {
                    bundleImpl.stop(1);
                }
                catch (Throwable throwable) {
                    if (!(throwable instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stateChanged(int n, int n2) {
        switch (n2) {
            case 4: {
                if (this.eventDispatcher != null) {
                    this.eventDispatcher.stop();
                    this.eventDispatcher = null;
                }
                FrameworkImpl frameworkImpl = this;
                synchronized (frameworkImpl) {
                    if (this.frameworkStartLevel != null) {
                        this.frameworkStartLevel.stop();
                        this.frameworkStartLevel = null;
                    }
                    break;
                }
            }
            case 8: {
                this.eventDispatcher = new EventDispatcher();
            }
        }
        super.stateChanged(n, n2);
    }

    @Override
    public void stop(int n) throws BundleException {
        final FrameworkStartLevelImpl frameworkStartLevelImpl = (FrameworkStartLevelImpl)this.adapt(FrameworkStartLevel.class);
        new Thread(this.getClass().getName() + ".stop"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                FrameworkImpl frameworkImpl = FrameworkImpl.this;
                frameworkImpl.setState(16);
                FrameworkListener frameworkListener = new FrameworkListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void frameworkEvent(FrameworkEvent frameworkEvent) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.notifyAll();
                        }
                    }
                };
                frameworkStartLevelImpl.internalSetStartLevel(0, frameworkListener);
                FrameworkListener frameworkListener2 = frameworkListener;
                synchronized (frameworkListener2) {
                    boolean bl = false;
                    while (frameworkStartLevelImpl.getStartLevel() != 0) {
                        try {
                            frameworkListener.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
                frameworkImpl.setState(4);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(BundleImpl bundleImpl, ServiceRegistration<?> serviceRegistration) {
        boolean bl;
        List<ServiceRegistrationImpl> list = this.serviceRegistrations;
        synchronized (list) {
            bl = this.serviceRegistrations.remove(serviceRegistration);
        }
        if (!bl) {
            throw new IllegalStateException("serviceRegistrations");
        }
        this.fireServiceEvent(4, serviceRegistration.getReference());
    }

    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        return null;
    }
}

