/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.event;

import java.util.EventObject;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;

public class ChatRoomMemberPresenceChangeEvent
extends EventObject {
    private static final long serialVersionUID = 0L;
    public static final String MEMBER_JOINED = "MemberJoined";
    public static final String MEMBER_LEFT = "MemberLeft";
    public static final String MEMBER_KICKED = "MemberKicked";
    public static final String MEMBER_QUIT = "MemberQuit";
    public static final String REASON_USER_LIST = "ReasonUserList";
    private final ChatRoomMember sourceMember;
    private final String eventType;
    private final String reason;

    public ChatRoomMemberPresenceChangeEvent(ChatRoom sourceRoom, ChatRoomMember sourceMember, String eventType, String reason) {
        this(sourceRoom, sourceMember, null, eventType, reason);
    }

    public ChatRoomMemberPresenceChangeEvent(ChatRoom sourceRoom, ChatRoomMember sourceMember, ChatRoomMember actorMember, String eventType, String reason) {
        super(sourceRoom);
        this.sourceMember = sourceMember;
        this.eventType = eventType;
        this.reason = reason;
    }

    public ChatRoom getChatRoom() {
        return (ChatRoom)this.getSource();
    }

    public ChatRoomMember getChatRoomMember() {
        return this.sourceMember;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isReasonUserList() {
        return REASON_USER_LIST.equals(this.getReason());
    }

    public String getEventType() {
        return this.eventType;
    }

    @Override
    public String toString() {
        return "ChatRoomMemberPresenceChangeEvent[type=" + this.getEventType() + " sourceRoom=" + this.getChatRoom().toString() + " member=" + this.getChatRoomMember().toString() + "]";
    }
}

