/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderActivator;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AccountManagerEvent;
import net.java.sip.communicator.service.protocol.event.AccountManagerListener;
import net.java.sip.communicator.util.Base64;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class AccountManager {
    private static final long LOAD_STORED_ACCOUNTS_TIMEOUT = 30000L;
    private final BundleContext bundleContext;
    private final List<AccountManagerListener> listeners = new LinkedList<AccountManagerListener>();
    private final Queue<ProtocolProviderFactory> loadStoredAccountsQueue = new LinkedList<ProtocolProviderFactory>();
    private Thread loadStoredAccountsThread;
    private final Logger logger = Logger.getLogger(AccountManager.class);
    private final Vector<AccountID> storedAccounts = new Vector();
    private static final String ACCOUNT_UID_PREFIX = "acc";

    public AccountManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.bundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                AccountManager.this.serviceChanged(serviceEvent);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AccountManagerListener listener) {
        List<AccountManagerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadStoredAccounts(ProtocolProviderFactory factory) {
        ConfigurationService configService = ProtocolProviderActivator.getConfigurationService();
        String factoryPackage = this.getFactoryImplPackageName(factory);
        List accounts = configService.getPropertyNamesByPrefix(factoryPackage, true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Discovered " + accounts.size() + " stored " + factoryPackage + " accounts"));
        }
        for (String storedAccount : accounts) {
            int dotIndex;
            if (!storedAccount.substring((dotIndex = storedAccount.lastIndexOf(".")) + 1).startsWith(ACCOUNT_UID_PREFIX)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Loading account " + storedAccount));
            }
            List storedAccountProperties = configService.getPropertyNamesByPrefix(storedAccount, false);
            Hashtable<String, String> accountProperties = new Hashtable<String, String>();
            boolean disabled = false;
            CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)this.bundleContext, CredentialsStorageService.class);
            int prefLen = storedAccount.length() + 1;
            for (String property : storedAccountProperties) {
                String value = configService.getString(property);
                if (prefLen > property.length()) continue;
                if ("IS_ACCOUNT_DISABLED".equals(property = property.substring(prefLen))) {
                    disabled = Boolean.parseBoolean(value);
                } else if ("PASSWORD".equals(property) && !credentialsStorage.isStoredEncrypted(storedAccount) && value != null && value.length() != 0) {
                    value = new String(Base64.decode((String)value));
                }
                if (value == null) continue;
                accountProperties.put(property, value);
            }
            try {
                AccountID accountID = factory.createAccount(accountProperties);
                if (accountID == null) continue;
                Vector<AccountID> vector = this.storedAccounts;
                synchronized (vector) {
                    this.storedAccounts.add(accountID);
                }
                if (disabled) continue;
                factory.loadAccount(accountID);
            }
            catch (Exception ex) {
                this.logger.error((Object)("Failed to load account " + accountProperties), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStoredAccountsLoaded(ProtocolProviderFactory factory) {
        AccountManagerListener[] listeners;
        List<AccountManagerListener> list = this.listeners;
        synchronized (list) {
            listeners = this.listeners.toArray(new AccountManagerListener[this.listeners.size()]);
        }
        int listenerCount = listeners.length;
        if (listenerCount > 0) {
            AccountManagerEvent event = new AccountManagerEvent(this, 1, factory);
            for (int listenerIndex = 0; listenerIndex < listenerCount; ++listenerIndex) {
                listeners[listenerIndex].handleAccountManagerEvent(event);
            }
        }
    }

    public String getFactoryImplPackageName(ProtocolProviderFactory factory) {
        String className = factory.getClass().getName();
        return className.substring(0, className.lastIndexOf(46));
    }

    public boolean hasStoredAccounts(String protocolName, boolean includeHidden) {
        return this.hasStoredAccount(protocolName, includeHidden, null);
    }

    public boolean hasStoredAccount(String protocolName, boolean includeHidden, String userID) {
        ServiceReference[] factoryRefs = null;
        boolean hasStoredAccounts = false;
        try {
            factoryRefs = this.bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            this.logger.error((Object)"Failed to retrieve the registered ProtocolProviderFactories", (Throwable)ex);
        }
        if (factoryRefs != null && factoryRefs.length > 0) {
            ConfigurationService configService = ProtocolProviderActivator.getConfigurationService();
            for (ServiceReference factoryRef : factoryRefs) {
                ProtocolProviderFactory factory = (ProtocolProviderFactory)this.bundleContext.getService(factoryRef);
                if (protocolName != null && !protocolName.equals(factory.getProtocolName())) continue;
                String factoryPackage = this.getFactoryImplPackageName(factory);
                List storedAccounts = configService.getPropertyNamesByPrefix(factoryPackage + ".acc", false);
                for (String storedAccount : storedAccounts) {
                    List storedAccountProperties = configService.getPropertyNamesByPrefix(storedAccount, true);
                    boolean hidden = false;
                    String accountUserID = null;
                    if (!includeHidden || userID != null) {
                        for (String property : storedAccountProperties) {
                            String value = configService.getString(property);
                            if ("IS_PROTOCOL_HIDDEN".equals(property = this.stripPackagePrefix(property))) {
                                hidden = value != null;
                                continue;
                            }
                            if (!"USER_ID".equals(property)) continue;
                            accountUserID = value;
                        }
                    }
                    if (!includeHidden && hidden) continue;
                    if (accountUserID != null && userID != null && userID.equals(accountUserID)) {
                        hasStoredAccounts = true;
                        break;
                    }
                    if (userID != null) continue;
                    hasStoredAccounts = true;
                    break;
                }
                if (hasStoredAccounts || protocolName != null) break;
            }
        }
        return hasStoredAccounts;
    }

    public AccountID findAccountID(String uid) {
        ServiceReference[] factoryRefs = null;
        try {
            factoryRefs = this.bundleContext.getServiceReferences(ProtocolProviderFactory.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            this.logger.error((Object)"Failed to retrieve the registered ProtocolProviderFactories", (Throwable)ex);
        }
        if (factoryRefs != null && factoryRefs.length > 0) {
            ConfigurationService configService = ProtocolProviderActivator.getConfigurationService();
            for (ServiceReference factoryRef : factoryRefs) {
                ProtocolProviderFactory factory = (ProtocolProviderFactory)this.bundleContext.getService(factoryRef);
                String factoryPackage = this.getFactoryImplPackageName(factory);
                List storedAccountsProps = configService.getPropertyNamesByPrefix(factoryPackage, true);
                for (String storedAccount : storedAccountsProps) {
                    if (!storedAccount.endsWith(uid)) continue;
                    String accountUID = configService.getString(storedAccount + "." + "ACCOUNT_UID");
                    for (AccountID acc : this.storedAccounts) {
                        if (!acc.getAccountUniqueID().equals(accountUID)) continue;
                        return acc;
                    }
                }
            }
        }
        return null;
    }

    private void loadStoredAccounts(ProtocolProviderFactory factory) {
        this.doLoadStoredAccounts(factory);
        this.fireStoredAccountsLoaded(factory);
    }

    private void protocolProviderFactoryRegistered(ProtocolProviderFactory factory) {
        this.queueLoadStoredAccounts(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueLoadStoredAccounts(ProtocolProviderFactory factory) {
        Queue<ProtocolProviderFactory> queue = this.loadStoredAccountsQueue;
        synchronized (queue) {
            this.loadStoredAccountsQueue.add(factory);
            this.loadStoredAccountsQueue.notifyAll();
            if (this.loadStoredAccountsThread == null) {
                this.loadStoredAccountsThread = new Thread(){

                    @Override
                    public void run() {
                        AccountManager.this.runInLoadStoredAccountsThread();
                    }
                };
                this.loadStoredAccountsThread.setDaemon(true);
                this.loadStoredAccountsThread.setName("AccountManager.loadStoredAccounts");
                this.loadStoredAccountsThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AccountManagerListener listener) {
        List<AccountManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runInLoadStoredAccountsThread() {
        boolean interrupted = false;
        while (!interrupted) {
            try {
                ProtocolProviderFactory factory;
                Queue<ProtocolProviderFactory> queue = this.loadStoredAccountsQueue;
                synchronized (queue) {
                    factory = this.loadStoredAccountsQueue.poll();
                    if (factory == null) {
                        try {
                            this.loadStoredAccountsQueue.wait(30000L);
                        }
                        catch (InterruptedException ex) {
                            this.logger.warn((Object)"The loading of the stored accounts has been interrupted", (Throwable)ex);
                            interrupted = true;
                            // MONITOREXIT @DISABLED, blocks:[0, 17, 20, 9, 13] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                            Queue<ProtocolProviderFactory> queue2 = this.loadStoredAccountsQueue;
                            synchronized (queue2) {
                                if (interrupted) return;
                                if (this.loadStoredAccountsQueue.size() > 0) return;
                                if (this.loadStoredAccountsThread != Thread.currentThread()) return;
                                this.loadStoredAccountsThread = null;
                                this.loadStoredAccountsQueue.notifyAll();
                                return;
                            }
                        }
                        factory = this.loadStoredAccountsQueue.poll();
                    }
                    if (factory != null) {
                        this.loadStoredAccountsQueue.notifyAll();
                    }
                    if (factory == null) continue;
                }
                try {
                    this.loadStoredAccounts(factory);
                }
                catch (Exception ex) {
                    this.logger.error((Object)("Failed to load accounts for " + factory), (Throwable)ex);
                }
            }
            finally {
                Queue<ProtocolProviderFactory> queue = this.loadStoredAccountsQueue;
                synchronized (queue) {
                    if (!interrupted && this.loadStoredAccountsQueue.size() <= 0) {
                        if (this.loadStoredAccountsThread != Thread.currentThread()) return;
                        this.loadStoredAccountsThread = null;
                        this.loadStoredAccountsQueue.notifyAll();
                        return;
                    }
                }
            }
        }
    }

    private void serviceChanged(ServiceEvent serviceEvent) {
        switch (serviceEvent.getType()) {
            case 1: {
                Object service = this.bundleContext.getService(serviceEvent.getServiceReference());
                if (!(service instanceof ProtocolProviderFactory)) break;
                this.protocolProviderFactoryRegistered((ProtocolProviderFactory)service);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAccount(ProtocolProviderFactory factory, AccountID accountID) throws OperationFailedException {
        Vector<AccountID> vector = this.storedAccounts;
        synchronized (vector) {
            if (!this.storedAccounts.contains(accountID)) {
                this.storedAccounts.add(accountID);
            }
        }
        ConfigurationService configurationService = ProtocolProviderActivator.getConfigurationService();
        String factoryPackage = this.getFactoryImplPackageName(factory);
        String accountNodeName = this.getAccountNodeName(factory, accountID.getAccountUniqueID());
        HashMap<String, String> configurationProperties = new HashMap<String, String>();
        if (accountNodeName == null) {
            accountNodeName = ACCOUNT_UID_PREFIX + Long.toString(System.currentTimeMillis());
            configurationProperties.put(factoryPackage + "." + accountNodeName, accountNodeName);
            configurationProperties.put(factoryPackage + "." + accountNodeName + "." + "ACCOUNT_UID", accountID.getAccountUniqueID());
        }
        Map<String, String> accountProperties = accountID.getAccountProperties();
        for (Map.Entry<String, String> entry : accountProperties.entrySet()) {
            String property = entry.getKey();
            String value = entry.getValue();
            String secureStorePrefix = null;
            if (property.equals("PASSWORD")) {
                String accountPrefix;
                secureStorePrefix = accountPrefix = factoryPackage + "." + accountNodeName;
            } else if (property.endsWith(".PASSWORD")) {
                secureStorePrefix = factoryPackage + "." + accountNodeName + "." + property.substring(0, property.lastIndexOf("."));
            }
            if (secureStorePrefix != null) {
                CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)this.bundleContext, CredentialsStorageService.class);
                if (value == null || value.length() == 0 || credentialsStorage.storePassword(secureStorePrefix, value)) continue;
                throw new OperationFailedException("CredentialsStorageService failed to storePassword", 1);
            }
            configurationProperties.put(factoryPackage + "." + accountNodeName + "." + property, value);
        }
        if (!accountProperties.containsKey("PASSWORD") && !configurationProperties.containsKey(factoryPackage + "." + accountNodeName + ".ENCRYPTED_PASSWORD")) {
            CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)this.bundleContext, CredentialsStorageService.class);
            credentialsStorage.removePassword(factoryPackage + "." + accountNodeName);
        }
        if (configurationProperties.size() > 0) {
            configurationService.setProperties(configurationProperties);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Stored account for id " + accountID.getAccountUniqueID() + " for package " + factoryPackage));
        }
    }

    public String getAccountNodeName(ProtocolProviderFactory factory, String accountUID) {
        ConfigurationService configurationService = ProtocolProviderActivator.getConfigurationService();
        String factoryPackage = this.getFactoryImplPackageName(factory);
        List storedAccounts = configurationService.getPropertyNamesByPrefix(factoryPackage, true);
        String accountNodeName = null;
        for (String storedAccount : storedAccounts) {
            String storedAccountUID;
            int dotIndex;
            if (!storedAccount.substring((dotIndex = storedAccount.lastIndexOf(".")) + 1).startsWith(ACCOUNT_UID_PREFIX) || (storedAccountUID = configurationService.getString(storedAccount + "." + "ACCOUNT_UID")) == null || !storedAccountUID.equals(accountUID)) continue;
            accountNodeName = configurationService.getString(storedAccount);
        }
        return accountNodeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStoredAccount(ProtocolProviderFactory factory, AccountID accountID) {
        Vector<AccountID> vector = this.storedAccounts;
        synchronized (vector) {
            if (this.storedAccounts.contains(accountID)) {
                this.storedAccounts.remove(accountID);
            }
        }
        if (factory == null) {
            factory = ProtocolProviderActivator.getProtocolProviderFactory(accountID.getProtocolName());
        }
        String factoryPackage = this.getFactoryImplPackageName(factory);
        CredentialsStorageService credentialsStorage = (CredentialsStorageService)ServiceUtils.getService((BundleContext)this.bundleContext, CredentialsStorageService.class);
        String accountPrefix = ProtocolProviderFactory.findAccountPrefix(this.bundleContext, accountID, factoryPackage);
        credentialsStorage.removePassword(accountPrefix);
        ConfigurationService configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)this.bundleContext, ConfigurationService.class);
        List storedAccounts = configurationService.getPropertyNamesByPrefix(factoryPackage, true);
        for (String accountRootPropertyName : storedAccounts) {
            String accountUID = configurationService.getString(accountRootPropertyName + "." + "ACCOUNT_UID");
            if (!accountID.getAccountUniqueID().equals(accountUID)) continue;
            List accountPropertyNames = configurationService.getPropertyNamesByPrefix(accountRootPropertyName, false);
            for (String propName : accountPropertyNames) {
                configurationService.setProperty(propName, null);
            }
            configurationService.setProperty(accountRootPropertyName, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStoredAccounts() {
        Queue<ProtocolProviderFactory> queue = this.loadStoredAccountsQueue;
        synchronized (queue) {
            boolean interrupted = false;
            while (this.loadStoredAccountsThread != null) {
                try {
                    this.loadStoredAccountsQueue.wait(30000L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            Vector<AccountID> vector = this.storedAccounts;
            synchronized (vector) {
                AccountID[] storedAccounts;
                for (AccountID storedAccount : storedAccounts = this.storedAccounts.toArray(new AccountID[this.storedAccounts.size()])) {
                    ProtocolProviderFactory ppf = ProtocolProviderActivator.getProtocolProviderFactory(storedAccount.getProtocolName());
                    if (ppf == null) continue;
                    ppf.uninstallAccount(storedAccount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AccountID> getStoredAccounts() {
        Vector<AccountID> vector = this.storedAccounts;
        synchronized (vector) {
            return new Vector<AccountID>(this.storedAccounts);
        }
    }

    public void loadAccount(AccountID accountID) throws OperationFailedException {
        if (this.isAccountLoaded(accountID)) {
            return;
        }
        ProtocolProviderFactory providerFactory = ProtocolProviderActivator.getProtocolProviderFactory(accountID.getProtocolName());
        if (providerFactory.loadAccount(accountID)) {
            accountID.putAccountProperty("IS_ACCOUNT_DISABLED", String.valueOf(false));
            this.storeAccount(providerFactory, accountID);
        }
    }

    public void unloadAccount(AccountID accountID) throws OperationFailedException {
        if (!this.isAccountLoaded(accountID)) {
            return;
        }
        ProtocolProviderFactory providerFactory = ProtocolProviderActivator.getProtocolProviderFactory(accountID.getProtocolName());
        ServiceReference serRef = providerFactory.getProviderForAccount(accountID);
        if (serRef == null) {
            return;
        }
        ProtocolProviderService protocolProvider = (ProtocolProviderService)this.bundleContext.getService(serRef);
        String iconPathProperty = accountID.getAccountPropertyString("ACCOUNT_ICON_PATH");
        if (iconPathProperty == null) {
            accountID.putAccountProperty("ACCOUNT_ICON_PATH", protocolProvider.getProtocolIcon().getIconPath("IconSize32x32"));
        }
        accountID.putAccountProperty("IS_ACCOUNT_DISABLED", String.valueOf(true));
        if (!providerFactory.unloadAccount(accountID)) {
            accountID.putAccountProperty("IS_ACCOUNT_DISABLED", String.valueOf(false));
        }
        this.storeAccount(providerFactory, accountID);
    }

    public boolean isAccountLoaded(AccountID accountID) {
        return this.storedAccounts.contains(accountID) && accountID.isEnabled();
    }

    private String stripPackagePrefix(String property) {
        int packageEndIndex = property.lastIndexOf(46);
        if (packageEndIndex != -1) {
            property = property.substring(packageEndIndex + 1);
        }
        return property;
    }
}

