/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupEvent;
import net.java.sip.communicator.service.protocol.event.ServerStoredGroupListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionEvent;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionMovedEvent;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractOperationSetPersistentPresence<T extends ProtocolProviderService>
implements OperationSetPersistentPresence {
    private static final Logger logger = Logger.getLogger(AbstractOperationSetPersistentPresence.class);
    private final List<ContactPresenceStatusListener> contactPresenceStatusListeners = new Vector<ContactPresenceStatusListener>();
    protected final T parentProvider;
    private final List<ProviderPresenceStatusListener> providerPresenceStatusListeners = new Vector<ProviderPresenceStatusListener>();
    private final List<ServerStoredGroupListener> serverStoredGroupListeners = new Vector<ServerStoredGroupListener>();
    private final List<SubscriptionListener> subscriptionListeners = new Vector<SubscriptionListener>();

    protected AbstractOperationSetPersistentPresence(T parentProvider) {
        this.parentProvider = parentProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContactPresenceStatusListener(ContactPresenceStatusListener listener) {
        List<ContactPresenceStatusListener> list = this.contactPresenceStatusListeners;
        synchronized (list) {
            if (!this.contactPresenceStatusListeners.contains(listener)) {
                this.contactPresenceStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProviderPresenceStatusListener(ProviderPresenceStatusListener listener) {
        List<ProviderPresenceStatusListener> list = this.providerPresenceStatusListeners;
        synchronized (list) {
            if (!this.providerPresenceStatusListeners.contains(listener)) {
                this.providerPresenceStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        List<ServerStoredGroupListener> list = this.serverStoredGroupListeners;
        synchronized (list) {
            if (!this.serverStoredGroupListeners.contains(listener)) {
                this.serverStoredGroupListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscriptionListener(SubscriptionListener listener) {
        List<SubscriptionListener> list = this.subscriptionListeners;
        synchronized (list) {
            if (!this.subscriptionListeners.contains(listener)) {
                this.subscriptionListeners.add(listener);
            }
        }
    }

    protected void fireContactPresenceStatusChangeEvent(Contact source, ContactGroup parentGroup, PresenceStatus oldValue) {
        PresenceStatus newValue = source.getPresenceStatus();
        if (oldValue.equals(newValue)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Ignored prov stat. change evt. old==new = " + oldValue));
            }
            return;
        }
        this.fireContactPresenceStatusChangeEvent(source, parentGroup, oldValue, newValue);
    }

    public void fireContactPresenceStatusChangeEvent(Contact source, ContactGroup parentGroup, PresenceStatus oldValue, PresenceStatus newValue) {
        this.fireContactPresenceStatusChangeEvent(source, parentGroup, oldValue, newValue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireContactPresenceStatusChangeEvent(Contact source, ContactGroup parentGroup, PresenceStatus oldValue, PresenceStatus newValue, boolean isResourceChange) {
        ArrayList<ContactPresenceStatusListener> listeners;
        ContactPresenceStatusChangeEvent evt = new ContactPresenceStatusChangeEvent(source, (ProtocolProviderService)this.parentProvider, parentGroup, oldValue, newValue, isResourceChange);
        List<ContactPresenceStatusListener> list = this.contactPresenceStatusListeners;
        synchronized (list) {
            listeners = new ArrayList<ContactPresenceStatusListener>(this.contactPresenceStatusListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching Contact Status Change. Listeners=" + listeners.size() + " evt=" + evt));
        }
        for (ContactPresenceStatusListener listener : listeners) {
            listener.contactPresenceStatusChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireContactPropertyChangeEvent(String eventID, Contact source, Object oldValue, Object newValue) {
        ArrayList<SubscriptionListener> listeners;
        ContactPropertyChangeEvent evt = new ContactPropertyChangeEvent(source, eventID, oldValue, newValue);
        List<SubscriptionListener> list = this.subscriptionListeners;
        synchronized (list) {
            listeners = new ArrayList<SubscriptionListener>(this.subscriptionListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a Contact Property Change Event to" + listeners.size() + " listeners. Evt=" + evt));
        }
        for (SubscriptionListener listener : listeners) {
            listener.contactModified(evt);
        }
    }

    protected void fireProviderStatusChangeEvent(PresenceStatus oldValue) {
        this.fireProviderStatusChangeEvent(oldValue, this.getPresenceStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProviderStatusChangeEvent(PresenceStatus oldValue, PresenceStatus newValue) {
        ArrayList<ProviderPresenceStatusListener> listeners;
        ProviderPresenceStatusChangeEvent evt = new ProviderPresenceStatusChangeEvent((ProtocolProviderService)this.parentProvider, oldValue, newValue);
        List<ProviderPresenceStatusListener> list = this.providerPresenceStatusListeners;
        synchronized (list) {
            listeners = new ArrayList<ProviderPresenceStatusListener>(this.providerPresenceStatusListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching Provider Status Change. Listeners=" + listeners.size() + " evt=" + evt));
        }
        for (ProviderPresenceStatusListener listener : listeners) {
            listener.providerStatusChanged(evt);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"status dispatching done.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProviderStatusMessageChangeEvent(String oldStatusMessage, String newStatusMessage) {
        ArrayList<ProviderPresenceStatusListener> listeners;
        PropertyChangeEvent evt = new PropertyChangeEvent(this.parentProvider, "StatusMessage", oldStatusMessage, newStatusMessage);
        List<ProviderPresenceStatusListener> list = this.providerPresenceStatusListeners;
        synchronized (list) {
            listeners = new ArrayList<ProviderPresenceStatusListener>(this.providerPresenceStatusListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching  stat. msg change. Listeners=" + listeners.size() + " evt=" + evt));
        }
        for (ProviderPresenceStatusListener listener : listeners) {
            listener.providerStatusMessageChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServerStoredGroupEvent(ContactGroup source, int eventID) {
        ArrayList<ServerStoredGroupListener> listeners;
        ServerStoredGroupEvent evt = new ServerStoredGroupEvent(source, eventID, source.getParentContactGroup(), (ProtocolProviderService)this.parentProvider, this);
        List<ServerStoredGroupListener> list = this.serverStoredGroupListeners;
        synchronized (list) {
            listeners = new ArrayList<ServerStoredGroupListener>(this.serverStoredGroupListeners);
        }
        for (ServerStoredGroupListener listener : listeners) {
            switch (eventID) {
                case 1: {
                    listener.groupCreated(evt);
                    break;
                }
                case 3: {
                    listener.groupNameChanged(evt);
                    break;
                }
                case 2: {
                    listener.groupRemoved(evt);
                }
            }
        }
    }

    public void fireSubscriptionEvent(Contact source, ContactGroup parentGroup, int eventID) {
        this.fireSubscriptionEvent(source, parentGroup, eventID, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSubscriptionEvent(Contact source, ContactGroup parentGroup, int eventID, int errorCode, String errorReason) {
        ArrayList<SubscriptionListener> listeners;
        SubscriptionEvent evt = new SubscriptionEvent(source, (ProtocolProviderService)this.parentProvider, parentGroup, eventID, errorCode, errorReason);
        List<SubscriptionListener> list = this.subscriptionListeners;
        synchronized (list) {
            listeners = new ArrayList<SubscriptionListener>(this.subscriptionListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a Subscription Event to" + listeners.size() + " listeners. Evt=" + evt));
        }
        for (SubscriptionListener listener : listeners) {
            switch (eventID) {
                case 1: {
                    listener.subscriptionCreated(evt);
                    break;
                }
                case 3: {
                    listener.subscriptionFailed(evt);
                    break;
                }
                case 2: {
                    listener.subscriptionRemoved(evt);
                    break;
                }
                case 4: {
                    listener.subscriptionResolved(evt);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSubscriptionMovedEvent(Contact source, ContactGroup oldParent, ContactGroup newParent) {
        ArrayList<SubscriptionListener> listeners;
        SubscriptionMovedEvent evt = new SubscriptionMovedEvent(source, (ProtocolProviderService)this.parentProvider, oldParent, newParent);
        List<SubscriptionListener> list = this.subscriptionListeners;
        synchronized (list) {
            listeners = new ArrayList<SubscriptionListener>(this.subscriptionListeners);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a Subscription Event to" + listeners.size() + " listeners. Evt=" + evt));
        }
        for (SubscriptionListener listener : listeners) {
            listener.subscriptionMoved(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContactPresenceStatusListener(ContactPresenceStatusListener listener) {
        List<ContactPresenceStatusListener> list = this.contactPresenceStatusListeners;
        synchronized (list) {
            this.contactPresenceStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProviderPresenceStatusListener(ProviderPresenceStatusListener listener) {
        List<ProviderPresenceStatusListener> list = this.providerPresenceStatusListeners;
        synchronized (list) {
            this.providerPresenceStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServerStoredGroupChangeListener(ServerStoredGroupListener listener) {
        List<ServerStoredGroupListener> list = this.serverStoredGroupListeners;
        synchronized (list) {
            this.serverStoredGroupListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriptionListener(SubscriptionListener listener) {
        List<SubscriptionListener> list = this.subscriptionListeners;
        synchronized (list) {
            this.subscriptionListeners.remove(listener);
        }
    }

    @Override
    public void setDisplayName(Contact contact, String newName) throws IllegalArgumentException {
    }
}

