/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractMessage
implements Message {
    private static final Logger logger = Logger.getLogger(AbstractMessage.class);
    private String content;
    private final String contentType;
    private String encoding;
    private final String messageUID;
    private byte[] rawData;
    private final String subject;

    private static boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    protected AbstractMessage(String content, String contentType, String encoding, String subject) {
        this.contentType = contentType;
        this.subject = subject;
        this.setEncoding(encoding);
        this.setContent(content);
        this.messageUID = this.createMessageUID();
    }

    protected AbstractMessage(String content, String contentType, String encoding, String subject, String messageUID) {
        this.contentType = contentType;
        this.subject = subject;
        this.setEncoding(encoding);
        this.setContent(content);
        this.messageUID = messageUID == null ? this.createMessageUID() : messageUID;
    }

    protected String createMessageUID() {
        return String.valueOf(System.currentTimeMillis()) + String.valueOf(this.hashCode());
    }

    @Override
    public final String getContent() {
        return this.content;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public final String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getMessageUID() {
        return this.messageUID;
    }

    @Override
    public byte[] getRawData() {
        if (this.rawData == null) {
            String content = this.getContent();
            String encoding = this.getEncoding();
            boolean useDefaultEncoding = true;
            if (encoding != null) {
                try {
                    this.rawData = content.getBytes(encoding);
                    useDefaultEncoding = false;
                }
                catch (UnsupportedEncodingException ex) {
                    logger.warn((Object)("Failed to get raw data from content using encoding " + encoding), (Throwable)ex);
                }
            }
            if (useDefaultEncoding) {
                this.setEncoding(Charset.defaultCharset().name());
                this.rawData = content.getBytes();
            }
        }
        return this.rawData;
    }

    @Override
    public int getSize() {
        return this.getRawData().length;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    protected void setContent(String content) {
        if (!AbstractMessage.equals(this.content, content)) {
            this.content = content;
            this.rawData = null;
        }
    }

    private void setEncoding(String encoding) {
        if (!AbstractMessage.equals(this.encoding, encoding)) {
            this.encoding = encoding;
            this.rawData = null;
        }
    }
}

