/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ContactResourceEvent;
import net.java.sip.communicator.service.protocol.event.ContactResourceListener;

public abstract class AbstractContact
implements Contact {
    private Collection<ContactResourceListener> resourceListeners;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Contact contact = (Contact)obj;
        ProtocolProviderService protocolProvider = contact.getProtocolProvider();
        ProtocolProviderService thisProtocolProvider = this.getProtocolProvider();
        if (protocolProvider == null ? thisProtocolProvider == null : protocolProvider.equals(thisProtocolProvider)) {
            String address = contact.getAddress();
            String thisAddress = this.getAddress();
            return address == null ? thisAddress == null : address.equals(thisAddress);
        }
        return false;
    }

    public int hashCode() {
        String address;
        int hashCode = 0;
        ProtocolProviderService protocolProvider = this.getProtocolProvider();
        if (protocolProvider != null) {
            hashCode += protocolProvider.hashCode();
        }
        if ((address = this.getAddress()) != null) {
            hashCode += address.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean supportResources() {
        return false;
    }

    @Override
    public Collection<ContactResource> getResources() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResourceListener(ContactResourceListener l) {
        if (this.resourceListeners == null) {
            this.resourceListeners = new ArrayList<ContactResourceListener>();
        }
        Collection<ContactResourceListener> collection = this.resourceListeners;
        synchronized (collection) {
            this.resourceListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourceListener(ContactResourceListener l) {
        if (this.resourceListeners == null) {
            return;
        }
        Collection<ContactResourceListener> collection = this.resourceListeners;
        synchronized (collection) {
            this.resourceListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactResourceEvent(ContactResourceEvent event) {
        ArrayList<ContactResourceListener> listeners;
        if (this.resourceListeners == null) {
            return;
        }
        Collection<ContactResourceListener> collection = this.resourceListeners;
        synchronized (collection) {
            listeners = new ArrayList<ContactResourceListener>(this.resourceListeners);
        }
        Iterator listenersIter = listeners.iterator();
        while (listenersIter.hasNext()) {
            if (event.getEventType() == 0) {
                ((ContactResourceListener)listenersIter.next()).contactResourceAdded(event);
                continue;
            }
            if (event.getEventType() == 1) {
                ((ContactResourceListener)listenersIter.next()).contactResourceRemoved(event);
                continue;
            }
            if (event.getEventType() != 2) continue;
            ((ContactResourceListener)listenersIter.next()).contactResourceModified(event);
        }
    }

    @Override
    public String getPersistableAddress() {
        return this.getAddress();
    }

    @Override
    public boolean isMobile() {
        return false;
    }
}

