/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import org.ice4j.StunException;
import org.ice4j.attribute.Attribute;

public class DataAttribute
extends Attribute {
    public static final String NAME = "DATA";
    private byte[] data = null;
    private boolean padding = true;

    protected DataAttribute() {
        this(true);
    }

    protected DataAttribute(boolean padding) {
        super('\u0013');
        this.padding = padding;
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        this.data = new byte[length];
        System.arraycopy(attributeValue, offset, this.data, 0, length);
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        byte[] binValue = new byte[4 + this.getDataLength() + (this.padding ? this.getDataLength() % 4 : 0)];
        binValue[0] = (byte)(type >> 8);
        binValue[1] = (byte)(type & 0xFF);
        binValue[2] = (byte)(this.getDataLength() >> 8);
        binValue[3] = (byte)(this.getDataLength() & 0xFF);
        System.arraycopy(this.data, 0, binValue, 4, this.getDataLength());
        return binValue;
    }

    public char getDataLength() {
        return (char)this.data.length;
    }

    public String getName() {
        return NAME;
    }

    public byte[] getData() {
        return this.data == null ? null : (byte[])this.data.clone();
    }

    public void setData(byte[] data) {
        if (data == null) {
            this.data = null;
            return;
        }
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DataAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        DataAttribute att = (DataAttribute)obj;
        return att.getAttributeType() == this.getAttributeType() && att.getDataLength() == this.getDataLength() && Arrays.equals(att.data, this.data);
    }
}

