/*
 * Decompiled with CFR 0.152.
 */
package org.bitlet.weupnp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.bitlet.weupnp.GatewayDevice;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayDiscover {
    public static final int PORT = 1900;
    public static final String IP = "239.255.255.250";
    private static final int TIMEOUT = 1500;
    private final String stSearch;
    private Map<InetAddress, GatewayDevice> devices = new HashMap<InetAddress, GatewayDevice>();

    public GatewayDiscover() {
        this.stSearch = "upnp:rootdevice";
    }

    public GatewayDiscover(String string) {
        this.stSearch = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<InetAddress, GatewayDevice> discover() throws SocketException, UnknownHostException, IOException, SAXException, ParserConfigurationException {
        DatagramSocket datagramSocket = new DatagramSocket();
        int n = datagramSocket.getLocalPort();
        try {
            byte[] byArray = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nST: urn:schemas-upnp-org:device:InternetGatewayDevice:1\r\nMAN: \"ssdp:discover\"\r\nMX: 2\r\n\r\n".getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            datagramPacket.setAddress(InetAddress.getByName(IP));
            datagramPacket.setPort(1900);
            datagramSocket.send(datagramPacket);
            datagramSocket.setSoTimeout(1500);
            boolean bl = true;
            while (bl) {
                DatagramPacket datagramPacket2 = new DatagramPacket(new byte[1536], 1536);
                try {
                    Serializable serializable;
                    datagramSocket.receive(datagramPacket2);
                    byte[] socketTimeoutException = new byte[datagramPacket2.getLength()];
                    System.arraycopy(datagramPacket2.getData(), 0, socketTimeoutException, 0, datagramPacket2.getLength());
                    GatewayDevice gatewayDevice = this.parseMSearchReplay(socketTimeoutException);
                    SocketAddress socketAddress = null;
                    if (gatewayDevice.getLocation() != null) {
                        serializable = new URL(gatewayDevice.getLocation());
                        socketAddress = new InetSocketAddress(((URL)serializable).getHost(), ((URL)serializable).getPort() != -1 ? ((URL)serializable).getPort() : ((URL)serializable).getDefaultPort());
                    } else {
                        socketAddress = datagramPacket2.getSocketAddress();
                    }
                    serializable = this.getOutboundAddress(socketAddress);
                    gatewayDevice.setLocalAddress((InetAddress)serializable);
                    this.devices.put((InetAddress)serializable, gatewayDevice);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    bl = false;
                }
            }
            for (GatewayDevice gatewayDevice : this.devices.values()) {
                try {
                    gatewayDevice.loadDescription();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            datagramSocket.close();
        }
        return this.devices;
    }

    private GatewayDevice parseMSearchReplay(byte[] byArray) {
        GatewayDevice gatewayDevice = new GatewayDevice();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        String string = null;
        try {
            string = bufferedReader.readLine().trim();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (string != null && string.trim().length() > 0) {
            if (!string.startsWith("HTTP/1.")) {
                String string2 = string.substring(0, string.indexOf(58));
                String string3 = string.length() > string2.length() + 1 ? string.substring(string2.length() + 1) : null;
                string2 = string2.trim();
                if (string3 != null) {
                    string3 = string3.trim();
                }
                if (string2.compareToIgnoreCase("location") == 0) {
                    gatewayDevice.setLocation(string3);
                } else if (string2.compareToIgnoreCase("st") == 0) {
                    gatewayDevice.setSt(string3);
                }
            }
            try {
                string = bufferedReader.readLine().trim();
            }
            catch (IOException iOException) {}
        }
        return gatewayDevice;
    }

    public GatewayDevice getValidGateway() {
        for (GatewayDevice gatewayDevice : this.devices.values()) {
            try {
                if (!gatewayDevice.isConnected()) continue;
                return gatewayDevice;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private InetAddress getOutboundAddress(SocketAddress socketAddress) throws SocketException {
        DatagramSocket datagramSocket = new DatagramSocket();
        datagramSocket.connect(socketAddress);
        InetAddress inetAddress = datagramSocket.getLocalAddress();
        datagramSocket.disconnect();
        datagramSocket = null;
        if (inetAddress.isAnyLocalAddress()) {
            try {
                Socket socket = new Socket();
                socket.setSoTimeout(1500);
                socket.connect(socketAddress);
                inetAddress = socket.getLocalAddress();
                socket.close();
                socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return inetAddress;
    }
}

