/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.netaddr;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.netaddr.NetaddrActivator;
import net.java.sip.communicator.impl.netaddr.NetworkEventDispatcher;
import net.java.sip.communicator.service.netaddr.event.ChangeEvent;
import net.java.sip.communicator.service.netaddr.event.NetworkConfigurationChangeListener;
import net.java.sip.communicator.service.sysactivity.SystemActivityChangeListener;
import net.java.sip.communicator.service.sysactivity.SystemActivityNotificationsService;
import net.java.sip.communicator.service.sysactivity.event.SystemActivityEvent;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class NetworkConfigurationWatcher
implements SystemActivityChangeListener,
ServiceListener,
Runnable {
    private static Logger logger = Logger.getLogger(NetworkConfigurationWatcher.class);
    private Map<String, List<InetAddress>> activeInterfaces = new HashMap<String, List<InetAddress>>();
    private static final int CHECK_INTERVAL = 3000;
    private boolean isRunning = false;
    private SystemActivityNotificationsService systemActivityNotificationsService = null;
    private NetworkEventDispatcher eventDispatcher = new NetworkEventDispatcher();

    NetworkConfigurationWatcher() {
        try {
            this.checkNetworkInterfaces(false, 0, true);
        }
        catch (SocketException e) {
            logger.error((Object)"Error checking network interfaces", (Throwable)e);
        }
    }

    void addNetworkConfigurationChangeListener(NetworkConfigurationChangeListener listener) {
        this.eventDispatcher.addNetworkConfigurationChangeListener(listener);
        this.initialFireEvents(listener);
        NetaddrActivator.getBundleContext().addServiceListener((ServiceListener)this);
        if (this.systemActivityNotificationsService == null) {
            SystemActivityNotificationsService systActService = (SystemActivityNotificationsService)ServiceUtils.getService((BundleContext)NetaddrActivator.getBundleContext(), SystemActivityNotificationsService.class);
            this.handleNewSystemActivityNotificationsService(systActService);
        }
    }

    private void initialFireEvents(NetworkConfigurationChangeListener listener) {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface networkInterface = e.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> as = networkInterface.getInetAddresses();
                boolean hasAddress = false;
                while (as.hasMoreElements()) {
                    InetAddress inetAddress = as.nextElement();
                    if (inetAddress.isLinkLocalAddress()) continue;
                    hasAddress = true;
                    NetworkEventDispatcher.fireChangeEvent(new ChangeEvent(networkInterface.getName(), 3, inetAddress, false, true), listener);
                }
                if (!hasAddress) continue;
                NetworkEventDispatcher.fireChangeEvent(new ChangeEvent(networkInterface.getName(), 1, null, false, true), listener);
            }
        }
        catch (SocketException e) {
            logger.error((Object)"Error checking network interfaces", (Throwable)e);
        }
    }

    private void handleNewSystemActivityNotificationsService(SystemActivityNotificationsService newService) {
        if (newService == null) {
            return;
        }
        this.systemActivityNotificationsService = newService;
        if (this.systemActivityNotificationsService.isSupported(9)) {
            this.systemActivityNotificationsService.addSystemActivityChangeListener((SystemActivityChangeListener)this);
        } else if (!this.isRunning) {
            this.isRunning = true;
            Thread th = new Thread(this);
            th.setPriority(10);
            th.start();
        }
    }

    void removeNetworkConfigurationChangeListener(NetworkConfigurationChangeListener listener) {
        this.eventDispatcher.removeNetworkConfigurationChangeListener(listener);
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        ServiceReference serviceRef = serviceEvent.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object sService = NetaddrActivator.getBundleContext().getService(serviceRef);
        if (sService instanceof SystemActivityNotificationsService) {
            switch (serviceEvent.getType()) {
                case 1: {
                    if (this.systemActivityNotificationsService != null) break;
                    this.handleNewSystemActivityNotificationsService((SystemActivityNotificationsService)sService);
                    break;
                }
                case 4: {
                    ((SystemActivityNotificationsService)sService).removeSystemActivityChangeListener((SystemActivityChangeListener)this);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        if (this.isRunning) {
            NetworkConfigurationWatcher networkConfigurationWatcher = this;
            synchronized (networkConfigurationWatcher) {
                this.isRunning = false;
                this.notifyAll();
            }
        }
        if (this.eventDispatcher != null) {
            this.eventDispatcher.stop();
        }
    }

    public void activityChanged(SystemActivityEvent event) {
        if (event.getEventID() == 0) {
            this.downAllInterfaces();
        } else if (event.getEventID() == 9) {
            try {
                this.checkNetworkInterfaces(true, 0, true);
            }
            catch (SocketException e) {
                logger.error((Object)"Error checking network interfaces", (Throwable)e);
            }
        } else if (event.getEventID() == 12) {
            try {
                this.eventDispatcher.fireChangeEvent(new ChangeEvent(event.getSource(), 4));
            }
            catch (Throwable t) {
                logger.error((Object)"Error dispatching dns change.");
            }
        }
    }

    private void downAllInterfaces() {
        for (String niface : this.activeInterfaces.keySet()) {
            this.eventDispatcher.fireChangeEvent(new ChangeEvent((Object)niface, 0, true));
        }
        this.activeInterfaces.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNetworkInterfaces(boolean fireEvents, int waitBeforeFiringUpEvents, boolean printDebugInfo) throws SocketException {
        List<InetAddress> addresses;
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        HashMap currentActiveInterfaces = new HashMap();
        while (e.hasMoreElements()) {
            NetworkInterface networkInterface = e.nextElement();
            if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
            ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
            Enumeration<InetAddress> as = networkInterface.getInetAddresses();
            while (as.hasMoreElements()) {
                InetAddress inetAddress = as.nextElement();
                if (inetAddress.isLinkLocalAddress()) continue;
                arrayList.add(inetAddress);
            }
            if (arrayList.size() <= 0) continue;
            currentActiveInterfaces.put(networkInterface.getName(), arrayList);
        }
        if (logger.isInfoEnabled() && printDebugInfo) {
            for (Map.Entry<String, List<InetAddress>> entry : this.activeInterfaces.entrySet()) {
                logger.info((Object)("Previously Active " + entry.getKey() + ":" + entry.getValue()));
            }
            for (Map.Entry<String, List<InetAddress>> entry : currentActiveInterfaces.entrySet()) {
                logger.info((Object)("Currently Active " + entry.getKey() + ":" + entry.getValue()));
            }
        }
        ArrayList<String> inactiveActiveInterfaces = new ArrayList<String>(this.activeInterfaces.keySet());
        ArrayList arrayList = new ArrayList(currentActiveInterfaces.keySet());
        inactiveActiveInterfaces.removeAll(arrayList);
        for (int i = 0; i < inactiveActiveInterfaces.size(); ++i) {
            String string = (String)inactiveActiveInterfaces.get(i);
            if (arrayList.contains(string)) continue;
            if (fireEvents) {
                this.eventDispatcher.fireChangeEvent(new ChangeEvent(string, 0));
            }
            this.activeInterfaces.remove(string);
        }
        for (Map.Entry<String, List<InetAddress>> entry : this.activeInterfaces.entrySet()) {
            Iterator<InetAddress> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                InetAddress addr = iterator.next();
                addresses = (List<InetAddress>)currentActiveInterfaces.get(entry.getKey());
                if (addresses == null || addresses.contains(addr)) continue;
                if (fireEvents) {
                    this.eventDispatcher.fireChangeEvent(new ChangeEvent((Object)entry.getKey(), 2, addr));
                }
                iterator.remove();
            }
        }
        if (waitBeforeFiringUpEvents > 0 && currentActiveInterfaces.size() != 0) {
            NetworkConfigurationWatcher networkConfigurationWatcher = this;
            synchronized (networkConfigurationWatcher) {
                try {
                    this.wait(waitBeforeFiringUpEvents);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        for (Map.Entry<String, List<InetAddress>> entry : currentActiveInterfaces.entrySet()) {
            for (InetAddress addr : entry.getValue()) {
                addresses = this.activeInterfaces.get(entry.getKey());
                if (addresses == null || addresses.contains(addr)) continue;
                if (fireEvents) {
                    this.eventDispatcher.fireChangeEvent(new ChangeEvent((Object)entry.getKey(), 3, addr));
                }
                addresses.add(addr);
            }
        }
        Iterator<String> iterator = this.activeInterfaces.keySet().iterator();
        while (iterator.hasNext()) {
            currentActiveInterfaces.remove(iterator.next());
        }
        for (Map.Entry<String, List<InetAddress>> entry : currentActiveInterfaces.entrySet()) {
            for (InetAddress addr : entry.getValue()) {
                if (!fireEvents) continue;
                this.eventDispatcher.fireChangeEvent(new ChangeEvent((Object)entry.getKey(), 3, addr));
            }
            if (fireEvents) {
                int wait = waitBeforeFiringUpEvents;
                if (wait == 0) {
                    wait = 500;
                }
                this.eventDispatcher.fireChangeEvent(new ChangeEvent(entry.getKey(), 1), wait);
            }
            this.activeInterfaces.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long last = 0L;
        boolean isAfterStandby = false;
        while (this.isRunning) {
            NetworkConfigurationWatcher networkConfigurationWatcher;
            long curr = System.currentTimeMillis();
            if (!isAfterStandby && last != 0L) {
                boolean bl = isAfterStandby = last + 12000L - curr < 0L;
            }
            if (isAfterStandby) {
                this.downAllInterfaces();
                isAfterStandby = false;
                last = curr;
                networkConfigurationWatcher = this;
                synchronized (networkConfigurationWatcher) {
                    try {
                        this.wait(3000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                boolean networkIsUP = this.activeInterfaces.size() > 0;
                this.checkNetworkInterfaces(true, 1000, false);
                if (!networkIsUP && this.activeInterfaces.size() > 0) {
                    isAfterStandby = false;
                }
                last = System.currentTimeMillis();
            }
            catch (SocketException e) {
                logger.error((Object)"Error checking network interfaces", (Throwable)e);
            }
            networkConfigurationWatcher = this;
            synchronized (networkConfigurationWatcher) {
                try {
                    this.wait(3000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }
}

