/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.params;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.cryptozrtp.CipherParameters;
import org.bouncycastle.cryptozrtp.params.DHValidationParameters;

public class DHParameters
implements CipherParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private BigIntegerCrypto g;
    private BigIntegerCrypto p;
    private BigIntegerCrypto q;
    private BigIntegerCrypto j;
    private int m = 160;
    private int l;
    private DHValidationParameters validation;

    public DHParameters(BigIntegerCrypto p, BigIntegerCrypto g) {
        this(p, g, null, 160, 0, null, null);
    }

    public DHParameters(BigIntegerCrypto p, BigIntegerCrypto g, BigIntegerCrypto q) {
        this(p, g, q, 160, 0, null, null);
    }

    public DHParameters(BigIntegerCrypto p, BigIntegerCrypto g, BigIntegerCrypto q, int l) {
        this(p, g, q, l, l, null, null);
    }

    public DHParameters(BigIntegerCrypto p, BigIntegerCrypto g, BigIntegerCrypto q, int m, int l) {
        this(p, g, q, m, l, null, null);
    }

    public DHParameters(BigIntegerCrypto p, BigIntegerCrypto g, BigIntegerCrypto q, BigIntegerCrypto j, DHValidationParameters validation) {
        this(p, g, q, 160, 0, j, validation);
    }

    public DHParameters(BigIntegerCrypto p, BigIntegerCrypto g, BigIntegerCrypto q, int m, int l, BigIntegerCrypto j, DHValidationParameters validation) {
        if (l != 0 && m > l) {
            throw new IllegalArgumentException("l value must be greater than m value if provided");
        }
        this.g = g;
        this.p = p;
        this.q = q;
        this.m = m;
        this.l = l;
        this.j = j;
        this.validation = validation;
    }

    public BigIntegerCrypto getP() {
        return this.p;
    }

    public BigIntegerCrypto getG() {
        return this.g;
    }

    public BigIntegerCrypto getQ() {
        return this.q;
    }

    public BigIntegerCrypto getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DHParameters)) {
            return false;
        }
        DHParameters pm = (DHParameters)obj;
        if (this.getQ() != null ? !this.getQ().equals(pm.getQ()) : pm.getQ() != null) {
            return false;
        }
        return pm.getP().equals(this.p) && pm.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode() ^ (this.getQ() != null ? this.getQ().hashCode() : 0);
    }
}

