/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import java.util.Collection;
import java.util.LinkedList;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.osgi.OSGi;
import org.jitsi.videobridge.xmpp.IQUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.xmpp.component.AbstractComponent;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentImpl
extends AbstractComponent
implements BundleActivator {
    private static final String DESCRIPTION = "Jitsi Videobridge Jabber Component";
    private static final String NAME = "JitsiVideobridge";
    public static final String SUBDOMAIN = "jitsi-videobridge";
    private BundleContext bundleContext;

    public static Collection<ComponentImpl> getComponents(BundleContext bundleContext) {
        LinkedList<ComponentImpl> components = new LinkedList<ComponentImpl>();
        if (bundleContext != null) {
            Collection serviceReferences = null;
            try {
                serviceReferences = bundleContext.getServiceReferences(ComponentImpl.class, null);
            }
            catch (IllegalStateException e) {
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    ComponentImpl component = null;
                    try {
                        component = (ComponentImpl)((Object)bundleContext.getService(serviceReference));
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (IllegalStateException e) {
                        break;
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                    if (component == null || components.contains((Object)component)) continue;
                    components.add(component);
                }
            }
        }
        return components;
    }

    protected String[] discoInfoFeatureNamespaces() {
        return new String[]{"http://jitsi.org/protocol/colibri", "urn:xmpp:jingle:apps:dtls:0", "urn:xmpp:jingle:transports:ice-udp:1", "urn:xmpp:jingle:transports:raw-udp:1"};
    }

    protected String discoInfoIdentityCategoryType() {
        return "conference";
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return NAME;
    }

    private org.jivesoftware.smack.packet.IQ handleColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) throws Exception {
        Videobridge videobridge;
        BundleContext bundleContext = this.getBundleContext();
        ColibriConferenceIQ iq = null;
        if (bundleContext != null && (videobridge = (Videobridge)ServiceUtils.getService((BundleContext)bundleContext, Videobridge.class)) != null) {
            iq = videobridge.handleColibriConferenceIQ(conferenceIQ);
        }
        return iq;
    }

    private IQ handleIQ(IQ iq) throws Exception {
        try {
            IQ resultIQ;
            ComponentImpl.logd("RECV: " + iq.toXML());
            org.jivesoftware.smack.packet.IQ smackIQ = IQUtils.convert(iq);
            org.jivesoftware.smack.packet.IQ resultSmackIQ = this.handleIQ(smackIQ);
            if (resultSmackIQ == null) {
                resultIQ = null;
            } else {
                resultIQ = IQUtils.convert(resultSmackIQ);
                ComponentImpl.logd("SENT: " + resultIQ.toXML());
            }
            return resultIQ;
        }
        catch (Exception e) {
            ComponentImpl.loge(e);
            throw e;
        }
    }

    private org.jivesoftware.smack.packet.IQ handleIQ(org.jivesoftware.smack.packet.IQ iq) throws Exception {
        org.jivesoftware.smack.packet.IQ resultIQ;
        if (iq instanceof ColibriConferenceIQ) {
            resultIQ = this.handleColibriConferenceIQ((ColibriConferenceIQ)iq);
            if (resultIQ != null) {
                resultIQ.setFrom(iq.getTo());
                resultIQ.setPacketID(iq.getPacketID());
                resultIQ.setTo(iq.getFrom());
            }
        } else {
            resultIQ = null;
        }
        return resultIQ;
    }

    protected IQ handleIQGet(IQ iq) throws Exception {
        IQ resultIQ = this.handleIQ(iq);
        return resultIQ == null ? super.handleIQGet(iq) : resultIQ;
    }

    protected IQ handleIQSet(IQ iq) throws Exception {
        IQ resultIQ = this.handleIQ(iq);
        return resultIQ == null ? super.handleIQSet(iq) : resultIQ;
    }

    private static void logd(String s) {
        System.err.println(s);
    }

    private static void loge(Throwable t) {
        t.printStackTrace(System.err);
    }

    public void postComponentShutdown() {
        super.postComponentShutdown();
        OSGi.stop(this);
    }

    public void postComponentStart() {
        super.postComponentStart();
        OSGi.start(this);
    }

    public void send(org.jivesoftware.smack.packet.IQ iq) throws Exception {
        try {
            JID fromJID;
            String from = iq.getFrom();
            if ((from == null || from.length() == 0) && (fromJID = this.getJID()) != null) {
                iq.setFrom(fromJID.toString());
            }
            IQ packet = IQUtils.convert(iq);
            this.send((Packet)packet);
            ComponentImpl.logd("SENT: " + packet.toXML());
        }
        catch (Exception e) {
            ComponentImpl.loge(e);
            throw e;
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        Collection<ComponentImpl> components = ComponentImpl.getComponents(bundleContext);
        if (!components.contains((Object)this)) {
            bundleContext.registerService(ComponentImpl.class, (Object)this, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            Collection serviceReferences = bundleContext.getServiceReferences(ComponentImpl.class, null);
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    Object service = bundleContext.getService(serviceReference);
                    if (service != this) continue;
                    bundleContext.ungetService(serviceReference);
                }
            }
            Object var7_6 = null;
            this.bundleContext = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.bundleContext = null;
            throw throwable;
        }
    }

    public Videobridge getVideoBridge() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext != null) {
            return (Videobridge)ServiceUtils.getService((BundleContext)bundleContext, Videobridge.class);
        }
        return null;
    }
}

