/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.java.sip.communicator.impl.protocol.jabber.extensions.DefaultPacketExtensionProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriIQProvider;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.RTPLevelRelayType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.util.ServiceUtils;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.stack.StunStack;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.VideobridgeExpireThread;
import org.jitsi.videobridge.xmpp.ComponentImpl;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.ProviderManager;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Videobridge {
    private static String defaultTransportManager;
    private static final String DEFAULT_OPTIONS_PROPERTY_NAME = "org.jitsi.videobridge.defaultOptions";
    private static final Logger logger;
    public static final int OPTION_ALLOW_NO_FOCUS = 1;
    public static final int OPTION_ALLOW_ANY_FOCUS = 2;
    static final Random RANDOM;
    public static final String REST_API = "rest";
    public static final String REST_API_PNAME = "org.jitsi.videobridge.rest";
    public static final String XMPP_API = "xmpp";
    public static final String XMPP_API_PNAME = "org.jitsi.videobridge.xmpp";
    private BundleContext bundleContext;
    private final Map<String, Conference> conferences = new HashMap<String, Conference>();
    private int defaultProcessingOptions;

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public Videobridge() {
        new VideobridgeExpireThread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference createConference(String focus) {
        Conference conference = null;
        do {
            String id = this.generateConferenceID();
            Map<String, Conference> map = this.conferences;
            synchronized (map) {
                if (!this.conferences.containsKey(id)) {
                    conference = new Conference(this, id, focus);
                    this.conferences.put(id, conference);
                }
            }
        } while (conference == null);
        Videobridge.logd("Created conference " + conference.getID() + ". The total number of conferences is now " + this.getConferenceCount() + ", channels " + this.getChannelCount() + ".");
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireConference(Conference conference) {
        boolean expireConference;
        String id = conference.getID();
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            if (conference.equals(this.conferences.get(id))) {
                this.conferences.remove(id);
                expireConference = true;
            } else {
                expireConference = false;
            }
        }
        if (expireConference) {
            conference.expire();
        }
    }

    private String generateConferenceID() {
        return Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    int getChannelCount() {
        int channelCount = 0;
        for (Conference conference : this.getConferences()) {
            for (Content contents : conference.getContents()) {
                channelCount += contents.getChannelCount();
            }
        }
        return channelCount;
    }

    public Collection<ComponentImpl> getComponents() {
        return ComponentImpl.getComponents(this.getBundleContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference getConference(String id, String focus) {
        Conference conference;
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            conference = this.conferences.get(id);
        }
        if (conference != null) {
            String conferenceFocus = conference.getFocus();
            if (conferenceFocus == null || conferenceFocus.equals(focus)) {
                conference.touch();
            } else {
                conference = null;
            }
        }
        return conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConferenceCount() {
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            return this.conferences.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Conference[] getConferences() {
        Map<String, Conference> map = this.conferences;
        synchronized (map) {
            Collection<Conference> values = this.conferences.values();
            return values.toArray(new Conference[values.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultTransportManager() {
        Class<Videobridge> clazz = Videobridge.class;
        synchronized (Videobridge.class) {
            if (defaultTransportManager == null) {
                ConfigurationService cfg;
                BundleContext bundleContext = this.getBundleContext();
                if (bundleContext != null && (cfg = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class)) != null) {
                    defaultTransportManager = cfg.getString(Videobridge.class.getName() + ".defaultTransportManager");
                }
                if (!"urn:xmpp:jingle:transports:ice-udp:1".equals(defaultTransportManager) && !"urn:xmpp:jingle:transports:raw-udp:1".equals(defaultTransportManager)) {
                    defaultTransportManager = "urn:xmpp:jingle:transports:ice-udp:1";
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultTransportManager;
        }
    }

    public ColibriConferenceIQ handleColibriConferenceIQ(ColibriConferenceIQ conferenceIQ) throws Exception {
        return this.handleColibriConferenceIQ(conferenceIQ, this.defaultProcessingOptions);
    }

    public ColibriConferenceIQ handleColibriConferenceIQ(ColibriConferenceIQ conferenceIQ, int options) throws Exception {
        ColibriConferenceIQ responseConferenceIQ;
        Conference conference;
        String focus = conferenceIQ.getFrom();
        if ((options & 2) > 0) {
            options |= 1;
            focus = null;
        }
        if (focus == null && (options & 1) == 0) {
            throw new NullPointerException("focus");
        }
        String id = conferenceIQ.getID();
        Conference conference2 = conference = id == null ? this.createConference(focus) : this.getConference(id, focus);
        if (conference == null) {
            responseConferenceIQ = null;
        } else {
            responseConferenceIQ = new ColibriConferenceIQ();
            conference.describeShallow(responseConferenceIQ);
            for (ColibriConferenceIQ.Content contentIQ : conferenceIQ.getContents()) {
                Content content = conference.getOrCreateContent(contentIQ.getName());
                if (content == null) {
                    responseConferenceIQ = null;
                } else {
                    ColibriConferenceIQ.Content responseContentIQ = new ColibriConferenceIQ.Content(content.getName());
                    responseConferenceIQ.addContent(responseContentIQ);
                    for (ColibriConferenceIQ.Channel channelIQ : contentIQ.getChannels()) {
                        String channelID = channelIQ.getID();
                        int channelExpire = channelIQ.getExpire();
                        Channel channel = channelID == null ? (channelExpire == 0 ? null : content.createChannel()) : content.getChannel(channelID);
                        if (channel == null) {
                            responseConferenceIQ = null;
                        } else {
                            Boolean initiator;
                            Integer lastN;
                            String endpoint;
                            RTPLevelRelayType rtpLevelRelayType;
                            if (channelExpire != -1) {
                                channel.setExpire(channelExpire);
                                if (channelExpire == 0 && channel.isExpired()) continue;
                            }
                            if ((rtpLevelRelayType = channelIQ.getRTPLevelRelayType()) != null) {
                                channel.setRTPLevelRelayType(rtpLevelRelayType);
                            }
                            if ((endpoint = channelIQ.getEndpoint()) != null) {
                                channel.setEndpoint(endpoint);
                            }
                            if ((lastN = channelIQ.getLastN()) != null) {
                                channel.setLastN(lastN);
                            }
                            if ((initiator = channelIQ.isInitiator()) != null) {
                                channel.setInitiator(initiator);
                            }
                            channel.setPayloadTypes(channelIQ.getPayloadTypes());
                            channel.setTransport(channelIQ.getTransport());
                            channel.setDirection(channelIQ.getDirection());
                            ColibriConferenceIQ.Channel responseChannelIQ = new ColibriConferenceIQ.Channel();
                            channel.describe(responseChannelIQ);
                            responseContentIQ.addChannel(responseChannelIQ);
                        }
                        if (responseConferenceIQ != null) continue;
                        break;
                    }
                }
                if (responseConferenceIQ != null) continue;
                break;
            }
        }
        if (responseConferenceIQ != null) {
            responseConferenceIQ.setType(IQ.Type.RESULT);
        }
        return responseConferenceIQ;
    }

    void start(BundleContext bundleContext) throws Exception {
        List ice4jPropertyNames;
        ConfigurationService config = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        this.defaultProcessingOptions = config.getInt(DEFAULT_OPTIONS_PROPERTY_NAME, 0);
        logger.info((Object)("Default videobridge processing options: 0x" + Integer.toHexString(this.defaultProcessingOptions)));
        ProviderManager providerManager = ProviderManager.getInstance();
        providerManager.addIQProvider("conference", "http://jitsi.org/protocol/colibri", (Object)new ColibriIQProvider());
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:ice-udp:1", (Object)new DefaultPacketExtensionProvider(IceUdpTransportPacketExtension.class));
        providerManager.addExtensionProvider("transport", "urn:xmpp:jingle:transports:raw-udp:1", (Object)new DefaultPacketExtensionProvider(RawUdpTransportPacketExtension.class));
        DefaultPacketExtensionProvider candidatePacketExtensionProvider = new DefaultPacketExtensionProvider(CandidatePacketExtension.class);
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:ice-udp:1", (Object)candidatePacketExtensionProvider);
        providerManager.addExtensionProvider("candidate", "urn:xmpp:jingle:transports:raw-udp:1", (Object)candidatePacketExtensionProvider);
        providerManager.addExtensionProvider("fingerprint", "urn:xmpp:jingle:apps:dtls:0", (Object)new DefaultPacketExtensionProvider(DtlsFingerprintPacketExtension.class));
        StunStack.setPacketLogger(null);
        if (config != null && (ice4jPropertyNames = config.getPropertyNamesByPrefix("org.ice4j.", false)) != null && ice4jPropertyNames.size() != 0) {
            for (String propertyName : ice4jPropertyNames) {
                String propertyValue = config.getString(propertyName);
                if (propertyValue == null) continue;
                System.setProperty(propertyName, propertyValue);
            }
        }
        try {
            HostCandidateHarvester.initializeInterfaceFilters();
        }
        catch (Exception e) {
            logger.warn((Object)"There were errors during host candidate interface filters initialization.", (Throwable)e);
        }
        this.bundleContext = bundleContext;
    }

    void stop(BundleContext bundleContext) throws Exception {
        this.bundleContext = null;
    }

    static {
        logger = Logger.getLogger(Videobridge.class);
        RANDOM = new Random();
    }
}

