/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.audionotifier;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.audionotifier.SCAudioClip;

public abstract class AbstractSCAudioClip
implements SCAudioClip {
    private static ExecutorService executorService;
    protected final AudioNotifierService audioNotifier;
    private Runnable command;
    private boolean invalid;
    private boolean looping;
    private int loopInterval;
    private boolean started;
    protected final Object sync = new Object();
    protected final String uri;

    protected AbstractSCAudioClip(String uri, AudioNotifierService audioNotifier) {
        this.uri = uri;
        this.audioNotifier = audioNotifier;
    }

    protected void enterRunInPlayThread() {
    }

    protected void enterRunOnceInPlayThread() {
    }

    protected void exitRunInPlayThread() {
    }

    protected void exitRunOnceInPlayThread() {
    }

    public int getLoopInterval() {
        return this.loopInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStop() {
        boolean interrupted = false;
        Object object = this.sync;
        synchronized (object) {
            this.started = false;
            this.sync.notifyAll();
            while (this.command != null) {
                try {
                    this.sync.wait(500L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isLooping() {
        return this.looping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStarted() {
        Object object = this.sync;
        synchronized (object) {
            return this.started;
        }
    }

    @Override
    public void play() {
        this.play(-1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(int loopInterval, final Callable<Boolean> loopCondition) {
        if (loopInterval >= 0 && loopCondition == null) {
            loopInterval = -1;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.command != null) {
                return;
            }
            this.setLoopInterval(loopInterval);
            this.setLooping(loopInterval >= 0);
            Class<AbstractSCAudioClip> clazz = AbstractSCAudioClip.class;
            synchronized (AbstractSCAudioClip.class) {
                if (executorService == null) {
                    executorService = Executors.newCachedThreadPool();
                }
                ExecutorService executorService = AbstractSCAudioClip.executorService;
                // ** MonitorExit[var5_4] (shouldn't be in output)
                try {
                    this.started = false;
                    this.command = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        @Override
                        public void run() {
                            try {
                                Object object = AbstractSCAudioClip.this.sync;
                                synchronized (object) {
                                    if (!this.equals(AbstractSCAudioClip.this.command)) {
                                        return;
                                    }
                                }
                                AbstractSCAudioClip.this.runInPlayThread(loopCondition);
                                return;
                            }
                            finally {
                                Object object = AbstractSCAudioClip.this.sync;
                                synchronized (object) {
                                    if (this.equals(AbstractSCAudioClip.this.command)) {
                                        AbstractSCAudioClip.this.command = null;
                                        AbstractSCAudioClip.this.started = false;
                                        AbstractSCAudioClip.this.sync.notifyAll();
                                    }
                                }
                            }
                        }
                    };
                    executorService.execute(this.command);
                    this.started = true;
                }
                finally {
                    if (!this.started) {
                        this.command = null;
                    }
                    this.sync.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInPlayThread(Callable<Boolean> loopCondition) {
        this.enterRunInPlayThread();
        try {
            boolean interrupted = false;
            while (this.isStarted()) {
                boolean loop;
                block25: {
                    Object object;
                    if (this.audioNotifier.isMute()) {
                        object = this.sync;
                        synchronized (object) {
                            try {
                                this.sync.wait(500L);
                            }
                            catch (InterruptedException ie) {
                                interrupted = true;
                            }
                        }
                    }
                    this.enterRunOnceInPlayThread();
                    try {
                        if (!this.runOnceInPlayThread()) {
                            break;
                        }
                    }
                    finally {
                        this.exitRunOnceInPlayThread();
                    }
                    if (!this.isLooping()) break;
                    object = this.sync;
                    synchronized (object) {
                        if (!this.isStarted()) {
                            break;
                        }
                        try {
                            int loopInterval = this.getLoopInterval();
                            if (loopInterval > 0) {
                                this.sync.wait(loopInterval);
                            }
                        }
                        catch (InterruptedException ie) {
                            interrupted = true;
                        }
                    }
                    if (!this.isStarted() || loopCondition == null) break;
                    loop = false;
                    try {
                        loop = loopCondition.call();
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block25;
                        throw (ThreadDeath)t;
                    }
                }
                if (loop) continue;
                break;
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.exitRunInPlayThread();
        }
    }

    protected abstract boolean runOnceInPlayThread();

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLooping(boolean looping) {
        Object object = this.sync;
        synchronized (object) {
            if (this.looping != looping) {
                this.looping = looping;
                this.sync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopInterval(int loopInterval) {
        Object object = this.sync;
        synchronized (object) {
            if (this.loopInterval != loopInterval) {
                this.loopInterval = loopInterval;
                this.sync.notifyAll();
            }
        }
    }

    @Override
    public void stop() {
        this.internalStop();
        this.setLooping(false);
    }
}

