/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.renderer.audio;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.MediaLocator;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.CaptureDeviceInfo2;
import org.jitsi.impl.neomedia.device.WASAPISystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.HResultException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPI;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.service.neomedia.codec.Constants;
import org.jitsi.util.Logger;

public class WASAPIRenderer
extends AbstractAudioRenderer<WASAPISystem> {
    private static final Logger logger = Logger.getLogger(WASAPIRenderer.class);
    private static final String PLUGIN_NAME = "Windows Audio Session API (WASAPI) Renderer";
    private long bufferDuration;
    private boolean busy;
    private long devicePeriod = 10L;
    private int devicePeriodInFrames;
    private int dstChannels;
    private AudioFormat dstFormat;
    private int dstSampleSize;
    private long eventHandle;
    private Runnable eventHandleCmd;
    private Executor eventHandleExecutor;
    private long iAudioClient;
    private long iAudioRenderClient;
    private boolean locatorIsNull;
    private int numBufferFrames;
    private Codec resampler;
    private int resamplerChannels;
    private byte[] resamplerData;
    private int resamplerFrameSize;
    private Buffer resamplerInBuffer;
    private Buffer resamplerOutBuffer;
    private int resamplerSampleSize;
    private byte[] srcBuffer;
    private int srcBufferLength;
    private int srcChannels;
    private AudioFormat srcFormat;
    private int srcFrameSize;
    private int srcSampleSize;
    private boolean started;
    private long writeIsMalfunctioningSince = 0L;
    private long writeIsMalfunctioningTimeout;

    private static AudioFormat findFirst(AudioFormat[] formats) {
        AudioFormat format = null;
        for (AudioFormat aFormat : formats) {
            if (aFormat == null) continue;
            format = aFormat;
            break;
        }
        return format;
    }

    public static Codec maybeOpenResampler(AudioFormat inFormat, AudioFormat outFormat) {
        Vector classNames = PlugInManager.getPlugInList(inFormat, outFormat, 2);
        Codec resampler = null;
        if (classNames != null) {
            for (String className : classNames) {
                try {
                    Format setOutput;
                    Codec codec = (Codec)Class.forName(className).newInstance();
                    Format setInput = codec.setInputFormat(inFormat);
                    if (setInput == null || !inFormat.matches(setInput) || (setOutput = codec.setOutputFormat(outFormat)) == null || !outFormat.matches(setOutput)) continue;
                    codec.open();
                    resampler = codec;
                    break;
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.warn("Failed to open resampler " + className, t);
                }
            }
        }
        return resampler;
    }

    public static int pop(byte[] array, int arrayLength, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length");
        }
        if (length == 0) {
            return arrayLength;
        }
        int newArrayLength = arrayLength - length;
        if (newArrayLength > 0) {
            int i = 0;
            int j = length;
            while (i < newArrayLength) {
                array[i] = array[j];
                ++i;
                ++j;
            }
        } else {
            newArrayLength = 0;
        }
        return newArrayLength;
    }

    public WASAPIRenderer() {
        this(AudioSystem.DataFlow.PLAYBACK);
    }

    public WASAPIRenderer(AudioSystem.DataFlow dataFlow) {
        super("wasapi", dataFlow);
    }

    public WASAPIRenderer(boolean playback) {
        this(playback ? AudioSystem.DataFlow.PLAYBACK : AudioSystem.DataFlow.NOTIFY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            this.stop();
        }
        finally {
            if (this.iAudioRenderClient != 0L) {
                WASAPI.IAudioRenderClient_Release(this.iAudioRenderClient);
                this.iAudioRenderClient = 0L;
            }
            if (this.iAudioClient != 0L) {
                WASAPI.IAudioClient_Release(this.iAudioClient);
                this.iAudioClient = 0L;
            }
            if (this.eventHandle != 0L) {
                try {
                    WASAPI.CloseHandle(this.eventHandle);
                }
                catch (HResultException hre) {
                    logger.warn("Failed to close event HANDLE.", hre);
                }
                this.eventHandle = 0L;
            }
            this.maybeCloseResampler();
            this.dstFormat = null;
            this.locatorIsNull = false;
            this.srcBuffer = null;
            this.srcBufferLength = 0;
            this.srcFormat = null;
            this.started = false;
            super.close();
        }
    }

    private AudioFormat[] getFormatsToInitializeIAudioClient() {
        AudioFormat inputFormat = (AudioFormat)this.inputFormat;
        if (inputFormat == null) {
            throw new NullPointerException("No inputFormat set.");
        }
        AudioFormat[] preferredFormats = WASAPISystem.getFormatsToInitializeIAudioClient(inputFormat);
        Format[] supportedFormats = this.getSupportedInputFormats();
        ArrayList<AudioFormat> formats = new ArrayList<AudioFormat>(preferredFormats.length + supportedFormats.length);
        for (AudioFormat audioFormat : preferredFormats) {
            if (formats.contains(audioFormat)) continue;
            formats.add(audioFormat);
        }
        for (Format format : supportedFormats) {
            if (formats.contains(format) || !(format instanceof AudioFormat)) continue;
            formats.add((AudioFormat)format);
        }
        final int sampleRate = (int)inputFormat.getSampleRate();
        if (sampleRate != -1) {
            Collections.sort(formats, new Comparator<AudioFormat>(){

                @Override
                public int compare(AudioFormat af1, AudioFormat af2) {
                    int d2;
                    int d1 = this.computeSampleRateDistance(af1);
                    return d1 < (d2 = this.computeSampleRateDistance(af2)) ? -1 : (d1 == d2 ? 0 : 1);
                }

                private int computeSampleRateDistance(AudioFormat af) {
                    boolean downsample;
                    int max;
                    int min;
                    int sr = (int)af.getSampleRate();
                    if (sr == -1) {
                        return Integer.MAX_VALUE;
                    }
                    if (sr == sampleRate) {
                        return 0;
                    }
                    if (sr < sampleRate) {
                        min = sr;
                        max = sampleRate;
                        downsample = true;
                    } else {
                        min = sampleRate;
                        max = sr;
                        downsample = false;
                    }
                    if (min == 0) {
                        return Integer.MAX_VALUE;
                    }
                    int h = max % min;
                    int l = max / min;
                    if (downsample) {
                        l = Short.MAX_VALUE - l;
                        if (h != 0) {
                            h = Short.MAX_VALUE - h;
                        }
                    }
                    return h << 16 | l;
                }
            });
        }
        return formats.toArray(new AudioFormat[formats.size()]);
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public Format[] getSupportedInputFormats() {
        if (this.getLocator() == null) {
            double sampleRate = MediaUtils.MAX_AUDIO_SAMPLE_RATE;
            int sampleSizeInBits = 16;
            int channels = 2;
            if (sampleRate == -1.0 && Constants.AUDIO_SAMPLE_RATES.length != 0) {
                sampleRate = Constants.AUDIO_SAMPLE_RATES[0];
            }
            return WASAPISystem.getFormatsToInitializeIAudioClient(new AudioFormat("LINEAR", sampleRate, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray));
        }
        return super.getSupportedInputFormats();
    }

    private void maybeCloseResampler() {
        Codec resampler = this.resampler;
        if (resampler != null) {
            this.resampler = null;
            this.resamplerData = null;
            this.resamplerInBuffer = null;
            this.resamplerOutBuffer = null;
            try {
                resampler.close();
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error("Failed to close resampler.", t);
            }
        }
    }

    private int maybeIAudioRenderClientWrite(byte[] data, int offset, int length, int srcSampleSize, int srcChannels) {
        int written;
        try {
            written = WASAPI.IAudioRenderClient_Write(this.iAudioRenderClient, data, offset, length, srcSampleSize, srcChannels, this.dstSampleSize, this.dstChannels);
        }
        catch (HResultException hre) {
            written = 0;
            logger.error("IAudioRenderClient_Write", hre);
        }
        return written;
    }

    private void maybeOpenResampler() {
        Codec resampler;
        AudioFormat inFormat = (AudioFormat)this.inputFormat;
        AudioFormat outFormat = this.dstFormat;
        if (inFormat.getSampleRate() == outFormat.getSampleRate() && inFormat.getSampleSizeInBits() == outFormat.getSampleSizeInBits()) {
            return;
        }
        int channels = inFormat.getChannels();
        if (outFormat.getChannels() != channels) {
            outFormat = new AudioFormat(outFormat.getEncoding(), outFormat.getSampleRate(), outFormat.getSampleSizeInBits(), channels, outFormat.getEndian(), outFormat.getSigned(), -1, -1.0, outFormat.getDataType());
        }
        if ((resampler = WASAPIRenderer.maybeOpenResampler(inFormat, outFormat)) == null) {
            throw new IllegalStateException("Failed to open a codec to resample [" + inFormat + "] into [" + outFormat + "].");
        }
        this.resampler = resampler;
        this.resamplerInBuffer = new Buffer();
        this.resamplerInBuffer.setFormat(inFormat);
        this.resamplerChannels = outFormat.getChannels();
        this.resamplerSampleSize = WASAPISystem.getSampleSizeInBytes(outFormat);
        this.resamplerFrameSize = this.resamplerChannels * this.resamplerSampleSize;
        this.resamplerData = new byte[this.numBufferFrames * this.resamplerFrameSize];
        this.resamplerOutBuffer = new Buffer();
        this.resamplerOutBuffer.setData(this.resamplerData);
        this.resamplerOutBuffer.setLength(0);
        this.resamplerOutBuffer.setOffset(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeResample(int numFramesRequested) {
        int outFrames;
        int outLength = this.resamplerOutBuffer.getLength();
        if (outLength < numFramesRequested * this.resamplerFrameSize && (outFrames = (this.resamplerData.length - outLength) / this.resamplerFrameSize) > 0) {
            int dstSampleRate;
            int srcSampleRate = (int)this.srcFormat.getSampleRate();
            int inLength = outFrames * srcSampleRate / (dstSampleRate = (int)this.dstFormat.getSampleRate()) * this.srcFrameSize;
            if (inLength > this.srcBuffer.length) {
                inLength = this.srcBuffer.length;
            }
            if (inLength > this.srcBufferLength) {
                inLength = this.srcBufferLength;
            }
            if (inLength > 0) {
                int resampled;
                this.resamplerOutBuffer.setLength(0);
                this.resamplerOutBuffer.setOffset(outLength);
                try {
                    this.resamplerOutBuffer.setDiscard(false);
                    this.resamplerInBuffer.setLength(inLength);
                    this.resamplerInBuffer.setOffset(0);
                    this.resampler.process(this.resamplerInBuffer, this.resamplerOutBuffer);
                }
                finally {
                    resampled = this.resamplerOutBuffer.getLength();
                    outLength = this.resamplerOutBuffer.getOffset() + resampled;
                    this.resamplerOutBuffer.setLength(outLength);
                    this.resamplerOutBuffer.setOffset(0);
                }
                if (resampled > 0 && (resampled = resampled / this.resamplerFrameSize * srcSampleRate / dstSampleRate * this.srcFrameSize) > 0) {
                    this.popFromSrcBuffer(resampled);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void open() throws ResourceUnavailableException {
        block25: {
            if (this.iAudioClient != 0L) {
                return;
            }
            MediaLocator locator = null;
            try {
                locator = this.getLocator();
                this.locatorIsNull = locator == null;
                if (this.locatorIsNull) break block25;
                AudioFormat[] formats = this.getFormatsToInitializeIAudioClient();
                long eventHandle = WASAPI.CreateEvent(0L, false, false, null);
                try {
                    long iAudioClient = ((WASAPISystem)this.audioSystem).initializeIAudioClient(locator, this.dataFlow, 0, eventHandle, 20L, formats);
                    if (iAudioClient == 0L) {
                        throw new ResourceUnavailableException("Failed to initialize IAudioClient for MediaLocator " + locator + " and AudioSystem.DataFlow " + (Object)((Object)this.dataFlow));
                    }
                    try {
                        long iAudioRenderClient = WASAPI.IAudioClient_GetService(iAudioClient, "{f294acfc-3146-4483-a7bf-addca7c260e2}");
                        if (iAudioRenderClient == 0L) {
                            throw new ResourceUnavailableException("IAudioClient_GetService(IID_IAudioRenderClient)");
                        }
                        try {
                            int srcBufferCapacityInFrames;
                            this.srcFormat = (AudioFormat)this.inputFormat;
                            this.dstFormat = WASAPIRenderer.findFirst(formats);
                            this.devicePeriod = WASAPI.IAudioClient_GetDefaultDevicePeriod(iAudioClient) / 10000L;
                            this.numBufferFrames = WASAPI.IAudioClient_GetBufferSize(iAudioClient);
                            int dstSampleRate = (int)this.dstFormat.getSampleRate();
                            this.bufferDuration = (long)this.numBufferFrames * 1000L / (long)dstSampleRate;
                            if (this.devicePeriod <= 1L) {
                                this.devicePeriod = this.bufferDuration / 2L;
                                if (this.devicePeriod > 10L || this.devicePeriod <= 1L) {
                                    this.devicePeriod = 10L;
                                }
                            }
                            this.devicePeriodInFrames = (int)(this.devicePeriod * (long)dstSampleRate / 1000L);
                            this.dstChannels = this.dstFormat.getChannels();
                            this.dstSampleSize = WASAPISystem.getSampleSizeInBytes(this.dstFormat);
                            this.maybeOpenResampler();
                            this.srcChannels = this.srcFormat.getChannels();
                            this.srcSampleSize = WASAPISystem.getSampleSizeInBytes(this.srcFormat);
                            this.srcFrameSize = this.srcSampleSize * this.srcChannels;
                            if (this.resampler == null) {
                                srcBufferCapacityInFrames = this.numBufferFrames;
                            } else {
                                int srcSampleRate = (int)this.srcFormat.getSampleRate();
                                srcBufferCapacityInFrames = this.numBufferFrames * srcSampleRate / dstSampleRate;
                            }
                            this.srcBuffer = new byte[srcBufferCapacityInFrames * this.srcFrameSize];
                            if (this.resamplerInBuffer != null) {
                                this.resamplerInBuffer.setData(this.srcBuffer);
                            }
                            this.srcBufferLength = this.srcBuffer.length;
                            this.writeIsMalfunctioningSince = 0L;
                            this.writeIsMalfunctioningTimeout = 2L * Math.max(this.bufferDuration, this.devicePeriod);
                            this.eventHandle = eventHandle;
                            eventHandle = 0L;
                            this.iAudioClient = iAudioClient;
                            iAudioClient = 0L;
                            this.iAudioRenderClient = iAudioRenderClient;
                            iAudioRenderClient = 0L;
                        }
                        finally {
                            if (iAudioRenderClient != 0L) {
                                WASAPI.IAudioRenderClient_Release(iAudioRenderClient);
                            }
                        }
                    }
                    finally {
                        if (iAudioClient != 0L) {
                            WASAPI.IAudioClient_Release(iAudioClient);
                            this.maybeCloseResampler();
                        }
                    }
                }
                finally {
                    if (eventHandle != 0L) {
                        WASAPI.CloseHandle(eventHandle);
                    }
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.error("Failed to open a WASAPIRenderer on audio endpoint device " + this.toString(locator), t);
                if (t instanceof ResourceUnavailableException) {
                    throw (ResourceUnavailableException)t;
                }
                ResourceUnavailableException rue = new ResourceUnavailableException();
                rue.initCause(t);
                throw rue;
            }
        }
        super.open();
    }

    @Override
    protected synchronized void playbackDevicePropertyChange(PropertyChangeEvent ev) {
        boolean open;
        this.waitWhileBusy();
        boolean bl = open = this.iAudioClient != 0L && this.iAudioRenderClient != 0L || this.locatorIsNull;
        if (open) {
            boolean start = this.started;
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException rue) {
                throw new UndeclaredThrowableException(rue);
            }
            if (start) {
                this.start();
            }
        }
    }

    private void popFromSrcBuffer(int length) {
        this.srcBufferLength = WASAPIRenderer.pop(this.srcBuffer, this.srcBufferLength, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int process(Buffer buffer) {
        long sleep;
        int ret;
        block57: {
            int length = buffer.getLength();
            if (length < 1) {
                return 0;
            }
            byte[] data = (byte[])buffer.getData();
            int offset = buffer.getOffset();
            WASAPIRenderer wASAPIRenderer = this;
            synchronized (wASAPIRenderer) {
                if (this.iAudioClient == 0L || this.iAudioRenderClient == 0L) {
                    return this.locatorIsNull ? 0 : 1;
                }
                if (!this.started) {
                    return 1;
                }
                this.waitWhileBusy();
                this.busy = true;
            }
            ret = 0;
            sleep = 0L;
            try {
                long writeIsMalfunctioningDuration;
                int numPaddingFrames;
                if (this.eventHandle == 0L) {
                    try {
                        numPaddingFrames = WASAPI.IAudioClient_GetCurrentPadding(this.iAudioClient);
                    }
                    catch (HResultException hre) {
                        numPaddingFrames = 0;
                        ret = 1;
                        logger.error("IAudioClient_GetCurrentPadding", hre);
                    }
                } else {
                    numPaddingFrames = this.numBufferFrames;
                }
                if (ret == true) break block57;
                int numFramesRequested = this.numBufferFrames - numPaddingFrames;
                if (numFramesRequested == 0) {
                    if (this.eventHandle == 0L) {
                        ret |= 2;
                        sleep = this.devicePeriod;
                        if (this.writeIsMalfunctioningSince == 0L) {
                            this.setWriteIsMalfunctioning(true);
                        }
                    } else {
                        int toCopy = this.srcBuffer.length - this.srcBufferLength;
                        if (toCopy > 0) {
                            if (toCopy > length) {
                                toCopy = length;
                            }
                            System.arraycopy(data, offset, this.srcBuffer, this.srcBufferLength, toCopy);
                            this.srcBufferLength += toCopy;
                            if (length > toCopy) {
                                buffer.setLength(length - toCopy);
                                buffer.setOffset(offset + toCopy);
                                ret |= 2;
                            }
                            if (this.writeIsMalfunctioningSince != 0L) {
                                this.setWriteIsMalfunctioning(false);
                            }
                        } else {
                            ret |= 2;
                            sleep = this.devicePeriod;
                            if (this.writeIsMalfunctioningSince == 0L) {
                                this.setWriteIsMalfunctioning(true);
                            }
                        }
                    }
                } else {
                    int written;
                    int effectiveOffset;
                    byte[] effectiveData;
                    int effectiveLength = this.srcBufferLength + length;
                    int toWrite = Math.min(effectiveLength, numFramesRequested * this.srcFrameSize);
                    if (this.srcBufferLength > 0) {
                        effectiveData = this.srcBuffer;
                        effectiveOffset = 0;
                        int toCopy = toWrite - this.srcBufferLength;
                        if (toCopy <= 0) {
                            ret |= 2;
                        } else {
                            if (toCopy > length) {
                                toCopy = length;
                            }
                            System.arraycopy(data, offset, this.srcBuffer, this.srcBufferLength, toCopy);
                            this.srcBufferLength += toCopy;
                            if (toWrite > this.srcBufferLength) {
                                toWrite = this.srcBufferLength;
                            }
                            if (length > toCopy) {
                                buffer.setLength(length - toCopy);
                                buffer.setOffset(offset + toCopy);
                                ret |= 2;
                            }
                        }
                    } else {
                        effectiveData = data;
                        effectiveOffset = offset;
                    }
                    if (toWrite / this.srcFrameSize == 0) {
                        written = 0;
                    } else {
                        GainControl gainControl = this.getGainControl();
                        if (gainControl != null) {
                            BasicVolumeControl.applyGain(gainControl, effectiveData, effectiveOffset, toWrite);
                        }
                        try {
                            written = WASAPI.IAudioRenderClient_Write(this.iAudioRenderClient, effectiveData, effectiveOffset, toWrite, this.srcSampleSize, this.srcChannels, this.dstSampleSize, this.dstChannels);
                        }
                        catch (HResultException hre) {
                            written = 0;
                            ret = 1;
                            logger.error("IAudioRenderClient_Write", hre);
                        }
                    }
                    if (ret != 1) {
                        if (effectiveData == data) {
                            if (written == 0) {
                                System.arraycopy(data, offset, this.srcBuffer, this.srcBufferLength, toWrite);
                                this.srcBufferLength += toWrite;
                                written = toWrite;
                            }
                            if (length > written) {
                                buffer.setLength(length - written);
                                buffer.setOffset(offset + written);
                                ret |= 2;
                            }
                        } else if (written > 0) {
                            this.popFromSrcBuffer(written);
                        }
                        if (this.writeIsMalfunctioningSince != 0L) {
                            this.setWriteIsMalfunctioning(false);
                        }
                    }
                }
                if ((ret & 2) == 2 && this.writeIsMalfunctioningSince != 0L && (writeIsMalfunctioningDuration = System.currentTimeMillis() - this.writeIsMalfunctioningSince) > this.writeIsMalfunctioningTimeout) {
                    this.srcBufferLength = 0;
                    ret = 1;
                    logger.warn("Audio endpoint device appears to be malfunctioning: " + this.getLocator());
                }
            }
            finally {
                WASAPIRenderer numPaddingFrames = this;
                synchronized (numPaddingFrames) {
                    this.busy = false;
                    this.notifyAll();
                }
            }
        }
        if ((ret & 2) == 2 && sleep > 0L) {
            boolean interrupted = false;
            WASAPIRenderer wASAPIRenderer = this;
            synchronized (wASAPIRenderer) {
                try {
                    this.wait(sleep);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runInEventHandleCmd(Runnable eventHandleCmd) {
        try {
            int wfso;
            WASAPIRenderer.useAudioThreadPriority();
            do {
                long eventHandle;
                WASAPIRenderer wASAPIRenderer = this;
                synchronized (wASAPIRenderer) {
                    if (!eventHandleCmd.equals(this.eventHandleCmd)) {
                        return;
                    }
                    if (this.iAudioClient == 0L || this.iAudioRenderClient == 0L || !this.started) {
                        return;
                    }
                    eventHandle = this.eventHandle;
                    if (eventHandle == 0L) {
                        throw new IllegalStateException("eventHandle");
                    }
                    this.waitWhileBusy();
                    this.busy = true;
                }
                try {
                    int numPaddingFrames;
                    try {
                        numPaddingFrames = WASAPI.IAudioClient_GetCurrentPadding(this.iAudioClient);
                    }
                    catch (HResultException hre) {
                        numPaddingFrames = this.numBufferFrames;
                        logger.error("IAudioClient_GetCurrentPadding", hre);
                    }
                    int numFramesRequested = this.numBufferFrames - numPaddingFrames;
                    if (numFramesRequested > 0) {
                        int written;
                        GainControl gainControl;
                        int silence;
                        int toWrite;
                        int bufSampleSize;
                        int bufLength;
                        int bufFrameSize;
                        int bufChannels;
                        byte[] buf;
                        if (this.resampler == null) {
                            buf = this.srcBuffer;
                            bufChannels = this.srcChannels;
                            bufFrameSize = this.srcFrameSize;
                            bufLength = this.srcBufferLength;
                            bufSampleSize = this.srcSampleSize;
                        } else {
                            this.maybeResample(numFramesRequested);
                            buf = this.resamplerData;
                            bufChannels = this.resamplerChannels;
                            bufFrameSize = this.resamplerFrameSize;
                            bufLength = this.resamplerOutBuffer.getLength();
                            bufSampleSize = this.resamplerSampleSize;
                        }
                        int bufFrames = bufLength / bufFrameSize;
                        if (numFramesRequested > bufFrames && bufFrames >= this.devicePeriodInFrames) {
                            numFramesRequested = bufFrames;
                        }
                        if ((toWrite = numFramesRequested * bufFrameSize) > buf.length) {
                            toWrite = buf.length;
                        }
                        if ((silence = toWrite - bufLength) > 0) {
                            Arrays.fill(buf, bufLength, toWrite, (byte)0);
                            bufLength = toWrite;
                        }
                        if ((gainControl = this.getGainControl()) != null && toWrite != 0) {
                            BasicVolumeControl.applyGain(gainControl, buf, 0, toWrite);
                        }
                        if ((written = this.maybeIAudioRenderClientWrite(buf, 0, toWrite, bufSampleSize, bufChannels)) != 0) {
                            bufLength = WASAPIRenderer.pop(buf, bufLength, written);
                            if (buf == this.srcBuffer) {
                                this.srcBufferLength = bufLength;
                            } else {
                                this.resamplerOutBuffer.setLength(bufLength);
                            }
                            if (this.writeIsMalfunctioningSince != 0L) {
                                this.setWriteIsMalfunctioning(false);
                            }
                        }
                    }
                }
                finally {
                    WASAPIRenderer numPaddingFrames = this;
                    synchronized (numPaddingFrames) {
                        this.busy = false;
                        this.notifyAll();
                    }
                }
                try {
                    wfso = WASAPI.WaitForSingleObject(eventHandle, this.devicePeriod);
                }
                catch (HResultException hre) {
                    wfso = -1;
                    logger.error("WaitForSingleObject", hre);
                }
                if (wfso == -1) return;
            } while (wfso != 128);
            return;
        }
        finally {
            WASAPIRenderer wASAPIRenderer = this;
            synchronized (wASAPIRenderer) {
                if (eventHandleCmd.equals(this.eventHandleCmd)) {
                    this.eventHandleCmd = null;
                    this.notifyAll();
                }
            }
        }
    }

    @Override
    public synchronized Format setInputFormat(Format format) {
        if (this.iAudioClient != 0L || this.iAudioRenderClient != 0L) {
            return null;
        }
        return super.setInputFormat(format);
    }

    private void setWriteIsMalfunctioning(boolean writeIsMalfunctioning) {
        if (writeIsMalfunctioning) {
            if (this.writeIsMalfunctioningSince == 0L) {
                this.writeIsMalfunctioningSince = System.currentTimeMillis();
            }
        } else {
            this.writeIsMalfunctioningSince = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        block16: {
            if (this.iAudioClient == 0L) {
                if (this.locatorIsNull) {
                    this.started = true;
                }
            } else {
                this.waitWhileBusy();
                this.waitWhileEventHandleCmd();
                if (this.srcBuffer != null) {
                    int silence;
                    if (this.srcBufferLength > 0) {
                        int i = this.srcBuffer.length - 1;
                        for (int j = this.srcBufferLength - 1; j >= 0; --j) {
                            this.srcBuffer[i] = this.srcBuffer[j];
                            --i;
                        }
                    } else if (this.srcBufferLength < 0) {
                        this.srcBufferLength = 0;
                    }
                    if ((silence = this.srcBuffer.length - this.srcBufferLength) > 0) {
                        Arrays.fill(this.srcBuffer, 0, silence, (byte)0);
                    }
                    this.srcBufferLength = this.srcBuffer.length;
                }
                try {
                    WASAPI.IAudioClient_Start(this.iAudioClient);
                    this.started = true;
                    if (this.eventHandle == 0L || this.eventHandleCmd != null) break block16;
                    Runnable eventHandleCmd = new Runnable(){

                        @Override
                        public void run() {
                            WASAPIRenderer.this.runInEventHandleCmd(this);
                        }
                    };
                    boolean submitted = false;
                    try {
                        if (this.eventHandleExecutor == null) {
                            this.eventHandleExecutor = Executors.newSingleThreadExecutor();
                        }
                        this.eventHandleCmd = eventHandleCmd;
                        this.eventHandleExecutor.execute(eventHandleCmd);
                        submitted = true;
                    }
                    finally {
                        if (!submitted && eventHandleCmd.equals(this.eventHandleCmd)) {
                            this.eventHandleCmd = null;
                        }
                    }
                }
                catch (HResultException hre) {
                    if (hre.getHResult() == WASAPI.AUDCLNT_E_NOT_STOPPED) break block16;
                    logger.error("IAudioClient_Start", hre);
                }
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.iAudioClient == 0L) {
            if (this.locatorIsNull) {
                this.started = false;
            }
        } else {
            this.waitWhileBusy();
            try {
                WASAPI.IAudioClient_Stop(this.iAudioClient);
                this.started = false;
                this.waitWhileEventHandleCmd();
                this.writeIsMalfunctioningSince = 0L;
            }
            catch (HResultException hre) {
                logger.error("IAudioClient_Stop", hre);
            }
        }
    }

    private String toString(MediaLocator locator) {
        String s;
        if (locator == null) {
            s = "null";
        } else {
            block9: {
                s = null;
                try {
                    String id = locator.getRemainder();
                    if (id != null) {
                        String name;
                        CaptureDeviceInfo2 cdi2 = ((WASAPISystem)this.audioSystem).getDevice(this.dataFlow, locator);
                        if (cdi2 != null && (name = cdi2.getName()) != null && !id.equals(name)) {
                            s = id + " with friendly name " + name;
                        }
                        if (s == null) {
                            s = id;
                        }
                    }
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (!(t instanceof ThreadDeath)) break block9;
                    throw (ThreadDeath)t;
                }
            }
            if (s == null) {
                s = locator.toString();
            }
        }
        return s;
    }

    private synchronized void waitWhileBusy() {
        boolean interrupted = false;
        while (this.busy) {
            try {
                this.wait(this.devicePeriod);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void waitWhileEventHandleCmd() {
        if (this.eventHandle == 0L) {
            throw new IllegalStateException("eventHandle");
        }
        boolean interrupted = false;
        while (this.eventHandleCmd != null) {
            try {
                this.wait(this.devicePeriod);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

