/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import org.jitsi.service.neomedia.device.ScreenDevice;

public class ScreenDeviceImpl
implements ScreenDevice {
    private static final ScreenDevice[] EMPTY_SCREEN_DEVICE_ARRAY = new ScreenDevice[0];
    private final int index;
    private final GraphicsDevice screen;

    public static ScreenDevice[] getAvailableScreenDevices() {
        GraphicsDevice[] devices;
        GraphicsEnvironment ge;
        try {
            ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            ge = null;
        }
        ScreenDevice[] screens = null;
        if (ge != null && !ge.isHeadlessInstance() && (devices = ge.getScreenDevices()) != null && devices.length != 0) {
            screens = new ScreenDevice[devices.length];
            int i = 0;
            for (GraphicsDevice dev : devices) {
                screens[i] = new ScreenDeviceImpl(i, dev);
                ++i;
            }
        }
        return screens == null ? EMPTY_SCREEN_DEVICE_ARRAY : screens;
    }

    public static ScreenDevice getDefaultScreenDevice() {
        int width = 0;
        int height = 0;
        ScreenDevice best = null;
        for (ScreenDevice screen : ScreenDeviceImpl.getAvailableScreenDevices()) {
            Dimension size = screen.getSize();
            if (size == null || width >= size.width && height >= size.height) continue;
            width = size.width;
            height = size.height;
            best = screen;
        }
        return best;
    }

    protected ScreenDeviceImpl(int index, GraphicsDevice screen) {
        this.index = index;
        this.screen = screen;
    }

    @Override
    public boolean containsPoint(Point p) {
        return this.screen.getDefaultConfiguration().getBounds().contains(p);
    }

    public Rectangle getBounds() {
        return this.screen.getDefaultConfiguration().getBounds();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.screen.getIDstring();
    }

    @Override
    public Dimension getSize() {
        DisplayMode displayMode = this.screen.getDisplayMode();
        return displayMode == null ? null : new Dimension(displayMode.getWidth(), displayMode.getHeight());
    }
}

