/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.EnergyFLP;
import org.jitsi.impl.neomedia.codec.audio.silk.LPCAnalysisFilterFLP;

public class ResidualEnergyFLP {
    static final int MAX_ITERATIONS_RESIDUAL_NRG = 10;
    static final float REGULARIZATION_FACTOR = 1.0E-8f;

    static float SKP_Silk_residual_energy_covar_FLP(float[] c, int c_offset, float[] wXX, int wXX_offset, float[] wXx, float wxx, int D) {
        int k;
        float nrg = 0.0f;
        assert (D >= 0);
        float regularization = 1.0E-8f * (wXX[wXX_offset + 0] + wXX[wXX_offset + D * D - 1]);
        for (k = 0; k < 10; ++k) {
            int i;
            nrg = wxx;
            float tmp = 0.0f;
            for (i = 0; i < D; ++i) {
                tmp += wXx[i] * c[c_offset + i];
            }
            nrg -= 2.0f * tmp;
            for (i = 0; i < D; ++i) {
                tmp = 0.0f;
                for (int j = i + 1; j < D; ++j) {
                    tmp += wXX[wXX_offset + i + j * D] * c[c_offset + j];
                }
                nrg += c[c_offset + i] * (2.0f * tmp + wXX[wXX_offset + i + D * i] * c[c_offset + i]);
            }
            if (nrg > 0.0f) break;
            for (i = 0; i < D; ++i) {
                int n = wXX_offset + i + D * i;
                wXX[n] = wXX[n] + regularization;
            }
            regularization *= 2.0f;
        }
        if (k == 10) {
            assert (nrg == 0.0f);
            nrg = 1.0f;
        }
        return nrg;
    }

    static void SKP_Silk_residual_energy_FLP(float[] nrgs, float[] x, float[][] a, float[] gains, int subfr_length, int LPC_order) {
        float[] LPC_res;
        float[] LPC_res_ptr = LPC_res = new float[272];
        int LPC_res_ptr_offset = LPC_order;
        int shift = LPC_order + subfr_length;
        LPCAnalysisFilterFLP.SKP_Silk_LPC_analysis_filter_FLP(LPC_res, a[0], x, 0 + 0 * shift, 2 * shift, LPC_order);
        nrgs[0] = (float)((double)(gains[0] * gains[0]) * EnergyFLP.SKP_Silk_energy_FLP(LPC_res_ptr, LPC_res_ptr_offset + 0 * shift, subfr_length));
        nrgs[1] = (float)((double)(gains[1] * gains[1]) * EnergyFLP.SKP_Silk_energy_FLP(LPC_res_ptr, LPC_res_ptr_offset + 1 * shift, subfr_length));
        LPCAnalysisFilterFLP.SKP_Silk_LPC_analysis_filter_FLP(LPC_res, a[1], x, 0 + 2 * shift, 2 * shift, LPC_order);
        nrgs[2] = (float)((double)(gains[2] * gains[2]) * EnergyFLP.SKP_Silk_energy_FLP(LPC_res_ptr, LPC_res_ptr_offset + 0 * shift, subfr_length));
        nrgs[3] = (float)((double)(gains[3] * gains[3]) * EnergyFLP.SKP_Silk_energy_FLP(LPC_res_ptr, LPC_res_ptr_offset + 1 * shift, subfr_length));
    }
}

