/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.silk.DecAPI;
import org.jitsi.impl.neomedia.codec.audio.silk.JavaEncoder;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_SILK_SDK_DecControlStruct;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_decoder_state;
import org.jitsi.service.neomedia.control.FECDecoderControl;
import org.jitsi.util.Logger;

public class JavaDecoder
extends AbstractCodec2 {
    static final int FRAME_DURATION = 20;
    private static final int MAX_FRAMES_PER_PAYLOAD = 5;
    private static final Format[] SUPPORTED_INPUT_FORMATS = JavaEncoder.SUPPORTED_OUTPUT_FORMATS;
    private static final Format[] SUPPORTED_OUTPUT_FORMATS = JavaEncoder.SUPPORTED_INPUT_FORMATS;
    private SKP_SILK_SDK_DecControlStruct decControl;
    private SKP_Silk_decoder_state decState;
    private short frameLength;
    private int framesPerPayload;
    private long lastSeqNo = 0x7FFFFFFFFFFFFFFEL;
    private short[] lbrrBytes = new short[1];
    private byte[] lbrrData = new byte[250];
    private final Logger logger = Logger.getLogger(JavaDecoder.class);
    private int nbFECDecoded = 0;
    private int nbFECNotDecoded = 0;
    private int nbPacketsDecoded = 0;
    private int nbPacketsLost = 0;
    private final short[] outLength = new short[1];

    public JavaDecoder() {
        super("SILK Decoder", AudioFormat.class, SUPPORTED_OUTPUT_FORMATS);
        this.features = 0x3000000;
        this.inputFormats = SUPPORTED_INPUT_FORMATS;
        this.addControl(new Stats());
    }

    @Override
    protected void doClose() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Packets decoded normally: " + this.nbPacketsDecoded);
            this.logger.debug("Packets decoded with FEC: " + this.nbFECDecoded);
            this.logger.debug("Packets lost (subsequent missing):" + this.nbPacketsLost);
            this.logger.debug("Packets lost (no FEC in subsequent): " + this.nbFECNotDecoded);
        }
        this.decState = null;
        this.decControl = null;
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.decState = new SKP_Silk_decoder_state();
        if (DecAPI.SKP_Silk_SDK_InitDecoder(this.decState) != 0) {
            throw new ResourceUnavailableException("DecAPI.SKP_Silk_SDK_InitDecoder");
        }
        AudioFormat inputFormat = (AudioFormat)this.getInputFormat();
        double sampleRate = inputFormat.getSampleRate();
        int channels = inputFormat.getChannels();
        this.decControl = new SKP_SILK_SDK_DecControlStruct();
        this.decControl.API_sampleRate = (int)sampleRate;
        this.frameLength = (short)(20.0 * sampleRate * (double)channels / 1000.0);
        this.lastSeqNo = 0x7FFFFFFFFFFFFFFEL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int doProcess(Buffer inBuf, Buffer outBuf) {
        int processed;
        int lostFlag;
        int outOffset;
        short[] out;
        int inLength;
        int inOffset;
        byte[] in;
        int lostSeqNoCount;
        long seqNo;
        block21: {
            boolean decodeFEC;
            seqNo = inBuf.getSequenceNumber();
            if ((4 & inBuf.getFlags()) != 0) {
                this.lastSeqNo = seqNo;
                return 4;
            }
            lostSeqNoCount = JavaDecoder.calculateLostSeqNoCount(this.lastSeqNo, seqNo);
            boolean bl = decodeFEC = lostSeqNoCount > 0 && lostSeqNoCount <= 3;
            if (decodeFEC && (inBuf.getFlags() & 0x10000) != 0) {
                decodeFEC = false;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Not decoding FEC/PLC for " + seqNo + " because of Buffer.FLAG_SKIP_FEC.");
                }
            }
            in = (byte[])inBuf.getData();
            inOffset = inBuf.getOffset();
            inLength = inBuf.getLength();
            out = this.validateShortArraySize(outBuf, this.frameLength);
            outOffset = 0;
            lostFlag = 0;
            if (decodeFEC) {
                this.lbrrBytes[0] = 0;
                DecAPI.SKP_Silk_SDK_search_for_LBRR(in, inOffset, (short)inLength, lostSeqNoCount, this.lbrrData, 0, this.lbrrBytes);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Packet loss detected. Last seen " + this.lastSeqNo + ", current " + seqNo);
                    this.logger.trace("Looking for FEC data, found " + this.lbrrBytes[0] + " bytes");
                }
                this.outLength[0] = this.frameLength;
                if (this.lbrrBytes[0] == 0) {
                    lostFlag = 1;
                    break block21;
                } else {
                    if (DecAPI.SKP_Silk_SDK_Decode(this.decState, this.decControl, 0, this.lbrrData, 0, this.lbrrBytes[0], out, outOffset, this.outLength) == 0) {
                        ++this.nbFECDecoded;
                        outBuf.setDuration(20000000L);
                        outBuf.setLength(this.outLength[0]);
                        outBuf.setOffset(outOffset);
                        outBuf.setFlags(outBuf.getFlags() | 0x1000000);
                        outBuf.setFlags(outBuf.getFlags() & 0xFDFFFFFF);
                        this.lastSeqNo = JavaDecoder.incrementSeqNo(this.lastSeqNo);
                        return 2;
                    }
                    ++this.nbFECNotDecoded;
                    if (lostSeqNoCount != 0) {
                        this.nbPacketsLost += lostSeqNoCount;
                    }
                    this.lastSeqNo = seqNo;
                    return 1;
                }
            }
            if (lostSeqNoCount != 0) {
                this.nbPacketsLost += lostSeqNoCount;
            }
        }
        this.outLength[0] = this.frameLength;
        if (DecAPI.SKP_Silk_SDK_Decode(this.decState, this.decControl, lostFlag, in, inOffset, inLength, out, outOffset, this.outLength) == 0) {
            outBuf.setDuration(20000000L);
            outBuf.setLength(this.outLength[0]);
            outBuf.setOffset(outOffset);
            if (lostFlag == 0) {
                outBuf.setFlags(outBuf.getFlags() & 0xFCFFFFFF);
                if (this.decControl.moreInternalDecoderFrames == 0) {
                    ++this.nbPacketsDecoded;
                    processed = 0;
                } else {
                    ++this.framesPerPayload;
                    if (this.framesPerPayload >= 5) {
                        ++this.nbPacketsDecoded;
                        processed = 0;
                    } else {
                        processed = 2;
                    }
                }
                this.lastSeqNo = seqNo;
            } else {
                outBuf.setFlags(outBuf.getFlags() & 0xFEFFFFFF);
                outBuf.setFlags(outBuf.getFlags() | 0x2000000);
                processed = 2;
                this.lastSeqNo = JavaDecoder.incrementSeqNo(this.lastSeqNo);
            }
        } else {
            processed = 1;
            if (lostFlag == 1) {
                ++this.nbFECNotDecoded;
                if (lostSeqNoCount != 0) {
                    this.nbPacketsLost += lostSeqNoCount;
                }
            }
            this.lastSeqNo = seqNo;
        }
        if ((processed & 2) != 2) {
            this.framesPerPayload = 0;
        }
        return processed;
    }

    @Override
    protected Format[] getMatchingOutputFormats(Format inputFormat) {
        return JavaEncoder.getMatchingOutputFormats(inputFormat, SUPPORTED_INPUT_FORMATS, SUPPORTED_OUTPUT_FORMATS);
    }

    private class Stats
    implements FECDecoderControl {
        private Stats() {
        }

        @Override
        public int fecPacketsDecoded() {
            return JavaDecoder.this.nbFECDecoded;
        }

        @Override
        public Component getControlComponent() {
            return null;
        }
    }
}

