/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec;

import java.util.Map;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.codec.EncodingConfiguration;
import org.jitsi.service.neomedia.format.MediaFormat;

public class EncodingConfigurationImpl
extends EncodingConfiguration {
    public static final boolean G729 = false;

    public EncodingConfigurationImpl() {
        this.initializeFormatPreferences();
    }

    private void initializeFormatPreferences() {
        this.setEncodingPreference("H264", 90000.0, 1100);
        this.setEncodingPreference("H263-1998", 90000.0, 0);
        this.setEncodingPreference("VP8", 90000.0, 0);
        this.setEncodingPreference("JPEG", 90000.0, 950);
        this.setEncodingPreference("H261", 90000.0, 800);
        this.setEncodingPreference("opus", 48000.0, 750);
        this.setEncodingPreference("SILK", 24000.0, 714);
        this.setEncodingPreference("SILK", 16000.0, 713);
        this.setEncodingPreference("G722", 8000.0, 705);
        this.setEncodingPreference("speex", 32000.0, 701);
        this.setEncodingPreference("speex", 16000.0, 700);
        this.setEncodingPreference("PCMU", 8000.0, 650);
        this.setEncodingPreference("PCMA", 8000.0, 600);
        this.setEncodingPreference("iLBC", 8000.0, 500);
        this.setEncodingPreference("GSM", 8000.0, 450);
        this.setEncodingPreference("speex", 8000.0, 352);
        this.setEncodingPreference("G723", 8000.0, 150);
        this.setEncodingPreference("SILK", 12000.0, 0);
        this.setEncodingPreference("SILK", 8000.0, 0);
        this.setEncodingPreference("G729", 8000.0, 0);
        this.setEncodingPreference("telephone-event", 8000.0, 1);
    }

    @Override
    protected void setEncodingPreference(String encoding, double clockRate, int pref) {
        MediaFormat mediaFormat = null;
        for (MediaFormat mf : MediaUtils.getMediaFormats(encoding)) {
            if (mf.getClockRate() != clockRate) continue;
            mediaFormat = mf;
            break;
        }
        if (mediaFormat != null) {
            this.encodingPreferences.put(this.getEncodingPreferenceKey(mediaFormat), pref);
        }
    }

    @Override
    public MediaFormat[] getAllEncodings(MediaType type) {
        return MediaUtils.getMediaFormats(type);
    }

    @Override
    protected int compareEncodingPreferences(MediaFormat enc1, MediaFormat enc2) {
        int res = this.getPriority(enc2) - this.getPriority(enc1);
        if (res == 0 && (res = enc1.getEncoding().compareToIgnoreCase(enc2.getEncoding())) == 0 && (res = Double.compare(enc2.getClockRate(), enc1.getClockRate())) == 0) {
            int index2;
            int index1 = MediaUtils.getMediaFormatIndex(enc1);
            if (index1 != -1 && (index2 = MediaUtils.getMediaFormatIndex(enc2)) != -1) {
                res = index1 - index2;
            }
            if (res == 0) {
                Map<String, String> fmtps1 = enc1.getFormatParameters();
                Map<String, String> fmtps2 = enc2.getFormatParameters();
                int fmtpCount1 = fmtps1 == null ? 0 : fmtps1.size();
                int fmtpCount2 = fmtps2 == null ? 0 : fmtps2.size();
                res = fmtpCount2 - fmtpCount1;
            }
        }
        return res;
    }
}

