/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.configuration.xml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jitsi.impl.configuration.ConfigurationStore;
import org.jitsi.impl.configuration.xml.XMLConfUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.xml.DOMElementWriter;
import org.jitsi.util.xml.XMLException;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLConfigurationStore
implements ConfigurationStore {
    private static final Logger logger = Logger.getLogger(XMLConfigurationStore.class);
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String SYSTEM_ATTRIBUTE_NAME = "system";
    private static final String SYSTEM_ATTRIBUTE_TRUE = "true";
    private Hashtable<String, Object> properties = new Hashtable();
    private Map<String, Object> fileExtractedProperties = new Hashtable<String, Object>();
    private Document propertiesDocument;

    private Map<String, Object> cloneProperties() {
        return (Map)this.properties.clone();
    }

    private Document createPropertiesDocument() {
        if (this.propertiesDocument == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                logger.error("Failed to create a DocumentBuilder", ex);
                return null;
            }
            this.propertiesDocument = builder.newDocument();
            this.propertiesDocument.appendChild(this.propertiesDocument.createElement("sip-communicator"));
        }
        return this.propertiesDocument;
    }

    @Override
    public Object getProperty(String propertyName) {
        Object value = this.properties.get(propertyName);
        if (value instanceof PropertyReference) {
            return ((PropertyReference)value).getValue();
        }
        return value;
    }

    @Override
    public String[] getPropertyNames() {
        Set<String> propertyNames = this.properties.keySet();
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    @Override
    public boolean isSystemProperty(String propertyName) {
        return this.properties.get(propertyName) instanceof PropertyReference;
    }

    private Map<String, Object> loadConfiguration(File file) throws IOException, XMLException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            this.propertiesDocument = file.length() < (long)("<sip-communicator>".length() * 2) ? this.createPropertiesDocument() : builder.parse(file);
            Node root = this.propertiesDocument.getFirstChild();
            Node currentNode = null;
            NodeList children = root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                currentNode = children.item(i);
                if (currentNode.getNodeType() != 1) continue;
                String propertyName = DOMElementWriter.decodeName(currentNode.getNodeName());
                this.loadNode(currentNode, propertyName, props);
            }
            return props;
        }
        catch (SAXException ex) {
            logger.error("Error parsing configuration file", ex);
            throw new XMLException(ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            logger.error("Error finding configuration for default parsers", ex);
            return new Hashtable<String, Object>();
        }
    }

    private void loadNode(Node node, String propertyName, Map<String, Object> props) {
        Node currentNode = null;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            currentNode = children.item(i);
            if (currentNode.getNodeType() != 1) continue;
            String newProp = propertyName + "." + DOMElementWriter.decodeName(currentNode.getNodeName());
            String value = XMLConfUtils.getAttribute(currentNode, ATTRIBUTE_VALUE);
            if (value != null) {
                String propertyType = XMLConfUtils.getAttribute(currentNode, SYSTEM_ATTRIBUTE_NAME);
                if (propertyType != null && propertyType.equals(SYSTEM_ATTRIBUTE_TRUE)) {
                    props.put(newProp, new PropertyReference(newProp));
                    System.setProperty(newProp, value);
                } else {
                    props.put(newProp, value);
                }
            }
            this.loadNode(currentNode, newProp, props);
        }
    }

    private void processNewProperties(Document doc, Map<String, Object> newProperties) {
        for (Map.Entry<String, Object> entry : newProperties.entrySet()) {
            Object value = entry.getValue();
            boolean system = value instanceof PropertyReference;
            if (system) {
                value = ((PropertyReference)value).getValue();
            }
            this.processNewProperty(doc, entry.getKey(), value.toString(), system);
        }
    }

    private void processNewProperty(Document doc, String key, String value, boolean isSystem) {
        StringTokenizer tokenizer = new StringTokenizer(key, ".");
        String[] toks = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            toks[i++] = DOMElementWriter.encodeName(tokenizer.nextToken());
        }
        String nodeName = toks[toks.length - 1];
        Element parent = XMLConfUtils.createLastPathComponent(doc, toks, toks.length - 1);
        Element newNode = XMLConfUtils.findChild(parent, nodeName);
        if (newNode == null) {
            newNode = doc.createElement(nodeName);
            parent.appendChild(newNode);
        }
        newNode.setAttribute(ATTRIBUTE_VALUE, value);
        if (isSystem) {
            newNode.setAttribute(SYSTEM_ATTRIBUTE_NAME, SYSTEM_ATTRIBUTE_TRUE);
        }
    }

    @Override
    public void reloadConfiguration(File file) throws IOException, XMLException {
        this.properties = new Hashtable();
        this.fileExtractedProperties = this.loadConfiguration(file);
        this.properties.putAll(this.fileExtractedProperties);
    }

    @Override
    public void removeProperty(String propertyName) {
        this.properties.remove(propertyName);
        this.fileExtractedProperties.remove(propertyName);
    }

    @Override
    public void setNonSystemProperty(String propertyName, Object property) {
        this.properties.put(propertyName, property);
    }

    @Override
    public void setSystemProperty(String propertyName) {
        this.setNonSystemProperty(propertyName, new PropertyReference(propertyName));
    }

    @Override
    public void storeConfiguration(OutputStream out) {
        if (this.propertiesDocument == null) {
            this.propertiesDocument = this.createPropertiesDocument();
        }
        Node root = this.propertiesDocument.getFirstChild();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentNode = children.item(i);
            if (currentNode.getNodeType() != 1) continue;
            String propertyName = DOMElementWriter.decodeName(currentNode.getNodeName());
            this.updateNode(currentNode, propertyName, this.properties);
        }
        Map<String, Object> newlyAddedProperties = this.cloneProperties();
        for (String propName : this.fileExtractedProperties.keySet()) {
            newlyAddedProperties.remove(propName);
        }
        this.processNewProperties(this.propertiesDocument, newlyAddedProperties);
        XMLUtils.indentedWriteXML(this.propertiesDocument, out);
    }

    private void updateNode(Node node, String propertyName, Map<String, Object> props) {
        Node currentNode = null;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            currentNode = children.item(i);
            if (currentNode.getNodeType() != 1) continue;
            String newProp = propertyName + "." + DOMElementWriter.decodeName(currentNode.getNodeName());
            Attr attr = ((Element)currentNode).getAttributeNode(ATTRIBUTE_VALUE);
            if (attr != null) {
                Object value = props.get(newProp);
                if (value == null) {
                    node.removeChild(currentNode);
                    continue;
                }
                boolean isSystem = value instanceof PropertyReference;
                String prop = isSystem ? ((PropertyReference)value).getValue().toString() : value.toString();
                attr.setNodeValue(prop);
                if (isSystem) {
                    ((Element)currentNode).setAttribute(SYSTEM_ATTRIBUTE_NAME, SYSTEM_ATTRIBUTE_TRUE);
                } else {
                    ((Element)currentNode).removeAttribute(SYSTEM_ATTRIBUTE_NAME);
                }
            }
            this.updateNode(currentNode, newProp, props);
        }
    }

    private static class PropertyReference {
        private final String propertyName;

        public PropertyReference(String propertyName) {
            this.propertyName = propertyName;
        }

        public Object getValue() {
            return System.getProperty(this.propertyName);
        }
    }
}

