/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Codec;
import javax.media.Demultiplexer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Multiplexer;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.protocol.ContentDescriptor;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.PlugInInfo;

public class PlugInUtility {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = false;

    public static PlugInInfo getPlugInInfo(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            if (o instanceof Demultiplexer) {
                Demultiplexer oCast = (Demultiplexer)o;
                ContentDescriptor[] contentDescriptors = oCast.getSupportedInputContentDescriptors();
                Format[] formats = new Format[contentDescriptors.length];
                for (int i = 0; i < contentDescriptors.length; ++i) {
                    formats[i] = contentDescriptors[i];
                }
                return new PlugInInfo(className, formats, new Format[0], 1);
            }
            if (o instanceof Codec) {
                Codec oCast = (Codec)o;
                Format[] inputFormats = oCast.getSupportedInputFormats();
                Format[] outputFormats = oCast.getSupportedOutputFormats(null);
                return new PlugInInfo(className, inputFormats, outputFormats, o instanceof Effect ? 3 : 2);
            }
            if (o instanceof Renderer) {
                Renderer oCast = (Renderer)o;
                Format[] inputFormats = oCast.getSupportedInputFormats();
                return new PlugInInfo(className, inputFormats, new Format[0], 4);
            }
            if (o instanceof Multiplexer) {
                Multiplexer oCast = (Multiplexer)o;
                return new PlugInInfo(className, new Format[0], oCast.getSupportedOutputContentDescriptors(null), 5);
            }
            logger.warning("PlugInUtility: Unknown or unsupported plug-in: " + o.getClass());
            return null;
        }
        catch (Throwable e) {
            logger.log(Level.FINE, "PlugInUtility: Unable to get plugin info for " + className + ": " + e);
            return null;
        }
    }

    public static boolean registerPlugIn(String className) {
        PlugInInfo i = PlugInUtility.getPlugInInfo(className);
        if (i == null) {
            return false;
        }
        try {
            return PlugInManager.addPlugIn(i.className, i.in, i.out, i.type);
        }
        catch (Throwable e) {
            logger.fine("PlugInUtility: Unable to register plugin " + className + ": " + e);
            return false;
        }
    }
}

