/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

public class MediaThread
extends Thread {
    private static ThreadGroup threadGroup;
    static boolean securityPrivilege;
    private static final boolean debug = false;
    private static int controlPriority;
    private static int audioPriority;
    private static int videoPriority;
    private static int networkPriority;
    private static int videoNetworkPriority;
    private static int defaultMaxPriority;
    private String androidThreadPriority;

    public static int getAudioPriority() {
        return audioPriority;
    }

    public static int getControlPriority() {
        return controlPriority;
    }

    public static int getNetworkPriority() {
        return networkPriority;
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup current = null;
        try {
            ThreadGroup g = current = Thread.currentThread().getThreadGroup();
            while (g.getParent() != null) {
                g = g.getParent();
            }
            return g;
        }
        catch (Exception e) {
            return null;
        }
        catch (Error e) {
            return null;
        }
    }

    public static int getVideoNetworkPriority() {
        return videoNetworkPriority;
    }

    public static int getVideoPriority() {
        return videoPriority;
    }

    public MediaThread() {
        this("FMJ Thread");
    }

    public MediaThread(Runnable r) {
        this(r, "FMJ Thread");
    }

    public MediaThread(Runnable r, String name) {
        super(threadGroup, r, name);
    }

    public MediaThread(String name) {
        super(threadGroup, name);
    }

    private void checkPriority(String name, int ask, boolean priv, int got) {
        if (ask != got) {
            System.out.println("MediaThread: " + name + " privilege? " + priv + "  ask pri: " + ask + " got pri:  " + got);
        }
    }

    public void run() {
        block7: {
            if (this.androidThreadPriority != null) {
                try {
                    String javaVmName;
                    String osName = System.getProperty("os.name");
                    if (osName != null && osName.startsWith("Linux") && (javaVmName = System.getProperty("java.vm.name")) != null && javaVmName.equalsIgnoreCase("Dalvik")) {
                        Class<?> androidOsProcess = Class.forName("android.os.Process");
                        int androidThreadPriority = androidOsProcess.getField(this.androidThreadPriority).getInt(null);
                        androidOsProcess.getMethod("setThreadPriority", Integer.class).invoke(null, androidThreadPriority);
                        int priority = 10 - Math.round((float)(androidThreadPriority + 20) / 40.0f * 10.0f);
                        if (priority < 1) {
                            priority = 1;
                        } else if (priority > 10) {
                            priority = 10;
                        }
                        this.setPriority(priority);
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block7;
                    throw (ThreadDeath)t;
                }
            }
        }
        super.run();
    }

    private void useAndroidThreadPriority(String androidThreadPriority) {
        this.androidThreadPriority = androidThreadPriority;
    }

    public void useAudioPriority() {
        this.usePriority(audioPriority);
        this.useAndroidThreadPriority("THREAD_PRIORITY_URGENT_AUDIO");
    }

    public void useControlPriority() {
        this.usePriority(controlPriority);
    }

    public void useNetworkPriority() {
        this.usePriority(networkPriority);
    }

    private void usePriority(int priority) {
        try {
            this.setPriority(priority);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void useVideoNetworkPriority() {
        this.usePriority(videoNetworkPriority);
    }

    public void useVideoPriority() {
        this.usePriority(videoPriority);
        this.useAndroidThreadPriority("THREAD_PRIORITY_URGENT_DISPLAY");
    }

    static {
        securityPrivilege = true;
        controlPriority = 9;
        audioPriority = 5;
        videoPriority = 3;
        networkPriority = audioPriority + 1;
        videoNetworkPriority = networkPriority - 1;
        defaultMaxPriority = 4;
        try {
            defaultMaxPriority = Thread.currentThread().getPriority();
            defaultMaxPriority = Thread.currentThread().getThreadGroup().getMaxPriority();
        }
        catch (Throwable e) {
            securityPrivilege = false;
            controlPriority = defaultMaxPriority;
            audioPriority = defaultMaxPriority;
            videoPriority = defaultMaxPriority - 1;
            networkPriority = defaultMaxPriority;
            videoNetworkPriority = defaultMaxPriority;
        }
        threadGroup = securityPrivilege ? MediaThread.getRootThreadGroup() : null;
    }
}

