/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Demultiplexer;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceStream;
import javax.media.protocol.SourceTransferHandler;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.parser.RawParser;

public class RawStreamParser
extends RawParser {
    protected SourceStream[] streams;
    protected Track[] tracks = null;
    static final String NAME = "Raw stream parser";

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                for (int i = 0; i < this.tracks.length; ++i) {
                    ((FrameTrack)this.tracks[i]).stop();
                }
                this.source.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.source = null;
        }
    }

    public String getName() {
        return NAME;
    }

    public Track[] getTracks() {
        return this.tracks;
    }

    public void open() {
        if (this.tracks != null) {
            return;
        }
        this.tracks = new Track[this.streams.length];
        for (int i = 0; i < this.streams.length; ++i) {
            this.tracks[i] = new FrameTrack(this, (PushSourceStream)this.streams[i], 5);
        }
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        if (!(source instanceof PushDataSource)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        SourceStream[] streams = ((PushDataSource)source).getStreams();
        if (streams == null) {
            throw new IOException("Got a null stream from the DataSource");
        }
        if (streams.length == 0) {
            throw new IOException("Got a empty stream array from the DataSource");
        }
        if (!this.supports(streams)) {
            throw new IncompatibleSourceException("DataSource not supported: " + source);
        }
        this.source = source;
        this.streams = streams;
    }

    public void start() throws IOException {
        this.source.start();
        for (int i = 0; i < this.tracks.length; ++i) {
            ((FrameTrack)this.tracks[i]).start();
        }
    }

    public void stop() {
        try {
            this.source.stop();
            for (int i = 0; i < this.tracks.length; ++i) {
                ((FrameTrack)this.tracks[i]).stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean supports(SourceStream[] streams) {
        return streams[0] != null && streams[0] instanceof PushSourceStream;
    }

    class FrameTrack
    implements Track,
    SourceTransferHandler {
        Demultiplexer parser;
        PushSourceStream pss;
        boolean enabled = true;
        CircularBuffer bufferQ;
        Format format = null;
        TrackListener listener;
        Integer stateReq = new Integer(0);
        boolean stopped = true;

        public FrameTrack(Demultiplexer parser, PushSourceStream pss, int numOfBufs) {
            this.pss = pss;
            pss.setTransferHandler(this);
            this.bufferQ = new CircularBuffer(numOfBufs);
        }

        public Time getDuration() {
            return this.parser.getDuration();
        }

        public Format getFormat() {
            return this.format;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int frameNumber) {
            return new Time(0L);
        }

        public int mapTimeToFrame(Time t) {
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFrame(Buffer buffer) {
            Buffer filled;
            Object object;
            Object object2 = this.stateReq;
            synchronized (object2) {
                if (this.stopped) {
                    buffer.setDiscard(true);
                    buffer.setFormat(this.format);
                    return;
                }
            }
            object2 = this.bufferQ;
            synchronized (object2) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                        object = this.stateReq;
                        synchronized (object) {
                            if (this.stopped) {
                                buffer.setDiscard(true);
                                buffer.setFormat(this.format);
                                return;
                            }
                        }
                    }
                    catch (Exception e) {
                    }
                }
                filled = this.bufferQ.read();
                this.bufferQ.notifyAll();
            }
            byte[] data = (byte[])filled.getData();
            filled.setData(buffer.getData());
            buffer.setData(data);
            buffer.setLength(filled.getLength());
            buffer.setFormat(this.format);
            buffer.setRtpTimeStamp(filled.getRtpTimeStamp());
            buffer.setTimeStamp(-1L);
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
            }
        }

        public void setEnabled(boolean t) {
            if (t) {
                this.pss.setTransferHandler(this);
            } else {
                this.pss.setTransferHandler(null);
            }
            this.enabled = t;
        }

        public void setTrackListener(TrackListener l) {
            this.listener = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.stateReq;
            synchronized (object) {
                this.stopped = false;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            Object object = this.stateReq;
            synchronized (object) {
                this.stopped = true;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferData(PushSourceStream pss) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                while (!this.bufferQ.canWrite()) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception e) {}
                }
                buffer = this.bufferQ.getEmptyBuffer();
                this.bufferQ.notifyAll();
            }
            int size = pss.getMinimumTransferSize();
            byte[] data = (byte[])buffer.getData();
            if (data == null || data.length < size) {
                data = new byte[size];
                buffer.setData(data);
            }
            try {
                int len = pss.read(data, 0, size);
                buffer.setLength(len);
            }
            catch (IOException e) {
                buffer.setDiscard(true);
            }
            CircularBuffer circularBuffer2 = this.bufferQ;
            synchronized (circularBuffer2) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
        }
    }
}

