/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.Owned;
import javax.media.control.PacketSizeControl;
import net.sf.fmj.media.AbstractCodec;

public abstract class AbstractPacketizer
extends AbstractCodec {
    private static final boolean TRACE = false;
    private int packetSize;
    private byte[] packetBuffer;
    private int bytesInPacketBuffer = 0;
    private boolean doNotSpanInputBuffers = false;

    public AbstractPacketizer() {
        this.addControl(new PSC());
    }

    protected int doBuildPacketHeader(Buffer inputBuffer, byte[] packetBuffer) {
        return 0;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int result;
        boolean packetComplete;
        int bytesAvailable;
        int bytesNeededToCompletePacket;
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        if (this.bytesInPacketBuffer == 0) {
            int packetHeaderSize = this.doBuildPacketHeader(inputBuffer, this.packetBuffer);
            this.bytesInPacketBuffer += packetHeaderSize;
        }
        int bytesToCopy = (bytesNeededToCompletePacket = this.packetSize - this.bytesInPacketBuffer) < (bytesAvailable = inputBuffer.getLength()) ? bytesNeededToCompletePacket : bytesAvailable;
        System.arraycopy(inputBuffer.getData(), inputBuffer.getOffset(), this.packetBuffer, this.bytesInPacketBuffer, bytesToCopy);
        this.bytesInPacketBuffer += bytesToCopy;
        inputBuffer.setOffset(inputBuffer.getOffset() + bytesToCopy);
        inputBuffer.setLength(inputBuffer.getLength() - bytesToCopy);
        boolean bl = packetComplete = this.doNotSpanInputBuffers && inputBuffer.getLength() == 0 || this.bytesInPacketBuffer == this.packetSize;
        if (packetComplete) {
            outputBuffer.setData(this.packetBuffer);
            outputBuffer.setOffset(0);
            outputBuffer.setLength(this.bytesInPacketBuffer);
            this.bytesInPacketBuffer = 0;
            result = inputBuffer.getLength() == 0 ? 0 : 2;
        } else {
            result = 4;
        }
        return result;
    }

    protected void setDoNotSpanInputBuffers(boolean doNotSpanInputBuffers) {
        this.doNotSpanInputBuffers = doNotSpanInputBuffers;
    }

    protected void setPacketSize(int packetSize) {
        this.setPacketSizeImpl(packetSize);
    }

    protected void setPacketSizeImpl(int packetSize) {
        this.packetSize = packetSize;
        this.packetBuffer = new byte[packetSize];
    }

    private class PSC
    implements PacketSizeControl,
    Owned {
        private PSC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public Object getOwner() {
            return AbstractPacketizer.this;
        }

        public int getPacketSize() {
            return AbstractPacketizer.this.packetSize;
        }

        public int setPacketSize(int numBytes) {
            AbstractPacketizer.this.setPacketSizeImpl(numBytes);
            return AbstractPacketizer.this.packetSize;
        }
    }
}

