/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.media;

import com.lti.utils.synchronization.CloseableThread;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DeallocateEvent;
import javax.media.MediaTimeSetEvent;
import javax.media.RateChangeEvent;
import javax.media.StartEvent;
import javax.media.StopEvent;
import javax.media.StopTimeChangeEvent;
import javax.media.Time;
import net.sf.fmj.ejmf.toolkit.media.AbstractController;

public class StopTimeMonitor
extends CloseableThread
implements ControllerListener {
    private boolean wokenUp;
    private AbstractController controller;

    public StopTimeMonitor(AbstractController controller, String threadName) {
        this.setName(threadName);
        this.controller = controller;
        controller.addControllerListener(this);
        this.setDaemon(true);
    }

    public synchronized void controllerUpdate(ControllerEvent e) {
        if (e instanceof StopTimeChangeEvent || e instanceof RateChangeEvent || e instanceof MediaTimeSetEvent || e instanceof StartEvent || e instanceof StopEvent && !(e instanceof DeallocateEvent)) {
            this.wokenUp = true;
            this.notifyAll();
        }
    }

    private long getWaitTime(Time stopTime) throws ClockStoppedException {
        long stop = this.controller.mapToTimeBase(stopTime).getNanoseconds();
        long now = this.controller.getTimeBase().getNanoseconds();
        return (stop - now) / 1000000L;
    }

    private synchronized void monitorStopTime() throws InterruptedException {
        while (!this.isClosing()) {
            long waittime;
            Time stopTime;
            while (this.controller.getState() != 600 || (stopTime = this.controller.getStopTime()) == Clock.RESET) {
                this.wait();
            }
            this.wokenUp = false;
            try {
                waittime = this.getWaitTime(stopTime);
            }
            catch (ClockStoppedException e) {
                continue;
            }
            if (waittime > 0L) {
                this.wait(waittime);
            }
            if (this.wokenUp) continue;
            this.controller.stopAtTime();
            this.controller.setStopTime(Clock.RESET);
        }
    }

    public void run() {
        try {
            this.monitorStopTime();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setClosed();
    }
}

