/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

public class InvitationMessage
implements LiveWritable {
    private static final int TYPE_LANGUAGE = 14;
    private static final int TYPE_CHARSET = 13;
    private static final int TYPE_MESSAGE = 12;
    private final Locale language;
    private final String message;

    public static InvitationMessage readInvitationMessage(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        String string = tlvChain.getString(13);
        String string2 = string == null ? tlvChain.getString(12) : tlvChain.getString(12, string);
        String string3 = tlvChain.getString(14);
        Locale locale = string3 == null ? null : new Locale(string3);
        return new InvitationMessage(string2, locale);
    }

    public InvitationMessage(String string) {
        this(string, Locale.getDefault());
    }

    public InvitationMessage(String string, Locale locale) {
        this.language = locale;
        this.message = string;
    }

    public final Locale getLanguage() {
        return this.language;
    }

    public final String getMessage() {
        return this.message;
    }

    public void write(OutputStream outputStream) throws IOException {
        Object object;
        if (this.language != null) {
            object = this.language.getLanguage();
            Tlv.getStringInstance(14, (String)object).write(outputStream);
        }
        if (this.message != null) {
            object = MinimalEncoder.encodeMinimally(this.message);
            String string = ((EncodedStringInfo)object).getCharset();
            Tlv.getStringInstance(13, string).write(outputStream);
            new Tlv(12, ByteBlock.wrap(((EncodedStringInfo)object).getData())).write(outputStream);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof InvitationMessage)) {
            return false;
        }
        InvitationMessage invitationMessage = (InvitationMessage)object;
        if (this.language != null ? !this.language.getLanguage().equals(invitationMessage.language.getLanguage()) : invitationMessage.language != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(invitationMessage.message) : invitationMessage.message != null);
    }

    public int hashCode() {
        int n = this.language != null ? this.language.hashCode() : 0;
        n = 29 * n + (this.message != null ? this.message.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "InvitationMessage: \"" + this.message + "\" (" + (this.language == null ? "language=null" : "in " + this.language.getLanguage()) + ")";
    }
}

