/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.spi.StatisticsAwareService;
import com.hazelcast.util.MapUtil;
import java.util.Map;

class MapStatisticsAwareService
implements StatisticsAwareService {
    private final MapServiceContext mapServiceContext;

    public MapStatisticsAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
    }

    public Map<String, LocalMapStats> getStats() {
        MapServiceContext mapServiceContext = this.mapServiceContext;
        Map<String, MapContainer> mapContainers = mapServiceContext.getMapContainers();
        Map<String, LocalMapStats> mapStats = MapUtil.createHashMap(mapContainers.size());
        for (String mapName : mapContainers.keySet()) {
            LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
            mapStats.put(mapName, localMapStatsProvider.createLocalMapStats(mapName));
        }
        return mapStats;
    }
}

