/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityListener;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.protocol.event.CallPeerSecurityMessageEvent;
import org.jitsi.service.protocol.event.CallPeerSecurityStatusEvent;
import org.jitsi.util.event.PropertyChangeNotifier;

public abstract class AbstractCallPeer<T extends Call, U extends ProtocolProviderService>
extends PropertyChangeNotifier
implements CallPeer {
    private static final Logger logger = Logger.getLogger(AbstractCallPeer.class);
    public static final ConferenceMember[] NO_CONFERENCE_MEMBERS = new ConferenceMember[0];
    private long callDurationStartTime = 0L;
    protected final List<CallPeerConferenceListener> callPeerConferenceListeners = new ArrayList<CallPeerConferenceListener>();
    protected final List<CallPeerListener> callPeerListeners = new ArrayList<CallPeerListener>();
    protected final List<CallPeerSecurityListener> callPeerSecurityListeners = new ArrayList<CallPeerSecurityListener>();
    private boolean conferenceFocus;
    private List<ConferenceMember> conferenceMembers;
    private final Object conferenceMembersSyncRoot = new Object();
    private boolean isMute = false;
    private CallPeerSecurityStatusEvent lastSecurityEvent;
    private CallPeerState state = CallPeerState.UNKNOWN;
    private String alternativeIMPPAddress;
    private List<ConferenceMember> unmodifiableConferenceMembers;

    protected AbstractCallPeer() {
        this.conferenceMembers = Collections.emptyList();
        this.unmodifiableConferenceMembers = Collections.unmodifiableList(this.conferenceMembers);
    }

    @Override
    public String getAlternativeIMPPAddress() {
        return this.alternativeIMPPAddress;
    }

    public void setAlternativeIMPPAddress(String address) {
        this.alternativeIMPPAddress = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallPeerConferenceListener(CallPeerConferenceListener listener) {
        if (listener != null) {
            List<CallPeerConferenceListener> list = this.callPeerConferenceListeners;
            synchronized (list) {
                if (!this.callPeerConferenceListeners.contains(listener)) {
                    this.callPeerConferenceListeners.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallPeerListener(CallPeerListener listener) {
        if (listener == null) {
            return;
        }
        List<CallPeerListener> list = this.callPeerListeners;
        synchronized (list) {
            if (!this.callPeerListeners.contains(listener)) {
                this.callPeerListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallPeerSecurityListener(CallPeerSecurityListener listener) {
        if (listener == null) {
            return;
        }
        List<CallPeerSecurityListener> list = this.callPeerSecurityListeners;
        synchronized (list) {
            if (!this.callPeerSecurityListeners.contains(listener)) {
                this.callPeerSecurityListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConferenceMember(ConferenceMember conferenceMember) {
        if (conferenceMember == null) {
            throw new NullPointerException("conferenceMember");
        }
        Object object = this.conferenceMembersSyncRoot;
        synchronized (object) {
            if (this.conferenceMembers.contains(conferenceMember)) {
                return;
            }
            ArrayList<ConferenceMember> newConferenceMembers = new ArrayList<ConferenceMember>(this.conferenceMembers);
            if (!newConferenceMembers.add(conferenceMember)) {
                return;
            }
            this.conferenceMembers = newConferenceMembers;
            this.unmodifiableConferenceMembers = Collections.unmodifiableList(this.conferenceMembers);
        }
        this.fireCallPeerConferenceEvent(new CallPeerConferenceEvent(this, 2, conferenceMember));
    }

    public void fireConferenceMemberErrorEvent(String errorMessge) {
        if (errorMessge == null || errorMessge.length() == 0) {
            logger.warn((Object)("The error message for " + this.getDisplayName() + " null or empty string."));
            return;
        }
        this.fireCallPeerConferenceEvent(new CallPeerConferenceEvent(this, 4, null, errorMessge));
    }

    protected ConferenceMember findConferenceMember(long ssrc) {
        List<ConferenceMember> members = this.getConferenceMembers();
        int i = 0;
        int memberCount = members.size();
        while (i < memberCount) {
            ConferenceMember member = members.get(i);
            if (member.getAudioSsrc() == ssrc) {
                return member;
            }
            ++i;
        }
        return null;
    }

    protected void fireCallPeerChangeEvent(String eventType, Object oldValue, Object newValue) {
        this.fireCallPeerChangeEvent(eventType, oldValue, newValue, null);
    }

    protected void fireCallPeerChangeEvent(String eventType, Object oldValue, Object newValue, String reason) {
        this.fireCallPeerChangeEvent(eventType, oldValue, newValue, reason, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void fireCallPeerChangeEvent(String eventType, Object oldValue, Object newValue, String reason, int reasonCode) {
        evt = new CallPeerChangeEvent(this, eventType, oldValue, newValue, reason, reasonCode);
        if (AbstractCallPeer.logger.isDebugEnabled()) {
            AbstractCallPeer.logger.debug((Object)("Dispatching a CallPeerChangeEvent event to " + this.callPeerListeners.size() + " listeners. event is: " + evt.toString()));
        }
        listeners = null;
        var8_8 = this.callPeerListeners;
        synchronized (var8_8) {
            listeners = new ArrayList<CallPeerListener>(this.callPeerListeners).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var8_8
            if (true) ** GOTO lbl30
        }
        do {
            listener = listeners.next();
            try {
                if (eventType.equals("CallPeerAddressChange")) {
                    listener.peerAddressChanged(evt);
                    continue;
                }
                if (eventType.equals("CallPeerDisplayNameChange")) {
                    listener.peerDisplayNameChanged(evt);
                    continue;
                }
                if (eventType.equals("CallPeerImageChange")) {
                    listener.peerImageChanged(evt);
                    continue;
                }
                if (!eventType.equals("CallPeerStatusChange")) continue;
                listener.peerStateChanged(evt);
            }
            catch (Throwable t) {
                AbstractCallPeer.logger.error((Object)("Error dispatching event of type" + eventType + " in " + listener), t);
            }
lbl30:
            // 7 sources

        } while (listeners.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCallPeerConferenceEvent(CallPeerConferenceEvent conferenceEvent) {
        CallPeerConferenceListener[] listeners;
        List<CallPeerConferenceListener> list = this.callPeerConferenceListeners;
        synchronized (list) {
            listeners = this.callPeerConferenceListeners.toArray(new CallPeerConferenceListener[this.callPeerConferenceListeners.size()]);
        }
        int eventID = conferenceEvent.getEventID();
        if (logger.isDebugEnabled()) {
            String eventIDString;
            switch (eventID) {
                case 1: {
                    eventIDString = "CONFERENCE_FOCUS_CHANGED";
                    break;
                }
                case 2: {
                    eventIDString = "CONFERENCE_MEMBER_ADDED";
                    break;
                }
                case 3: {
                    eventIDString = "CONFERENCE_MEMBER_REMOVED";
                    break;
                }
                case 4: {
                    eventIDString = "CONFERENCE_MEMBER_ERROR_RECEIVED";
                    break;
                }
                default: {
                    eventIDString = "UNKNOWN";
                }
            }
            logger.debug((Object)("Firing CallPeerConferenceEvent with ID " + eventIDString + " to " + listeners.length + " listeners"));
        }
        CallPeerConferenceListener[] callPeerConferenceListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            CallPeerConferenceListener listener = callPeerConferenceListenerArray[n2];
            switch (eventID) {
                case 1: {
                    listener.conferenceFocusChanged(conferenceEvent);
                    break;
                }
                case 2: {
                    listener.conferenceMemberAdded(conferenceEvent);
                    break;
                }
                case 3: {
                    listener.conferenceMemberRemoved(conferenceEvent);
                    break;
                }
                case 4: {
                    listener.conferenceMemberErrorReceived(conferenceEvent);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void fireCallPeerSecurityMessageEvent(String messageType, String i18nMessage, int severity) {
        evt = new CallPeerSecurityMessageEvent((Object)this, messageType, i18nMessage, severity);
        if (AbstractCallPeer.logger.isDebugEnabled()) {
            AbstractCallPeer.logger.debug((Object)("Dispatching a CallPeerSecurityFailedEvent event to " + this.callPeerSecurityListeners.size() + " listeners. event is: " + evt.toString()));
        }
        listeners = null;
        var6_6 = this.callPeerSecurityListeners;
        synchronized (var6_6) {
            listeners = new ArrayList<CallPeerSecurityListener>(this.callPeerSecurityListeners).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var6_6
            if (true) ** GOTO lbl16
        }
        do {
            listener = listeners.next();
            listener.securityMessageRecieved(evt);
lbl16:
            // 2 sources

        } while (listeners.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCallPeerSecurityNegotiationStartedEvent(CallPeerSecurityNegotiationStartedEvent evt) {
        this.lastSecurityEvent = evt;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a CallPeerSecurityStatusEvent event to " + this.callPeerSecurityListeners.size() + " listeners. event is: " + evt.toString()));
        }
        ArrayList<CallPeerSecurityListener> listeners = null;
        List<CallPeerSecurityListener> list = this.callPeerSecurityListeners;
        synchronized (list) {
            listeners = new ArrayList<CallPeerSecurityListener>(this.callPeerSecurityListeners);
        }
        for (CallPeerSecurityListener listener : listeners) {
            listener.securityNegotiationStarted(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCallPeerSecurityOffEvent(CallPeerSecurityOffEvent evt) {
        this.lastSecurityEvent = evt;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a CallPeerSecurityAuthenticationEvent event to " + this.callPeerSecurityListeners.size() + " listeners. event is: " + evt.toString()));
        }
        ArrayList<CallPeerSecurityListener> listeners = null;
        List<CallPeerSecurityListener> list = this.callPeerSecurityListeners;
        synchronized (list) {
            listeners = new ArrayList<CallPeerSecurityListener>(this.callPeerSecurityListeners);
        }
        for (CallPeerSecurityListener listener : listeners) {
            listener.securityOff(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCallPeerSecurityOnEvent(CallPeerSecurityOnEvent evt) {
        this.lastSecurityEvent = evt;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a CallPeerSecurityStatusEvent event to " + this.callPeerSecurityListeners.size() + " listeners. event is: " + evt.toString()));
        }
        ArrayList<CallPeerSecurityListener> listeners = null;
        List<CallPeerSecurityListener> list = this.callPeerSecurityListeners;
        synchronized (list) {
            listeners = new ArrayList<CallPeerSecurityListener>(this.callPeerSecurityListeners);
        }
        for (CallPeerSecurityListener listener : listeners) {
            listener.securityOn(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCallPeerSecurityTimeoutEvent(CallPeerSecurityTimeoutEvent evt) {
        this.lastSecurityEvent = evt;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dispatching a CallPeerSecurityStatusEvent event to " + this.callPeerSecurityListeners.size() + " listeners. event is: " + evt.toString()));
        }
        ArrayList<CallPeerSecurityListener> listeners = null;
        List<CallPeerSecurityListener> list = this.callPeerSecurityListeners;
        synchronized (list) {
            listeners = new ArrayList<CallPeerSecurityListener>(this.callPeerSecurityListeners);
        }
        for (CallPeerSecurityListener listener : listeners) {
            listener.securityTimeout(evt);
        }
    }

    public abstract T getCall();

    @Override
    public long getCallDurationStartTime() {
        return this.callDurationStartTime;
    }

    @Override
    public URL getCallInfoURL() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConferenceMemberCount() {
        Object object = this.conferenceMembersSyncRoot;
        synchronized (object) {
            return this.isConferenceFocus() ? this.getConferenceMembers().size() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConferenceMember> getConferenceMembers() {
        Object object = this.conferenceMembersSyncRoot;
        synchronized (object) {
            return this.unmodifiableConferenceMembers;
        }
    }

    @Override
    public CallPeerSecurityStatusEvent getCurrentSecuritySettings() {
        return this.lastSecurityEvent;
    }

    public abstract U getProtocolProvider();

    @Override
    public CallPeerState getState() {
        return this.state;
    }

    @Override
    public boolean isConferenceFocus() {
        return this.conferenceFocus;
    }

    @Override
    public boolean isMute() {
        return this.isMute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallPeerConferenceListener(CallPeerConferenceListener listener) {
        if (listener != null) {
            List<CallPeerConferenceListener> list = this.callPeerConferenceListeners;
            synchronized (list) {
                this.callPeerConferenceListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallPeerListener(CallPeerListener listener) {
        if (listener == null) {
            return;
        }
        List<CallPeerListener> list = this.callPeerListeners;
        synchronized (list) {
            this.callPeerListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallPeerSecurityListener(CallPeerSecurityListener listener) {
        if (listener == null) {
            return;
        }
        List<CallPeerSecurityListener> list = this.callPeerSecurityListeners;
        synchronized (list) {
            this.callPeerSecurityListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConferenceMember(ConferenceMember conferenceMember) {
        if (conferenceMember != null) {
            Object object = this.conferenceMembersSyncRoot;
            synchronized (object) {
                ArrayList<ConferenceMember> newConferenceMembers;
                if (this.conferenceMembers.contains(conferenceMember)) {
                    newConferenceMembers = new ArrayList<ConferenceMember>(this.conferenceMembers);
                    if (!newConferenceMembers.remove(conferenceMember)) {
                        return;
                    }
                } else {
                    return;
                }
                this.conferenceMembers = newConferenceMembers;
                this.unmodifiableConferenceMembers = Collections.unmodifiableList(this.conferenceMembers);
            }
            this.fireCallPeerConferenceEvent(new CallPeerConferenceEvent(this, 3, conferenceMember));
        }
    }

    public void setConferenceFocus(boolean conferenceFocus) {
        if (this.conferenceFocus != conferenceFocus) {
            this.conferenceFocus = conferenceFocus;
            this.fireCallPeerConferenceEvent(new CallPeerConferenceEvent(this, 1));
        }
    }

    public void setMute(boolean newMuteValue) {
        this.isMute = newMuteValue;
        this.firePropertyChange("Mute", this.isMute, newMuteValue);
    }

    public void setState(CallPeerState newState) {
        this.setState(newState, null);
    }

    public void setState(CallPeerState newState, String reason) {
        this.setState(newState, reason, -1);
    }

    public void setState(CallPeerState newState, String reason, int reasonCode) {
        CallPeerState oldState = this.getState();
        if (oldState == newState) {
            return;
        }
        this.state = newState;
        if (CallPeerState.CONNECTED.equals(newState) && !CallPeerState.isOnHold(oldState)) {
            this.callDurationStartTime = System.currentTimeMillis();
        }
        this.fireCallPeerChangeEvent("CallPeerStatusChange", oldState, newState, reason, reasonCode);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getDisplayName()) + " <" + this.getAddress() + ">;status=" + this.getState().getStateString();
    }
}

