/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.permission;

import com.hazelcast.security.permission.InstancePermission;

public class SemaphorePermission
extends InstancePermission {
    private static final int ACQUIRE = 4;
    private static final int RELEASE = 8;
    private static final int READ = 22;
    private static final int ALL = 31;

    public SemaphorePermission(String name, String ... actions) {
        super(name, actions);
    }

    @Override
    protected int initMask(String[] actions) {
        int mask = 0;
        for (int i = 0; i < actions.length; ++i) {
            if ("all".equals(actions[i])) {
                return 31;
            }
            if ("create".equals(actions[i])) {
                mask |= 1;
                continue;
            }
            if ("acquire".equals(actions[i])) {
                mask |= 4;
                continue;
            }
            if ("release".equals(actions[i])) {
                mask |= 8;
                continue;
            }
            if ("destroy".equals(actions[i])) {
                mask |= 2;
                continue;
            }
            if (!"read".equals(actions[i])) continue;
            mask |= 0x16;
        }
        return mask;
    }
}

