/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.call;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.UtilActivator;

public class ContactPhoneUtil {
    private static final Logger logger = Logger.getLogger(ContactPhoneUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getContactAdditionalPhones(Contact contact, OperationSetServerStoredContactInfo.DetailsResponseListener listener, boolean onlyVideo, boolean localized) {
        OperationSetServerStoredContactInfo infoOpSet = (OperationSetServerStoredContactInfo)contact.getProtocolProvider().getOperationSet(OperationSetServerStoredContactInfo.class);
        ArrayList<String> phonesList = new ArrayList<String>();
        if (infoOpSet == null) return phonesList;
        try {
            Iterator details;
            if (listener != null) {
                details = infoOpSet.requestAllDetailsForContact(contact, listener);
                if (details == null) {
                    return null;
                }
            } else {
                details = infoOpSet.getAllDetailsForContact(contact);
            }
            ArrayList<String> phoneNumbers = new ArrayList<String>();
            while (true) {
                ServerStoredDetails.PhoneNumberDetail pnd;
                String number;
                if (!details.hasNext()) {
                    return phonesList;
                }
                ServerStoredDetails.GenericDetail d = (ServerStoredDetails.GenericDetail)details.next();
                if (!(d instanceof ServerStoredDetails.PhoneNumberDetail) || d instanceof ServerStoredDetails.PagerDetail || d instanceof ServerStoredDetails.FaxDetail || (number = (pnd = (ServerStoredDetails.PhoneNumberDetail)d).getNumber()) == null || number.length() <= 0 || !(d instanceof ServerStoredDetails.VideoDetail) && onlyVideo || phoneNumbers.contains(number)) continue;
                phoneNumbers.add(number);
                if (!localized) {
                    phonesList.add(number);
                    continue;
                }
                phonesList.add(String.valueOf(number) + " (" + ContactPhoneUtil.getLocalizedPhoneNumber(d) + ")");
            }
        }
        catch (Throwable t) {
            logger.error("Error obtaining server stored contact info");
        }
        return phonesList;
    }

    protected static String getLocalizedPhoneNumber(ServerStoredDetails.GenericDetail d) {
        if (d instanceof ServerStoredDetails.WorkPhoneDetail) {
            return UtilActivator.getResources().getI18NString("service.gui.WORK_PHONE");
        }
        if (d instanceof ServerStoredDetails.MobilePhoneDetail) {
            return UtilActivator.getResources().getI18NString("service.gui.MOBILE_PHONE");
        }
        if (d instanceof ServerStoredDetails.VideoDetail) {
            return UtilActivator.getResources().getI18NString("service.gui.VIDEO_PHONE");
        }
        return UtilActivator.getResources().getI18NString("service.gui.HOME");
    }
}

