/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sftp;

import com.voxeo.logging.Loggerf;
import com.voxeo.sftp.ISftpClient;
import com.voxeo.sftp.ISftpClientPool;
import java.io.IOException;
import org.apache.commons.pool.ObjectPool;
import org.springframework.beans.factory.annotation.Required;

public class SftpClientPool
implements ISftpClientPool {
    private final Loggerf log = Loggerf.getLogger(SftpClientPool.class);
    private ObjectPool pool;

    public void checkin(ISftpClient client) {
        try {
            if (client != null) {
                this.log.debug("Returning SFTP client %s to pool %s", client, this);
                this.pool.returnObject((Object)client);
            }
        }
        catch (Exception e) {
            this.log.error("Error returning SFTP client %s to pool", client, e);
        }
    }

    public ISftpClient checkout() throws IOException {
        try {
            this.log.debug("Borrowing SSH connection from pool %s", this);
            ISftpClient result = (ISftpClient)this.pool.borrowObject();
            return result;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Required
    public void setPool(ObjectPool pool) {
        this.pool = pool;
    }

    public ObjectPool getPool() {
        return this.pool;
    }
}

