/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtmf;

import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.util.Logger;

public class DtmfRawPacket
extends RawPacket {
    private static final Logger logger = Logger.getLogger(DtmfRawPacket.class);
    private int code;
    private boolean end;
    private int duration;
    private int volume;

    public DtmfRawPacket(byte[] buffer, int offset, int length, byte payload) {
        super(buffer, offset, length);
        this.setPayload(payload);
    }

    public DtmfRawPacket(RawPacket pkt) {
        super(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
        int at = this.getHeaderLength();
        this.code = this.readByte(at++);
        byte b = this.readByte(at++);
        this.end = (b & 0x80) != 0;
        this.volume = b & 0x7F;
        this.duration = (this.readByte(at++) & 0xFF) << 8 | this.readByte(at++) & 0xFF;
    }

    public void init(int code, boolean end, boolean marker, int duration, long timestamp, int volume) {
        if (logger.isTraceEnabled()) {
            logger.trace("DTMF send on RTP, code : " + code + " duration = " + duration + " timestamps = " + timestamp + " Marker = " + marker + " End = " + end);
        }
        this.setMarker(marker);
        this.setTimestamp(timestamp);
        this.setDtmfPayload(code, end, duration, volume);
    }

    private void setDtmfPayload(int code, boolean end, int duration, int volume) {
        this.code = code;
        this.end = end;
        this.duration = duration;
        this.volume = volume;
        int at = this.getHeaderLength();
        this.writeByte(at++, (byte)code);
        this.writeByte(at++, end ? (byte)(volume | 0x80) : (byte)(volume & 0x7F));
        this.writeByte(at++, (byte)(duration >> 8));
        this.writeByte(at++, (byte)duration);
        this.setLength(at);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isEnd() {
        return this.end;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getVolume() {
        return this.volume;
    }
}

