/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class UDPPacketReceiver
implements PacketSource {
    private DatagramSocket sock;
    private int maxsize;
    byte[] dataBuf = new byte[1];

    public UDPPacketReceiver(DatagramSocket sock, int maxsize) {
        this.sock = sock;
        this.maxsize = maxsize;
        try {
            sock.setSoTimeout(5000);
        }
        catch (SocketException e) {
            System.out.println("could not set timeout on socket");
        }
    }

    public UDPPacketReceiver(int localPort, String localAddress, int remotePort, String remoteAddress, int maxsize, DatagramSocket localSocket) throws SocketException, UnknownHostException, IOException {
        InetAddress localInetAddr = InetAddress.getByName(localAddress);
        InetAddress remoteInetAddr = InetAddress.getByName(remoteAddress);
        if (remoteInetAddr.isMulticastAddress()) {
            MulticastSocket sock = new MulticastSocket(remotePort);
            sock.joinGroup(remoteInetAddr);
            this.sock = sock;
            this.maxsize = maxsize;
        } else {
            this.sock = localSocket != null ? localSocket : new DatagramSocket(localPort, localInetAddr);
            if (remoteAddress == null) {
                // empty if block
            }
            this.maxsize = maxsize;
        }
        try {
            this.sock.setSoTimeout(5000);
        }
        catch (SocketException e) {
            System.out.println("could not set timeout on socket");
        }
    }

    public void closeSource() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public DatagramSocket getSocket() {
        return this.sock;
    }

    public Packet receiveFrom() throws IOException {
        DatagramPacket dp;
        int len;
        do {
            if (this.dataBuf.length < this.maxsize) {
                this.dataBuf = new byte[this.maxsize];
            }
            dp = new DatagramPacket(this.dataBuf, this.maxsize);
            this.sock.receive(dp);
            len = dp.getLength();
            if (len <= this.maxsize >> 1) continue;
            this.maxsize = len << 1;
        } while (len >= dp.getData().length);
        UDPPacket p = new UDPPacket();
        p.receiptTime = System.currentTimeMillis();
        p.data = dp.getData();
        p.offset = 0;
        p.length = len;
        p.datagrampacket = dp;
        p.localPort = this.sock.getLocalPort();
        p.remotePort = dp.getPort();
        p.remoteAddress = dp.getAddress();
        return p;
    }

    public String sourceString() {
        String s = "UDP Datagram Packet Receiver on port " + this.sock.getLocalPort() + "on local address " + this.sock.getLocalAddress();
        return s;
    }
}

